/*
 * Decompiled with CFR 0.152.
 */
package team.rusty.util.worldgen.biome;

import java.util.Collections;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;

public abstract class AbstractBiome {
    public static final BiomeSpecialEffects DEFAULT_EFFECTS = new BiomeSpecialEffects.Builder().m_48034_(4159204).m_48037_(329011).m_48019_(12638463).m_48040_(AbstractBiome.calculateSkyColor(0.7f)).m_48027_(AmbientMoodSettings.f_47387_).m_48018_();
    protected Biome.BiomeCategory category = Biome.BiomeCategory.PLAINS;
    protected float depth = 0.1f;
    protected float scale = 0.1f;
    protected BiomeSpecialEffects effects = DEFAULT_EFFECTS;
    protected Biome.Precipitation precipitation = Biome.Precipitation.RAIN;
    protected Biome.TemperatureModifier tempMod = Biome.TemperatureModifier.NONE;
    protected float temperature = 0.0f;
    protected float downfall = 0.0f;

    public static int calculateSkyColor(float temperature) {
        float f = temperature / 3.0f;
        f = Mth.m_14036_((float)f, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - f * 0.05f), (float)(0.5f + f * 0.1f), (float)1.0f);
    }

    public abstract void configure(BiomeGenerationSettingsBuilder var1, MobSpawnSettings.Builder var2);

    public List<SpawnEntry> getSpawnEntries() {
        return Collections.emptyList();
    }

    public Biome.ClimateSettings getClimate() {
        return new Biome.ClimateSettings(this.precipitation, this.temperature, this.tempMod, this.downfall);
    }

    public Biome.BiomeCategory getCategory() {
        return this.category;
    }

    public float getDepth() {
        return this.depth;
    }

    public float getScale() {
        return this.scale;
    }

    public BiomeSpecialEffects getEffects() {
        return this.effects;
    }

    public record SpawnEntry(BiomeManager.BiomeType type, int weight) {
        public static SpawnEntry of(BiomeManager.BiomeType type, int weight) {
            return new SpawnEntry(type, weight);
        }
    }
}

