/*
 * Decompiled with CFR 0.152.
 */
package team.rusty.util.worldgen.biome;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import net.minecraft.core.Registry;
import net.minecraft.data.worldgen.SurfaceBuilders;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import team.rusty.util.worldgen.biome.AbstractBiome;
import team.rusty.util.worldgen.biome.BiomeChecker;

public final class AbstractBiomeRegistry {
    private static final Biome.BiomeBuilder DUMMY = new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.PLAINS).m_47593_(0.1f).m_47607_(0.1f).m_47609_(0.1f).m_47611_(0.1f).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(0).m_48034_(0).m_48037_(0).m_48040_(0).m_48018_()).m_47605_(new MobSpawnSettings.Builder().m_48381_()).m_47601_(new BiomeGenerationSettings.Builder().m_47851_(SurfaceBuilders.f_127276_).m_47831_());
    private final DeferredRegister<Biome> deferredRegister;
    private final String modId;
    private final BiMap<ResourceLocation, AbstractBiome> biomes = HashBiMap.create();

    public AbstractBiomeRegistry(String modId) {
        this.deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)modId);
        this.modId = modId;
    }

    public void register(IEventBus modBus) {
        this.deferredRegister.register(modBus);
        MinecraftForge.EVENT_BUS.addListener(this::applyBiomes);
    }

    public AbstractBiome register(String name, AbstractBiome biome) {
        this.deferredRegister.register(name, () -> ((Biome.BiomeBuilder)DUMMY).m_47592_());
        ResourceLocation biomeId = new ResourceLocation(this.modId, name);
        this.biomes.put((Object)biomeId, (Object)biome);
        if (!FMLEnvironment.production) {
            BiomeChecker.checkClass(biome, biomeId);
        }
        return biome;
    }

    private void applyBiomes(BiomeLoadingEvent event) {
        ResourceLocation biomeId = event.getName();
        AbstractBiome biome = (AbstractBiome)this.biomes.get((Object)biomeId);
        if (biome != null) {
            if (!biome.getSpawnEntries().isEmpty()) {
                ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)biomeId);
                for (AbstractBiome.SpawnEntry entry : biome.getSpawnEntries()) {
                    BiomeManager.addBiome((BiomeManager.BiomeType)entry.type(), (BiomeManager.BiomeEntry)new BiomeManager.BiomeEntry(key, entry.weight()));
                }
            }
            biome.configure(event.getGeneration(), (MobSpawnSettings.Builder)event.getSpawns());
            event.setCategory(biome.getCategory());
            event.setClimate(biome.getClimate());
            event.setDepth(biome.getDepth());
            event.setEffects(biome.getEffects());
            event.setScale(biome.getScale());
        }
    }

    public ResourceLocation getId(AbstractBiome biome) {
        return (ResourceLocation)this.biomes.inverse().get((Object)biome);
    }
}

