/*
 * Decompiled with CFR 0.152.
 */
package team.rusty.util.worldgen.biome;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import team.rusty.util.worldgen.biome.AbstractBiome;

public final class BiomeChecker {
    private static final Map<String, String> WARNINGS = Map.of("addDefaultOres", "Missing overworld ores", "addDefaultUndergroundVariety", "Missing granite, andesite, diorite", "addDefaultSoftDisks", "Missing clay and sand disks", "addDefaultCarvers", "Missing overworld caves and ravines", "addDefaultLakes", "Missing overworld water lakes", "addDefaultCrystalFormations", "Missing overworld geodes", "addDefaultMonsterRoom", "Missing overworld dungeons", "addDefaultSprings", "Missing overworld water and lava springs", "commonSpawns", "Missing overworld hostile/cave mob spawns", "farmAnimals", "Missing overworld farm animal spawns");

    public static void checkClass(AbstractBiome biome, ResourceLocation id) {
        InputStream contents = biome.getClass().getResourceAsStream(biome.getClass().getSimpleName() + ".class");
        try {
            ClassReader reader = new ClassReader(contents);
            ClassNode node = new ClassNode();
            reader.accept((ClassVisitor)node, 0);
            boolean configured = false;
            for (MethodNode method : node.methods) {
                configured = method.name.equals("configure");
                if (!configured) continue;
                List methodCalls = StreamSupport.stream(method.instructions.spliterator(), false).filter(MethodInsnNode.class::isInstance).map(MethodInsnNode.class::cast).filter(insn -> insn.owner.equals("team/rusty/rpg/worldgen/BiomeDefaults")).collect(Collectors.toList());
                for (Map.Entry<String, String> warning : WARNINGS.entrySet()) {
                    if (!methodCalls.stream().noneMatch(insn -> insn.name.equals(warning.getKey()))) continue;
                    System.out.printf("BiomeChecker: %s (use `%s`) for biome \"%s\"\n", warning.getValue(), warning.getKey(), id);
                }
            }
            if (!configured) {
                System.out.println("BiomeChecker: Missing `configure` method on biome " + id);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

