/*
 * Decompiled with CFR 0.152.
 */
package team.rusty.util.worldgen.structure;

import com.google.common.collect.ImmutableList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fmllegacy.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public final class SimpleStructureRegistry {
    private final DeferredRegister<StructureFeature<?>> deferredRegister;
    private final Map<ResourceLocation, StructureInfo<StructureFeature<?>>> structureInfo;

    public SimpleStructureRegistry(String modId) {
        this.deferredRegister = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)modId);
        this.structureInfo = new HashMap();
    }

    public void register(IEventBus modBus) {
        this.deferredRegister.register(modBus);
        modBus.addListener(this::commonSetup);
        MinecraftForge.EVENT_BUS.addListener(this::worldLoad);
    }

    public <T extends StructureFeature<?>> RegistryObject<T> register(String name, Supplier<T> structure, Function<T, ConfiguredStructureFeature<?, ?>> configured, boolean adjustGround, int spacing, int separation, int structureSeed) {
        RegistryObject object = this.deferredRegister.register(name, structure);
        this.structureInfo.put(object.getId(), new StructureInfo<T>(configured, adjustGround, new StructureFeatureConfiguration(spacing, separation, structureSeed)));
        return object;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            for (RegistryObject entry : this.deferredRegister.getEntries()) {
                StructureFeature value = (StructureFeature)entry.get();
                ResourceLocation id = entry.getId();
                StructureInfo<StructureFeature<?>> info = this.structureInfo.get(id);
                Registry.m_122965_((Registry)BuiltinRegistries.f_123862_, (ResourceLocation)id, info.configured().apply(value));
                StructureFeature.f_67012_.put((Object)id.toString(), (Object)value);
                if (!info.adjustGround()) continue;
                StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add((Object)value).build();
            }
        });
    }

    private void worldLoad(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            Map configurations = level.m_7726_().m_8481_().m_62205_().m_64590_();
            for (RegistryObject entry : this.deferredRegister.getEntries()) {
                try {
                    configurations.put((StructureFeature)entry.get(), this.structureInfo.get(entry.getId()).config());
                }
                catch (UnsupportedOperationException unsupportedOperationException) {}
            }
        }
    }

    private record StructureInfo<T extends StructureFeature<?>>(Function<T, ConfiguredStructureFeature<?, ?>> configured, boolean adjustGround, StructureFeatureConfiguration config) {
    }
}

