/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import net.minecraft.util.JsonUtils;
import rtg.api.util.Logger;

public final class RTGChunkGenSettings {
    public final int seaLevel;
    public final boolean useBoulders;
    public final float boulderMult;
    public final int sandDuneHeight;
    public final boolean useSnowLayers;
    public final float snowLayerTemp;
    public final int bedrockLayers;
    public final boolean useCaves;
    public final int caveChance;
    public final int caveDensity;
    public final boolean useRavines;
    public final int ravineChance;
    public final float riverSizeMult;
    public final float riverFrequency;
    public final float riverBendMult;
    public final float riverCutOffAmpl;
    public final float riverCutOffScale;
    public final float RTGlakeSizeMult;
    public final float RTGlakeFreqMult;
    public final float RTGlakeShoreBend;
    public final boolean useWaterLakes;
    public final int waterLakeChance;
    public final boolean useLavaLakes;
    public final int lavaLakeChance;
    public final boolean useWaterUndLakes;
    public final int waterUndLakeChance;
    public final boolean useLavaUndLakes;
    public final int lavaUndLakeChance;
    public final int waterSpoutChance;
    public final int lavaSpoutChance;
    public final boolean useVillages;
    public final int villageSize;
    public final int villageDistance;
    public final boolean useMineShafts;
    public final float mineShaftChance;
    public final boolean useDungeons;
    public final int dungeonChance;
    public final boolean useTemples;
    public final int templeDistance;
    public final boolean useMonuments;
    public final int monumentSpacing;
    public final int monumentSeparation;
    public final boolean useMansions;
    public final int mansionSpacing;
    public final int mansionSeparation;
    public final boolean useStrongholds;
    public final int strongholdCount;
    public final int strongholdDistance;
    public final int strongholdSpread;
    public final int dirtSize;
    public final int dirtCount;
    public final int dirtMinHeight;
    public final int dirtMaxHeight;
    public final int gravelSize;
    public final int gravelCount;
    public final int gravelMinHeight;
    public final int gravelMaxHeight;
    public final int graniteSize;
    public final int graniteCount;
    public final int graniteMinHeight;
    public final int graniteMaxHeight;
    public final int dioriteSize;
    public final int dioriteCount;
    public final int dioriteMinHeight;
    public final int dioriteMaxHeight;
    public final int andesiteSize;
    public final int andesiteCount;
    public final int andesiteMinHeight;
    public final int andesiteMaxHeight;
    public final int coalSize;
    public final int coalCount;
    public final int coalMinHeight;
    public final int coalMaxHeight;
    public final int ironSize;
    public final int ironCount;
    public final int ironMinHeight;
    public final int ironMaxHeight;
    public final int goldSize;
    public final int goldCount;
    public final int goldMinHeight;
    public final int goldMaxHeight;
    public final int redstoneSize;
    public final int redstoneCount;
    public final int redstoneMinHeight;
    public final int redstoneMaxHeight;
    public final int diamondSize;
    public final int diamondCount;
    public final int diamondMinHeight;
    public final int diamondMaxHeight;
    public final int lapisSize;
    public final int lapisCount;
    public final int lapisCenterHeight;
    public final int lapisSpread;

    private RTGChunkGenSettings(Factory settingsFactory) {
        this.seaLevel = settingsFactory.seaLevel;
        this.useBoulders = settingsFactory.useBoulders;
        this.boulderMult = settingsFactory.boulderMult;
        this.sandDuneHeight = settingsFactory.sandDuneHeight;
        this.useSnowLayers = settingsFactory.useSnowLayers;
        this.snowLayerTemp = settingsFactory.snowLayerTemp;
        this.bedrockLayers = settingsFactory.bedrockLayers;
        this.useCaves = settingsFactory.useCaves;
        this.caveChance = settingsFactory.caveChance;
        this.caveDensity = settingsFactory.caveDensity;
        this.useRavines = settingsFactory.useRavines;
        this.ravineChance = settingsFactory.ravineChance;
        this.riverSizeMult = settingsFactory.riverSizeMult;
        this.riverFrequency = settingsFactory.riverFrequency;
        this.riverBendMult = settingsFactory.riverBendMult;
        this.riverCutOffAmpl = settingsFactory.riverCutOffAmpl;
        this.riverCutOffScale = settingsFactory.riverCutOffScale;
        this.RTGlakeSizeMult = settingsFactory.RTGlakeSizeMult;
        this.RTGlakeFreqMult = settingsFactory.RTGlakeFreqMult;
        this.RTGlakeShoreBend = settingsFactory.RTGlakeShoreBend;
        this.useWaterLakes = settingsFactory.useWaterLakes;
        this.waterLakeChance = settingsFactory.waterLakeChance;
        this.useLavaLakes = settingsFactory.useLavaLakes;
        this.lavaLakeChance = settingsFactory.lavaLakeChance;
        this.useWaterUndLakes = settingsFactory.useWaterUndLakes;
        this.waterUndLakeChance = settingsFactory.waterUndLakeChance;
        this.useLavaUndLakes = settingsFactory.useLavaUndLakes;
        this.lavaUndLakeChance = settingsFactory.lavaUndLakeChance;
        this.waterSpoutChance = settingsFactory.waterSpoutChance;
        this.lavaSpoutChance = settingsFactory.lavaSpoutChance;
        this.useVillages = settingsFactory.useVillages;
        this.villageSize = settingsFactory.villageSize;
        this.villageDistance = settingsFactory.villageDistance;
        this.useMineShafts = settingsFactory.useMineShafts;
        this.mineShaftChance = settingsFactory.mineShaftChance;
        this.useDungeons = settingsFactory.useDungeons;
        this.dungeonChance = settingsFactory.dungeonChance;
        this.useTemples = settingsFactory.useTemples;
        this.templeDistance = settingsFactory.templeDistance;
        this.useMonuments = settingsFactory.useMonuments;
        this.monumentSpacing = settingsFactory.monumentSpacing;
        this.monumentSeparation = settingsFactory.monumentSeparation;
        this.useMansions = settingsFactory.useMansions;
        this.mansionSpacing = settingsFactory.mansionSpacing;
        this.mansionSeparation = settingsFactory.mansionSeparation;
        this.useStrongholds = settingsFactory.useStrongholds;
        this.strongholdCount = settingsFactory.strongholdCount;
        this.strongholdDistance = settingsFactory.strongholdDistance;
        this.strongholdSpread = settingsFactory.strongholdSpread;
        this.dirtSize = settingsFactory.dirtSize;
        this.dirtCount = settingsFactory.dirtCount;
        this.dirtMinHeight = settingsFactory.dirtMinHeight;
        this.dirtMaxHeight = settingsFactory.dirtMaxHeight;
        this.gravelSize = settingsFactory.gravelSize;
        this.gravelCount = settingsFactory.gravelCount;
        this.gravelMinHeight = settingsFactory.gravelMinHeight;
        this.gravelMaxHeight = settingsFactory.gravelMaxHeight;
        this.graniteSize = settingsFactory.graniteSize;
        this.graniteCount = settingsFactory.graniteCount;
        this.graniteMinHeight = settingsFactory.graniteMinHeight;
        this.graniteMaxHeight = settingsFactory.graniteMaxHeight;
        this.dioriteSize = settingsFactory.dioriteSize;
        this.dioriteCount = settingsFactory.dioriteCount;
        this.dioriteMinHeight = settingsFactory.dioriteMinHeight;
        this.dioriteMaxHeight = settingsFactory.dioriteMaxHeight;
        this.andesiteSize = settingsFactory.andesiteSize;
        this.andesiteCount = settingsFactory.andesiteCount;
        this.andesiteMinHeight = settingsFactory.andesiteMinHeight;
        this.andesiteMaxHeight = settingsFactory.andesiteMaxHeight;
        this.coalSize = settingsFactory.coalSize;
        this.coalCount = settingsFactory.coalCount;
        this.coalMinHeight = settingsFactory.coalMinHeight;
        this.coalMaxHeight = settingsFactory.coalMaxHeight;
        this.ironSize = settingsFactory.ironSize;
        this.ironCount = settingsFactory.ironCount;
        this.ironMinHeight = settingsFactory.ironMinHeight;
        this.ironMaxHeight = settingsFactory.ironMaxHeight;
        this.goldSize = settingsFactory.goldSize;
        this.goldCount = settingsFactory.goldCount;
        this.goldMinHeight = settingsFactory.goldMinHeight;
        this.goldMaxHeight = settingsFactory.goldMaxHeight;
        this.redstoneSize = settingsFactory.redstoneSize;
        this.redstoneCount = settingsFactory.redstoneCount;
        this.redstoneMinHeight = settingsFactory.redstoneMinHeight;
        this.redstoneMaxHeight = settingsFactory.redstoneMaxHeight;
        this.diamondSize = settingsFactory.diamondSize;
        this.diamondCount = settingsFactory.diamondCount;
        this.diamondMinHeight = settingsFactory.diamondMinHeight;
        this.diamondMaxHeight = settingsFactory.diamondMaxHeight;
        this.lapisSize = settingsFactory.lapisSize;
        this.lapisCount = settingsFactory.lapisCount;
        this.lapisCenterHeight = settingsFactory.lapisCenterHeight;
        this.lapisSpread = settingsFactory.lapisSpread;
    }

    public int getSurfaceWaterLakeChance(double multiplier) {
        return this.waterLakeChance <= 0 || multiplier <= 0.0 ? 0 : (int)((double)this.waterLakeChance / multiplier);
    }

    public int getSurfaceLavaLakeChance(double multiplier) {
        return this.lavaLakeChance <= 0 || multiplier <= 0.0 ? 0 : (int)((double)this.lavaLakeChance / multiplier);
    }

    public float getClampedSnowLayerTemp() {
        return Math.max(0.05f, Math.min(0.15f, this.snowLayerTemp));
    }

    public static class Serializer
    implements JsonDeserializer<Factory>,
    JsonSerializer<Factory> {
        public Factory deserialize(JsonElement element, Type type, JsonDeserializationContext context) {
            JsonObject json = element.getAsJsonObject();
            Factory settings = new Factory();
            try {
                settings.seaLevel = JsonUtils.func_151208_a((JsonObject)json, (String)"seaLevel", (int)settings.seaLevel);
                settings.useBoulders = JsonUtils.func_151209_a((JsonObject)json, (String)"useBoulders", (boolean)settings.useBoulders);
                settings.boulderMult = JsonUtils.func_151221_a((JsonObject)json, (String)"boulderMult", (float)settings.boulderMult);
                settings.sandDuneHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"sandDuneHeight", (int)settings.sandDuneHeight);
                settings.useSnowLayers = JsonUtils.func_151209_a((JsonObject)json, (String)"useSnowLayers", (boolean)settings.useSnowLayers);
                settings.snowLayerTemp = JsonUtils.func_151221_a((JsonObject)json, (String)"snowLayerTemp", (float)settings.snowLayerTemp);
                settings.bedrockLayers = JsonUtils.func_151208_a((JsonObject)json, (String)"bedrockLayers", (int)settings.bedrockLayers);
                settings.useCaves = JsonUtils.func_151209_a((JsonObject)json, (String)"useCaves", (boolean)settings.useCaves);
                settings.caveChance = JsonUtils.func_151208_a((JsonObject)json, (String)"caveChance", (int)settings.caveChance);
                settings.caveDensity = JsonUtils.func_151208_a((JsonObject)json, (String)"caveDensity", (int)settings.caveDensity);
                settings.useRavines = JsonUtils.func_151209_a((JsonObject)json, (String)"useRavines", (boolean)settings.useRavines);
                settings.ravineChance = JsonUtils.func_151208_a((JsonObject)json, (String)"ravineChance", (int)settings.ravineChance);
                settings.riverSizeMult = JsonUtils.func_151221_a((JsonObject)json, (String)"riverSizeMult", (float)settings.riverSizeMult);
                settings.riverFrequency = JsonUtils.func_151221_a((JsonObject)json, (String)"riverFrequency", (float)settings.riverFrequency);
                settings.riverBendMult = JsonUtils.func_151221_a((JsonObject)json, (String)"riverBendMult", (float)settings.riverBendMult);
                settings.riverCutOffAmpl = JsonUtils.func_151221_a((JsonObject)json, (String)"riverCutOffAmpl", (float)settings.riverCutOffAmpl);
                settings.riverCutOffScale = JsonUtils.func_151221_a((JsonObject)json, (String)"riverCutOffScale", (float)settings.riverCutOffScale);
                settings.RTGlakeSizeMult = JsonUtils.func_151221_a((JsonObject)json, (String)"RTGlakeSizeMult", (float)settings.RTGlakeSizeMult);
                settings.RTGlakeFreqMult = JsonUtils.func_151221_a((JsonObject)json, (String)"RTGlakeFreqMult", (float)settings.RTGlakeFreqMult);
                settings.RTGlakeShoreBend = JsonUtils.func_151221_a((JsonObject)json, (String)"RTGlakeShoreBend", (float)settings.RTGlakeShoreBend);
                settings.useWaterLakes = JsonUtils.func_151209_a((JsonObject)json, (String)"useWaterLakes", (boolean)settings.useWaterLakes);
                settings.waterLakeChance = JsonUtils.func_151208_a((JsonObject)json, (String)"waterLakeChance", (int)settings.waterLakeChance);
                settings.useLavaLakes = JsonUtils.func_151209_a((JsonObject)json, (String)"useLavaLakes", (boolean)settings.useLavaLakes);
                settings.lavaLakeChance = JsonUtils.func_151208_a((JsonObject)json, (String)"lavaLakeChance", (int)settings.lavaLakeChance);
                settings.useWaterUndLakes = JsonUtils.func_151209_a((JsonObject)json, (String)"useWaterUndLakes", (boolean)settings.useWaterUndLakes);
                settings.waterUndLakeChance = JsonUtils.func_151208_a((JsonObject)json, (String)"waterUndLakeChance", (int)settings.waterUndLakeChance);
                settings.useLavaUndLakes = JsonUtils.func_151209_a((JsonObject)json, (String)"useLavaUndLakes", (boolean)settings.useLavaUndLakes);
                settings.lavaUndLakeChance = JsonUtils.func_151208_a((JsonObject)json, (String)"lavaUndLakeChance", (int)settings.lavaUndLakeChance);
                settings.waterSpoutChance = JsonUtils.func_151208_a((JsonObject)json, (String)"waterSpoutChance", (int)settings.waterSpoutChance);
                settings.lavaSpoutChance = JsonUtils.func_151208_a((JsonObject)json, (String)"lavaSpoutChance", (int)settings.lavaSpoutChance);
                settings.useVillages = JsonUtils.func_151209_a((JsonObject)json, (String)"useVillages", (boolean)settings.useVillages);
                settings.villageSize = JsonUtils.func_151208_a((JsonObject)json, (String)"villageSize", (int)settings.villageSize);
                settings.villageDistance = JsonUtils.func_151208_a((JsonObject)json, (String)"villageDistance", (int)settings.villageDistance);
                settings.useMineShafts = JsonUtils.func_151209_a((JsonObject)json, (String)"useMineShafts", (boolean)settings.useMineShafts);
                settings.mineShaftChance = JsonUtils.func_151221_a((JsonObject)json, (String)"mineShaftChance", (float)settings.mineShaftChance);
                settings.useDungeons = JsonUtils.func_151209_a((JsonObject)json, (String)"useDungeons", (boolean)settings.useDungeons);
                settings.dungeonChance = JsonUtils.func_151208_a((JsonObject)json, (String)"dungeonChance", (int)settings.dungeonChance);
                settings.useTemples = JsonUtils.func_151209_a((JsonObject)json, (String)"useTemples", (boolean)settings.useTemples);
                settings.templeDistance = JsonUtils.func_151208_a((JsonObject)json, (String)"templeMaxDistance", (int)settings.templeDistance);
                settings.useMonuments = JsonUtils.func_151209_a((JsonObject)json, (String)"useMonuments", (boolean)settings.useMonuments);
                settings.monumentSpacing = JsonUtils.func_151208_a((JsonObject)json, (String)"monumentSpacing", (int)settings.monumentSpacing);
                settings.monumentSeparation = JsonUtils.func_151208_a((JsonObject)json, (String)"monumentSeparation", (int)settings.monumentSeparation);
                settings.useMansions = JsonUtils.func_151209_a((JsonObject)json, (String)"useMansions", (boolean)settings.useMansions);
                settings.mansionSpacing = JsonUtils.func_151208_a((JsonObject)json, (String)"mansionSpacing", (int)settings.mansionSpacing);
                settings.mansionSeparation = JsonUtils.func_151208_a((JsonObject)json, (String)"mansionSeparation", (int)settings.mansionSeparation);
                settings.useStrongholds = JsonUtils.func_151209_a((JsonObject)json, (String)"useStrongholds", (boolean)settings.useStrongholds);
                settings.strongholdCount = JsonUtils.func_151208_a((JsonObject)json, (String)"strongholdCount", (int)settings.strongholdCount);
                settings.strongholdDistance = JsonUtils.func_151208_a((JsonObject)json, (String)"strongholdDistance", (int)settings.strongholdDistance);
                settings.strongholdSpread = JsonUtils.func_151208_a((JsonObject)json, (String)"strongholdSpread", (int)settings.strongholdSpread);
                settings.dirtSize = JsonUtils.func_151208_a((JsonObject)json, (String)"dirtSize", (int)settings.dirtSize);
                settings.dirtCount = JsonUtils.func_151208_a((JsonObject)json, (String)"dirtCount", (int)settings.dirtCount);
                settings.dirtMinHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"dirtMinHeight", (int)settings.dirtMinHeight);
                settings.dirtMaxHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"dirtMaxHeight", (int)settings.dirtMaxHeight);
                settings.gravelSize = JsonUtils.func_151208_a((JsonObject)json, (String)"gravelSize", (int)settings.gravelSize);
                settings.gravelCount = JsonUtils.func_151208_a((JsonObject)json, (String)"gravelCount", (int)settings.gravelCount);
                settings.gravelMinHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"gravelMinHeight", (int)settings.gravelMinHeight);
                settings.gravelMaxHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"gravelMaxHeight", (int)settings.gravelMaxHeight);
                settings.graniteSize = JsonUtils.func_151208_a((JsonObject)json, (String)"graniteSize", (int)settings.graniteSize);
                settings.graniteCount = JsonUtils.func_151208_a((JsonObject)json, (String)"graniteCount", (int)settings.graniteCount);
                settings.graniteMinHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"graniteMinHeight", (int)settings.graniteMinHeight);
                settings.graniteMaxHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"graniteMaxHeight", (int)settings.graniteMaxHeight);
                settings.dioriteSize = JsonUtils.func_151208_a((JsonObject)json, (String)"dioriteSize", (int)settings.dioriteSize);
                settings.dioriteCount = JsonUtils.func_151208_a((JsonObject)json, (String)"dioriteCount", (int)settings.dioriteCount);
                settings.dioriteMinHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"dioriteMinHeight", (int)settings.dioriteMinHeight);
                settings.dioriteMaxHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"dioriteMaxHeight", (int)settings.dioriteMaxHeight);
                settings.andesiteSize = JsonUtils.func_151208_a((JsonObject)json, (String)"andesiteSize", (int)settings.andesiteSize);
                settings.andesiteCount = JsonUtils.func_151208_a((JsonObject)json, (String)"andesiteCount", (int)settings.andesiteCount);
                settings.andesiteMinHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"andesiteMinHeight", (int)settings.andesiteMinHeight);
                settings.andesiteMaxHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"andesiteMaxHeight", (int)settings.andesiteMaxHeight);
                settings.coalSize = JsonUtils.func_151208_a((JsonObject)json, (String)"coalSize", (int)settings.coalSize);
                settings.coalCount = JsonUtils.func_151208_a((JsonObject)json, (String)"coalCount", (int)settings.coalCount);
                settings.coalMinHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"coalMinHeight", (int)settings.coalMinHeight);
                settings.coalMaxHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"coalMaxHeight", (int)settings.coalMaxHeight);
                settings.ironSize = JsonUtils.func_151208_a((JsonObject)json, (String)"ironSize", (int)settings.ironSize);
                settings.ironCount = JsonUtils.func_151208_a((JsonObject)json, (String)"ironCount", (int)settings.ironCount);
                settings.ironMinHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"ironMinHeight", (int)settings.ironMinHeight);
                settings.ironMaxHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"ironMaxHeight", (int)settings.ironMaxHeight);
                settings.goldSize = JsonUtils.func_151208_a((JsonObject)json, (String)"goldSize", (int)settings.goldSize);
                settings.goldCount = JsonUtils.func_151208_a((JsonObject)json, (String)"goldCount", (int)settings.goldCount);
                settings.goldMinHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"goldMinHeight", (int)settings.goldMinHeight);
                settings.goldMaxHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"goldMaxHeight", (int)settings.goldMaxHeight);
                settings.redstoneSize = JsonUtils.func_151208_a((JsonObject)json, (String)"redstoneSize", (int)settings.redstoneSize);
                settings.redstoneCount = JsonUtils.func_151208_a((JsonObject)json, (String)"redstoneCount", (int)settings.redstoneCount);
                settings.redstoneMinHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"redstoneMinHeight", (int)settings.redstoneMinHeight);
                settings.redstoneMaxHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"redstoneMaxHeight", (int)settings.redstoneMaxHeight);
                settings.diamondSize = JsonUtils.func_151208_a((JsonObject)json, (String)"diamondSize", (int)settings.diamondSize);
                settings.diamondCount = JsonUtils.func_151208_a((JsonObject)json, (String)"diamondCount", (int)settings.diamondCount);
                settings.diamondMinHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"diamondMinHeight", (int)settings.diamondMinHeight);
                settings.diamondMaxHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"diamondMaxHeight", (int)settings.diamondMaxHeight);
                settings.lapisSize = JsonUtils.func_151208_a((JsonObject)json, (String)"lapisSize", (int)settings.lapisSize);
                settings.lapisCount = JsonUtils.func_151208_a((JsonObject)json, (String)"lapisCount", (int)settings.lapisCount);
                settings.lapisCenterHeight = JsonUtils.func_151208_a((JsonObject)json, (String)"lapisCenterHeight", (int)settings.lapisCenterHeight);
                settings.lapisSpread = JsonUtils.func_151208_a((JsonObject)json, (String)"lapisSpread", (int)settings.lapisSpread);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return settings;
        }

        public JsonElement serialize(Factory factory, Type type, JsonSerializationContext context) {
            JsonObject json = new JsonObject();
            json.addProperty("seaLevel", (Number)factory.seaLevel);
            json.addProperty("useBoulders", Boolean.valueOf(factory.useBoulders));
            json.addProperty("boulderMult", (Number)Float.valueOf(factory.boulderMult));
            json.addProperty("sandDuneHeight", (Number)factory.sandDuneHeight);
            json.addProperty("useSnowLayers", Boolean.valueOf(factory.useSnowLayers));
            json.addProperty("snowLayerTemp", (Number)Float.valueOf(factory.snowLayerTemp));
            json.addProperty("bedrockLayers", (Number)factory.bedrockLayers);
            json.addProperty("useCaves", Boolean.valueOf(factory.useCaves));
            json.addProperty("caveChance", (Number)factory.caveChance);
            json.addProperty("caveDensity", (Number)factory.caveDensity);
            json.addProperty("useRavines", Boolean.valueOf(factory.useRavines));
            json.addProperty("ravineChance", (Number)factory.ravineChance);
            json.addProperty("riverSizeMult", (Number)Float.valueOf(factory.riverSizeMult));
            json.addProperty("riverFrequency", (Number)Float.valueOf(factory.riverFrequency));
            json.addProperty("riverBendMult", (Number)Float.valueOf(factory.riverBendMult));
            json.addProperty("riverCutOffAmpl", (Number)Float.valueOf(factory.riverCutOffAmpl));
            json.addProperty("riverCutOffScale", (Number)Float.valueOf(factory.riverCutOffScale));
            json.addProperty("RTGlakeSizeMult", (Number)Float.valueOf(factory.RTGlakeSizeMult));
            json.addProperty("RTGlakeFreqMult", (Number)Float.valueOf(factory.RTGlakeFreqMult));
            json.addProperty("RTGlakeShoreBend", (Number)Float.valueOf(factory.RTGlakeShoreBend));
            json.addProperty("useWaterLakes", Boolean.valueOf(factory.useWaterLakes));
            json.addProperty("waterLakeChance", (Number)factory.waterLakeChance);
            json.addProperty("useLavaLakes", Boolean.valueOf(factory.useLavaLakes));
            json.addProperty("lavaLakeChance", (Number)factory.lavaLakeChance);
            json.addProperty("useWaterUndLakes", Boolean.valueOf(factory.useWaterUndLakes));
            json.addProperty("waterUndLakeChance", (Number)factory.waterUndLakeChance);
            json.addProperty("useLavaUndLakes", Boolean.valueOf(factory.useLavaUndLakes));
            json.addProperty("lavaUndLakeChance", (Number)factory.lavaUndLakeChance);
            json.addProperty("waterSpoutChance", (Number)factory.waterSpoutChance);
            json.addProperty("lavaSpoutChance", (Number)factory.lavaSpoutChance);
            json.addProperty("useVillages", Boolean.valueOf(factory.useVillages));
            json.addProperty("villageSize", (Number)factory.villageSize);
            json.addProperty("villageDistance", (Number)factory.villageDistance);
            json.addProperty("useMineShafts", Boolean.valueOf(factory.useMineShafts));
            json.addProperty("mineShaftChance", (Number)Float.valueOf(factory.mineShaftChance));
            json.addProperty("useDungeons", Boolean.valueOf(factory.useDungeons));
            json.addProperty("dungeonChance", (Number)factory.dungeonChance);
            json.addProperty("useTemples", Boolean.valueOf(factory.useTemples));
            json.addProperty("templeDistance", (Number)factory.templeDistance);
            json.addProperty("useMonuments", Boolean.valueOf(factory.useMonuments));
            json.addProperty("monumentSpacing", (Number)factory.monumentSpacing);
            json.addProperty("monumentSeparation", (Number)factory.monumentSeparation);
            json.addProperty("useMansions", Boolean.valueOf(factory.useMansions));
            json.addProperty("mansionSpacing", (Number)factory.mansionSpacing);
            json.addProperty("mansionSeparation", (Number)factory.mansionSeparation);
            json.addProperty("useStrongholds", Boolean.valueOf(factory.useStrongholds));
            json.addProperty("strongholdCount", (Number)factory.strongholdCount);
            json.addProperty("strongholdDistance", (Number)factory.strongholdDistance);
            json.addProperty("strongholdSpread", (Number)factory.strongholdSpread);
            json.addProperty("dirtSize", (Number)factory.dirtSize);
            json.addProperty("dirtCount", (Number)factory.dirtCount);
            json.addProperty("dirtMinHeight", (Number)factory.dirtMinHeight);
            json.addProperty("dirtMaxHeight", (Number)factory.dirtMaxHeight);
            json.addProperty("gravelSize", (Number)factory.gravelSize);
            json.addProperty("gravelCount", (Number)factory.gravelCount);
            json.addProperty("gravelMinHeight", (Number)factory.gravelMinHeight);
            json.addProperty("gravelMaxHeight", (Number)factory.gravelMaxHeight);
            json.addProperty("graniteSize", (Number)factory.graniteSize);
            json.addProperty("graniteCount", (Number)factory.graniteCount);
            json.addProperty("graniteMinHeight", (Number)factory.graniteMinHeight);
            json.addProperty("graniteMaxHeight", (Number)factory.graniteMaxHeight);
            json.addProperty("dioriteSize", (Number)factory.dioriteSize);
            json.addProperty("dioriteCount", (Number)factory.dioriteCount);
            json.addProperty("dioriteMinHeight", (Number)factory.dioriteMinHeight);
            json.addProperty("dioriteMaxHeight", (Number)factory.dioriteMaxHeight);
            json.addProperty("andesiteSize", (Number)factory.andesiteSize);
            json.addProperty("andesiteCount", (Number)factory.andesiteCount);
            json.addProperty("andesiteMinHeight", (Number)factory.andesiteMinHeight);
            json.addProperty("andesiteMaxHeight", (Number)factory.andesiteMaxHeight);
            json.addProperty("coalSize", (Number)factory.coalSize);
            json.addProperty("coalCount", (Number)factory.coalCount);
            json.addProperty("coalMinHeight", (Number)factory.coalMinHeight);
            json.addProperty("coalMaxHeight", (Number)factory.coalMaxHeight);
            json.addProperty("ironSize", (Number)factory.ironSize);
            json.addProperty("ironCount", (Number)factory.ironCount);
            json.addProperty("ironMinHeight", (Number)factory.ironMinHeight);
            json.addProperty("ironMaxHeight", (Number)factory.ironMaxHeight);
            json.addProperty("goldSize", (Number)factory.goldSize);
            json.addProperty("goldCount", (Number)factory.goldCount);
            json.addProperty("goldMinHeight", (Number)factory.goldMinHeight);
            json.addProperty("goldMaxHeight", (Number)factory.goldMaxHeight);
            json.addProperty("redstoneSize", (Number)factory.redstoneSize);
            json.addProperty("redstoneCount", (Number)factory.redstoneCount);
            json.addProperty("redstoneMinHeight", (Number)factory.redstoneMinHeight);
            json.addProperty("redstoneMaxHeight", (Number)factory.redstoneMaxHeight);
            json.addProperty("diamondSize", (Number)factory.diamondSize);
            json.addProperty("diamondCount", (Number)factory.diamondCount);
            json.addProperty("diamondMinHeight", (Number)factory.diamondMinHeight);
            json.addProperty("diamondMaxHeight", (Number)factory.diamondMaxHeight);
            json.addProperty("lapisSize", (Number)factory.lapisSize);
            json.addProperty("lapisCount", (Number)factory.lapisCount);
            json.addProperty("lapisCenterHeight", (Number)factory.lapisCenterHeight);
            json.addProperty("lapisSpread", (Number)factory.lapisSpread);
            return json;
        }
    }

    public static class Factory {
        static final Gson JSON_ADAPTER = new GsonBuilder().registerTypeAdapter(Factory.class, (Object)new Serializer()).create();
        public int seaLevel = 63;
        public boolean useBoulders = true;
        public float boulderMult = 1.0f;
        public int sandDuneHeight = 4;
        public boolean useSnowLayers = true;
        public float snowLayerTemp = 0.12f;
        public int bedrockLayers = 5;
        public boolean useCaves = true;
        public int caveChance = 8;
        public int caveDensity = 7;
        public boolean useRavines = true;
        public int ravineChance = 100;
        public float riverSizeMult = 1.0f;
        public float riverFrequency = 1.0f;
        public float riverBendMult = 1.0f;
        public float riverCutOffAmpl = 0.5f;
        public float riverCutOffScale = 350.0f;
        public float RTGlakeSizeMult = 1.0f;
        public float RTGlakeFreqMult = 1.0f;
        public float RTGlakeShoreBend = 1.0f;
        public boolean useWaterLakes = true;
        public int waterLakeChance = 10;
        public boolean useLavaLakes = true;
        public int lavaLakeChance = 80;
        public boolean useWaterUndLakes = true;
        public int waterUndLakeChance = 10;
        public boolean useLavaUndLakes = true;
        public int lavaUndLakeChance = 80;
        public int waterSpoutChance = 200;
        public int lavaSpoutChance = 200;
        public boolean useVillages = true;
        public int villageSize = 0;
        public int villageDistance = 48;
        public boolean useMineShafts = true;
        public float mineShaftChance = 0.004f;
        public boolean useDungeons = true;
        public int dungeonChance = 8;
        public boolean useTemples = true;
        public int templeDistance = 48;
        public boolean useMonuments = true;
        public int monumentSpacing = 32;
        public int monumentSeparation = 5;
        public boolean useMansions = true;
        public int mansionSpacing = 80;
        public int mansionSeparation = 20;
        public boolean useStrongholds = true;
        public int strongholdCount = 128;
        public int strongholdDistance = 32;
        public int strongholdSpread = 3;
        public int dirtSize = 33;
        public int dirtCount = 10;
        public int dirtMinHeight = 0;
        public int dirtMaxHeight = 256;
        public int gravelSize = 33;
        public int gravelCount = 8;
        public int gravelMinHeight = 0;
        public int gravelMaxHeight = 256;
        public int graniteSize = 33;
        public int graniteCount = 10;
        public int graniteMinHeight = 0;
        public int graniteMaxHeight = 80;
        public int dioriteSize = 33;
        public int dioriteCount = 10;
        public int dioriteMinHeight = 0;
        public int dioriteMaxHeight = 80;
        public int andesiteSize = 33;
        public int andesiteCount = 10;
        public int andesiteMinHeight = 0;
        public int andesiteMaxHeight = 80;
        public int coalSize = 17;
        public int coalCount = 20;
        public int coalMinHeight = 0;
        public int coalMaxHeight = 128;
        public int ironSize = 9;
        public int ironCount = 20;
        public int ironMinHeight = 0;
        public int ironMaxHeight = 64;
        public int goldSize = 9;
        public int goldCount = 2;
        public int goldMinHeight = 0;
        public int goldMaxHeight = 32;
        public int redstoneSize = 8;
        public int redstoneCount = 8;
        public int redstoneMinHeight = 0;
        public int redstoneMaxHeight = 16;
        public int diamondSize = 8;
        public int diamondCount = 1;
        public int diamondMinHeight = 0;
        public int diamondMaxHeight = 16;
        public int lapisSize = 7;
        public int lapisCount = 1;
        public int lapisCenterHeight = 16;
        public int lapisSpread = 16;

        public Factory() {
            this.setDefaults();
        }

        public static Factory jsonToFactory(String generatorSettings) {
            if (generatorSettings.isEmpty()) {
                return new Factory();
            }
            try {
                JsonReader reader = new JsonReader((Reader)new StringReader(generatorSettings));
                reader.setLenient(true);
                return (Factory)JSON_ADAPTER.getAdapter(Factory.class).read(reader);
            }
            catch (IOException ex) {
                Logger.error("Error parsing chunk generator settings: {}", ex.getMessage());
                Logger.error("Settings: {}", generatorSettings);
                return new Factory();
            }
        }

        public String toString() {
            return JSON_ADAPTER.toJson((Object)this);
        }

        public final void setDefaults() {
            this.seaLevel = 63;
            this.useBoulders = true;
            this.boulderMult = 1.0f;
            this.sandDuneHeight = 4;
            this.useSnowLayers = true;
            this.snowLayerTemp = 0.12f;
            this.bedrockLayers = 5;
            this.useCaves = true;
            this.caveChance = 10;
            this.caveDensity = 7;
            this.useRavines = true;
            this.ravineChance = 120;
            this.riverSizeMult = 1.0f;
            this.riverFrequency = 1.0f;
            this.riverBendMult = 1.0f;
            this.riverCutOffAmpl = 0.5f;
            this.riverCutOffScale = 350.0f;
            this.RTGlakeSizeMult = 1.0f;
            this.RTGlakeFreqMult = 1.0f;
            this.RTGlakeShoreBend = 1.0f;
            this.useWaterLakes = true;
            this.waterLakeChance = 10;
            this.useLavaLakes = true;
            this.lavaLakeChance = 80;
            this.useWaterUndLakes = true;
            this.waterUndLakeChance = 10;
            this.useLavaUndLakes = true;
            this.lavaUndLakeChance = 80;
            this.waterSpoutChance = 200;
            this.lavaSpoutChance = 200;
            this.useVillages = true;
            this.villageSize = 0;
            this.villageDistance = 48;
            this.useMineShafts = true;
            this.mineShaftChance = 0.004f;
            this.useDungeons = true;
            this.dungeonChance = 8;
            this.useTemples = true;
            this.templeDistance = 48;
            this.useMonuments = true;
            this.monumentSpacing = 32;
            this.monumentSeparation = 5;
            this.useMansions = true;
            this.mansionSpacing = 80;
            this.mansionSeparation = 20;
            this.useStrongholds = true;
            this.strongholdCount = 128;
            this.strongholdDistance = 32;
            this.strongholdSpread = 3;
            this.dirtSize = 33;
            this.dirtCount = 10;
            this.dirtMinHeight = 0;
            this.dirtMaxHeight = 256;
            this.gravelSize = 33;
            this.gravelCount = 8;
            this.gravelMinHeight = 0;
            this.gravelMaxHeight = 256;
            this.graniteSize = 33;
            this.graniteCount = 10;
            this.graniteMinHeight = 0;
            this.graniteMaxHeight = 80;
            this.dioriteSize = 33;
            this.dioriteCount = 10;
            this.dioriteMinHeight = 0;
            this.dioriteMaxHeight = 80;
            this.andesiteSize = 33;
            this.andesiteCount = 10;
            this.andesiteMinHeight = 0;
            this.andesiteMaxHeight = 80;
            this.coalSize = 17;
            this.coalCount = 20;
            this.coalMinHeight = 0;
            this.coalMaxHeight = 128;
            this.ironSize = 9;
            this.ironCount = 20;
            this.ironMinHeight = 0;
            this.ironMaxHeight = 64;
            this.goldSize = 9;
            this.goldCount = 2;
            this.goldMinHeight = 0;
            this.goldMaxHeight = 32;
            this.redstoneSize = 8;
            this.redstoneCount = 8;
            this.redstoneMinHeight = 0;
            this.redstoneMaxHeight = 16;
            this.diamondSize = 8;
            this.diamondCount = 1;
            this.diamondMinHeight = 0;
            this.diamondMaxHeight = 16;
            this.lapisSize = 7;
            this.lapisCount = 1;
            this.lapisCenterHeight = 16;
            this.lapisSpread = 16;
        }

        public RTGChunkGenSettings build() {
            return new RTGChunkGenSettings(this);
        }
    }
}

