/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBlock
extends WorldGenerator {
    protected IBlockState placeBlock;
    protected IBlockState replaceBlock;
    protected IBlockState adjacentBlock;
    protected int minAdjacents;

    public WorldGenBlock(IBlockState placeBlock, IBlockState replaceBlock, IBlockState adjacentBlock, int minAdjacents) {
        super(false);
        this.placeBlock = placeBlock;
        this.replaceBlock = replaceBlock;
        this.setAdjacentBlock(adjacentBlock);
        this.setMinAdjacents(minAdjacents);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int z;
        int y;
        int x = pos.func_177958_n();
        IBlockState targetBlock = world.func_180495_p(new BlockPos(x, y = pos.func_177956_o(), z = pos.func_177952_p()));
        if (targetBlock != this.replaceBlock) {
            return false;
        }
        if (!this.isAdjacent(world, x, y, z)) {
            return false;
        }
        world.func_180501_a(new BlockPos(x, y, z), this.placeBlock, 2);
        return true;
    }

    protected boolean isAdjacent(World world, int x, int y, int z) {
        int adjacentCount = 0;
        if (world.func_180495_p(new BlockPos(x + 1, y, z)) == this.adjacentBlock) {
            ++adjacentCount;
        }
        if (world.func_180495_p(new BlockPos(x - 1, y, z)) == this.adjacentBlock) {
            ++adjacentCount;
        }
        if (world.func_180495_p(new BlockPos(x, y + 1, z)) == this.adjacentBlock) {
            ++adjacentCount;
        }
        if (world.func_180495_p(new BlockPos(x, y - 1, z)) == this.adjacentBlock) {
            ++adjacentCount;
        }
        if (world.func_180495_p(new BlockPos(x, y, z + 1)) == this.adjacentBlock) {
            ++adjacentCount;
        }
        if (world.func_180495_p(new BlockPos(x, y, z - 1)) == this.adjacentBlock) {
            ++adjacentCount;
        }
        return adjacentCount > 0 && adjacentCount >= this.minAdjacents;
    }

    public IBlockState getPlaceBlock() {
        return this.placeBlock;
    }

    public WorldGenBlock setPlaceBlock(IBlockState placeBlock) {
        this.placeBlock = placeBlock;
        return this;
    }

    public IBlockState getReplaceBlock() {
        return this.replaceBlock;
    }

    public WorldGenBlock setReplaceBlock(IBlockState replaceBlock) {
        this.replaceBlock = replaceBlock;
        return this;
    }

    public IBlockState getAdjacentBlock() {
        return this.adjacentBlock;
    }

    public WorldGenBlock setAdjacentBlock(IBlockState adjacentBlock) {
        this.adjacentBlock = adjacentBlock;
        return this;
    }

    public int getMinAdjacents() {
        return this.minAdjacents;
    }

    public WorldGenBlock setMinAdjacents(int minAdjacents) {
        this.minAdjacents = minAdjacents;
        return this;
    }
}

