/*
 * Decompiled with CFR 0.152.
 */
package rtg.api.world.terrain.heighteffect;

import rtg.api.world.RTGWorld;
import rtg.api.world.terrain.TerrainBase;
import rtg.api.world.terrain.heighteffect.HeightEffect;

public class MountainsWithPassesEffect
extends HeightEffect {
    public float mountainHeight = 2.1474836E9f;
    public float mountainWavelength = 0.0f;
    public float spikeHeight = 2.1474836E9f;
    public float spikeWavelength = 0.0f;
    public int hillOctave = 0;
    public int spikeOctave = 2;
    private float adjustedBottom = TerrainBase.blendedHillHeight(0.0f, 0.2f);

    @Override
    public final float added(RTGWorld rtgWorld, float x, float y) {
        float noise = rtgWorld.simplexInstance(this.hillOctave).noise2f(x / this.mountainWavelength, y / this.mountainWavelength);
        noise = Math.abs(noise);
        noise = TerrainBase.blendedHillHeight(noise, 0.2f);
        noise = 1.0f - (1.0f - noise) / (1.0f - this.adjustedBottom);
        float spikeNoise = TerrainBase.blendedHillHeight(noise, 0.1f);
        spikeNoise *= spikeNoise;
        spikeNoise = TerrainBase.blendedHillHeight(spikeNoise * noise);
        if ((double)noise > 1.01) {
            throw new RuntimeException();
        }
        if ((double)spikeNoise > 1.01) {
            throw new RuntimeException();
        }
        return noise * this.mountainHeight + spikeNoise * this.spikeHeight;
    }
}

