/*
 * Decompiled with CFR 0.152.
 */
package rtg.world.biome.realistic.novamterram;

import javax.annotation.Nonnull;
import net.minecraft.world.biome.Biome;
import rtg.api.world.RTGWorld;
import rtg.api.world.biome.RealisticBiomeBase;
import rtg.api.world.gen.RTGChunkGenSettings;
import rtg.api.world.terrain.TerrainBase;
import rtg.world.biome.realistic.novamterram.RealisticBiomeNTBase;

public abstract class RealisticBiomeNTBaseDesert
extends RealisticBiomeNTBase {
    public RealisticBiomeNTBaseDesert(@Nonnull Biome baseBiome, @Nonnull RealisticBiomeBase.RiverType riverType, @Nonnull RealisticBiomeBase.BeachType beachType) {
        super(baseBiome, riverType, beachType);
    }

    public RealisticBiomeNTBaseDesert(@Nonnull Biome baseBiome) {
        this(baseBiome, RealisticBiomeBase.RiverType.NORMAL, RealisticBiomeBase.BeachType.NORMAL);
    }

    public RealisticBiomeNTBaseDesert(@Nonnull Biome baseBiome, @Nonnull RealisticBiomeBase.RiverType riverType) {
        this(baseBiome, riverType, RealisticBiomeBase.BeachType.NORMAL);
    }

    public RealisticBiomeNTBaseDesert(@Nonnull Biome baseBiome, @Nonnull RealisticBiomeBase.BeachType beachType) {
        this(baseBiome, RealisticBiomeBase.RiverType.NORMAL, beachType);
    }

    @Override
    public void initConfig() {
        super.initConfig();
        this.getConfig().SURFACE_WATER_LAKE_MULT.set(0.0f);
        this.getConfig().ALLOW_SCENIC_LAKES.set(false);
    }

    @Override
    public TerrainBase initTerrain() {
        return new TerrainVanillaDesert();
    }

    public static class TerrainVanillaDesert
    extends TerrainBase {
        public TerrainVanillaDesert() {
            super(64.0f);
        }

        @Override
        public float generateNoise(RTGWorld rtgWorld, int x, int y, float border, float river) {
            RTGChunkGenSettings settings = rtgWorld.getGeneratorSettings();
            float duneHeight = this.minDuneHeight + (float)settings.sandDuneHeight;
            float stPitch = 200.0f;
            float stFactor = duneHeight *= (1.0f + rtgWorld.simplexInstance(2).noise2f((float)x / 330.0f, (float)y / 330.0f)) / 2.0f;
            float hPitch = 70.0f;
            float hDivisor = 40.0f;
            return TerrainVanillaDesert.terrainPolar(x, y, rtgWorld, river, stPitch, stFactor, hPitch, hDivisor, this.base) + TerrainVanillaDesert.groundNoise(x, y, 1.0f, rtgWorld);
        }
    }
}

