/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Mouse;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.gui.RadarCategoryButton;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;

public class GuiEntityRadar
extends GuiScreen
implements IDropDownCallback {
    private final int ROW_HEIGHT = 25;
    private IXaeroMinimap modMain;
    private GuiScreen parentGuiScreen;
    protected String screenTitle;
    private ArrayList<RadarCategory> categories;
    private boolean dropped;
    private String[] colorOptions;
    public CursorBox nameTooltip = new CursorBox("gui.xaero_box_entity_radar_names");
    public CursorBox iconTooltip = new CursorBox("gui.xaero_box_entity_radar_icons");

    protected GuiEntityRadar(IXaeroMinimap modMain, GuiScreen par1GuiScreen) {
        this.modMain = modMain;
        this.parentGuiScreen = par1GuiScreen;
        this.categories = new ArrayList();
        this.colorOptions = this.createColorOptions();
        String[] playerOptions = new String[this.colorOptions.length + 1];
        String[] teamOptions = new String[this.colorOptions.length + 1];
        String[] tamedOptions = new String[this.colorOptions.length + 1];
        for (int i = 0; i < this.colorOptions.length; ++i) {
            playerOptions[i] = this.colorOptions[i];
            teamOptions[i + 1] = this.colorOptions[i];
            tamedOptions[i + 1] = this.colorOptions[i];
        }
        playerOptions[this.colorOptions.length] = "gui.xaero_team_colours";
        teamOptions[0] = "gui.xaero_players";
        tamedOptions[0] = "gui.xaero_untamed_color";
        ModSettings settings = modMain.getSettings();
        this.categories.add(new RadarCategory("gui.xaero_players", settings.playersColor != -1 ? settings.playersColor : this.colorOptions.length, settings.playerNames, settings.playerIcons, 3, this.categories.size(), playerOptions, ModOptions.PLAYERS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.playersColor = this.color < GuiEntityRadar.this.colorOptions.length ? this.color : -1;
                settings.playerNames = this.names;
                settings.playerIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_other_teams", settings.otherTeamColor + 1, settings.otherTeamsNames, -4, 4, this.categories.size(), teamOptions, ModOptions.DISPLAY_OTHER_TEAM){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.otherTeamColor = this.color - 1;
                settings.otherTeamsNames = this.names;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_mobs", settings.mobsColor, settings.friendlyMobNames, settings.mobIcons, 3, this.categories.size(), this.colorOptions, ModOptions.MOBS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.mobsColor = this.color;
                settings.friendlyMobNames = this.names;
                settings.mobIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_hostile", settings.hostileColor, settings.hostileMobNames, settings.hostileIcons, 3, this.categories.size(), this.colorOptions, ModOptions.HOSTILE){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.hostileColor = this.color;
                settings.hostileMobNames = this.names;
                settings.hostileIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_tamed", settings.tamedMobsColor + 1, settings.tamedMobNames, settings.tamedIcons, 4, this.categories.size(), tamedOptions, ModOptions.TAMED){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.tamedMobsColor = this.color - 1;
                settings.tamedMobNames = this.names;
                settings.tamedIcons = this.icons;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_items", settings.itemsColor, settings.itemNames, -1, 3, this.categories.size(), this.colorOptions, ModOptions.ITEMS){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.itemsColor = this.color;
                settings.itemNames = this.names;
            }
        });
        this.categories.add(new RadarCategory("gui.xaero_other", settings.otherColor, settings.otherNames, -1, 3, this.categories.size(), this.colorOptions, ModOptions.ENTITIES){

            @Override
            public void onConfirm(ModSettings settings) {
                settings.otherColor = this.color;
                settings.otherNames = this.names;
            }
        });
    }

    private String[] createColorOptions() {
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length];
        for (int i = 0; i < options.length; ++i) {
            options[i] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    public void func_73866_w_() {
        this.screenTitle = I18n.func_135052_a((String)"gui.xaero_entity_radar", (Object[])new Object[0]);
        this.field_146292_n.clear();
        this.field_146292_n.add(new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])));
        this.field_146292_n.add(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
        for (RadarCategory c : this.categories) {
            c.init();
        }
    }

    protected void func_146284_a(GuiButton par1GuiButton) {
        if (par1GuiButton.field_146124_l) {
            int var2 = this.field_146297_k.field_71474_y.field_74335_Z;
            if (par1GuiButton instanceof RadarCategoryButton) {
                RadarCategory cat = ((RadarCategoryButton)par1GuiButton).getCategory();
                if (par1GuiButton.field_146127_k == 0) {
                    cat.onSettingClicked(par1GuiButton);
                } else if (par1GuiButton.field_146127_k == 1) {
                    cat.names = (cat.names + 1) % cat.totalNames;
                    par1GuiButton.field_146126_j = I18n.func_135052_a((String)ModSettings.ENTITY_NAMES_OPTIONS[cat.names], (Object[])new Object[0]);
                } else if (par1GuiButton.field_146127_k == 2) {
                    cat.icons = (cat.icons + 1) % cat.totalNames;
                    par1GuiButton.field_146126_j = I18n.func_135052_a((String)ModSettings.ENTITY_ICONS_OPTIONS[cat.icons], (Object[])new Object[0]);
                }
            }
            if (par1GuiButton.field_146127_k == 200) {
                ModSettings settings = this.modMain.getSettings();
                for (RadarCategory c : this.categories) {
                    c.onConfirm(settings);
                    c.onDisplayOptionConfirm(settings);
                }
                try {
                    settings.saveSettings();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (par1GuiButton.field_146127_k == 201) {
                this.field_146297_k.func_147108_a(this.parentGuiScreen);
            }
            if (this.field_146297_k.field_71474_y.field_74335_Z != var2) {
                ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
                int var4 = var3.func_78326_a();
                int var5 = var3.func_78328_b();
                this.func_146280_a(this.field_146297_k, var4, var5);
            }
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 5, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_entity_radar_type", (Object[])new Object[0]), this.field_146294_l / 2 - 176, this.field_146295_m / 12, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_entity_radar_color", (Object[])new Object[0]), this.field_146294_l / 2 - 76, this.field_146295_m / 12, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_entity_radar_visiblity", (Object[])new Object[0]), this.field_146294_l / 2 + 24, this.field_146295_m / 12, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_entity_radar_names", (Object[])new Object[0]), this.field_146294_l / 2 + 100, this.field_146295_m / 12, -1);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_entity_radar_icons", (Object[])new Object[0]), this.field_146294_l / 2 + 176, this.field_146295_m / 12, -1);
        for (RadarCategory c : this.categories) {
            c.render(par1, par2, par3);
        }
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        for (RadarCategory c : this.categories) {
            if (!c.onDropdownRender(par1, par2, par3, true)) continue;
            this.dropped = true;
        }
        for (RadarCategory c : this.categories) {
            c.onDropdownRender(par1, par2, par3, false);
        }
        for (int k = 0; k < this.field_146292_n.size(); ++k) {
            GuiButton b = (GuiButton)this.field_146292_n.get(k);
            if (!(b instanceof MyTinyButton)) continue;
            MyTinyButton optionWidget = (MyTinyButton)b;
            if (!optionWidget.field_146124_l || optionWidget.getTooltip() == null || par1 < b.field_146128_h || par2 < b.field_146129_i || par1 >= b.field_146128_h + b.field_146120_f || par2 >= b.field_146129_i + b.field_146121_g) continue;
            optionWidget.getTooltip().drawBox(par1, par2, this.field_146294_l, this.field_146295_m);
        }
    }

    @Override
    public boolean onSelected(GuiDropDown menu, int selected) {
        for (RadarCategory c : this.categories) {
            if (!c.onDropdownSelect(menu, selected)) continue;
            return true;
        }
        return false;
    }

    public void func_73864_a(int par1, int par2, int par3) throws IOException {
        for (RadarCategory c : this.categories) {
            if (!c.onClick(par1, par2, par3, false)) continue;
            return;
        }
        for (RadarCategory c : this.categories) {
            if (!c.onClick(par1, par2, par3, true)) continue;
            return;
        }
        super.func_73864_a(par1, par2, par3);
    }

    public void func_146286_b(int par1, int par2, int par3) {
        for (RadarCategory c : this.categories) {
            c.onRelease(par1, par2, par3);
        }
        super.func_146286_b(par1, par2, par3);
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
            int mouseXScaled = Mouse.getX() / var3.func_78325_e();
            int mouseYScaled = var3.func_78328_b() - 1 - Mouse.getY() / var3.func_78325_e();
            for (RadarCategory c : this.categories) {
                if (!c.onScroll(mouseXScaled, mouseYScaled, wheel)) continue;
                return;
            }
        }
    }

    public abstract class RadarCategory {
        String name;
        int index;
        GuiDropDown dropdown;
        int color;
        int names;
        int icons;
        boolean display;
        boolean initialDisplay;
        int totalNames;
        String[] dropdownOptions;
        ModOptions displayOption;

        public RadarCategory(String name, int color, int names, int icons, int totalNames, int index, String[] dropdownOptions, ModOptions displayOption) {
            this.name = name;
            this.color = color;
            this.names = names;
            this.icons = icons;
            this.display = this.initialDisplay = GuiEntityRadar.this.modMain.getSettings().getClientBooleanValue(displayOption);
            this.index = index;
            this.dropdownOptions = dropdownOptions;
            this.displayOption = displayOption;
            this.totalNames = totalNames;
        }

        public void init() {
            this.dropdown = new GuiDropDown(this.dropdownOptions, GuiEntityRadar.this.field_146294_l / 2 - 136, GuiEntityRadar.this.field_146295_m / 12 + 20 + 25 * this.index, 120, this.color, GuiEntityRadar.this);
            GuiEntityRadar.this.field_146292_n.add(new RadarCategoryButton(this, null, 0, GuiEntityRadar.this.field_146294_l / 2 - 13, GuiEntityRadar.this.field_146295_m / 12 + 16 + 25 * this.index, ModOptions.MOBS, this.getDisplayButtonText()));
            GuiEntityRadar.this.field_146292_n.add(new RadarCategoryButton(this, GuiEntityRadar.this.nameTooltip, 1, GuiEntityRadar.this.field_146294_l / 2 + 63, GuiEntityRadar.this.field_146295_m / 12 + 16 + 25 * this.index, I18n.func_135052_a((String)ModSettings.ENTITY_NAMES_OPTIONS[this.names], (Object[])new Object[0])));
            int icons = this.icons;
            if (icons < 0) {
                icons = -icons - 1;
            }
            RadarCategoryButton iconsButton = new RadarCategoryButton(this, GuiEntityRadar.this.iconTooltip, 2, GuiEntityRadar.this.field_146294_l / 2 + 139, GuiEntityRadar.this.field_146295_m / 12 + 16 + 25 * this.index, I18n.func_135052_a((String)ModSettings.ENTITY_ICONS_OPTIONS[icons], (Object[])new Object[0]));
            if (this.icons < 0) {
                iconsButton.field_146124_l = false;
            }
            GuiEntityRadar.this.field_146292_n.add(iconsButton);
        }

        public void render(int par1, int par2, float par3) {
            GuiEntityRadar.this.func_73732_a(GuiEntityRadar.this.field_146289_q, I18n.func_135052_a((String)this.name, (Object[])new Object[0]), GuiEntityRadar.this.field_146294_l / 2 - 176, GuiEntityRadar.this.field_146295_m / 12 + 22 + 25 * this.index, -5592406);
        }

        public boolean onDropdownRender(int par1, int par2, float par3, boolean closed) {
            if (closed == this.dropdown.isClosed()) {
                this.dropdown.drawButton(par1, par2, GuiEntityRadar.this.field_146295_m);
                return false;
            }
            return true;
        }

        public boolean onDropdownSelect(GuiDropDown menu, int selected) {
            if (menu == this.dropdown) {
                this.color = selected;
                return true;
            }
            return false;
        }

        public boolean onClick(double par1, double par2, int par3, boolean closed) {
            if (closed == this.dropdown.isClosed() && this.dropdown.onDropDown((int)par1, (int)par2, GuiEntityRadar.this.field_146295_m)) {
                this.dropdown.mouseClicked((int)par1, (int)par2, par3, GuiEntityRadar.this.field_146295_m);
                return true;
            }
            this.dropdown.setClosed(true);
            return false;
        }

        public boolean onRelease(double par1, double par2, int par3) {
            this.dropdown.mouseReleased((int)par1, (int)par2, par3, GuiEntityRadar.this.field_146295_m);
            return true;
        }

        public boolean onScroll(int mouseXScaled, int mouseYScaled, double wheel) {
            if (!this.dropdown.isClosed() && this.dropdown.onDropDown(mouseXScaled, mouseYScaled, GuiEntityRadar.this.field_146295_m)) {
                this.dropdown.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, GuiEntityRadar.this.field_146295_m);
                return true;
            }
            return false;
        }

        private void onSettingClicked(GuiButton b) {
            this.display = !this.display;
            b.field_146126_j = this.getDisplayButtonText();
        }

        private String getDisplayButtonText() {
            String s = "";
            boolean serverSetting = GuiEntityRadar.this.modMain.getSettings().getBooleanValue(this.displayOption);
            s = s + ModSettings.getTranslation(this.display) + (serverSetting != this.initialDisplay ? "\u00a7e (" + ModSettings.getTranslation(serverSetting) + ")" : "");
            return s;
        }

        public void onDisplayOptionConfirm(ModSettings settings) {
            if (this.display != this.initialDisplay) {
                try {
                    settings.setOptionValue(this.displayOption, 1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        public abstract void onConfirm(ModSettings var1);
    }
}

