/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.world.EnumDifficulty;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.settings.ModSettings;

public class MinimapRadar {
    public static final int radarPlayers = -1;
    public static final int radarShadow = -16777216;
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private ArrayList<Entity> players;
    private ArrayList<Entity> living;
    private ArrayList<Entity> livingTamed;
    private ArrayList<Entity> hostile;
    private ArrayList<Entity> items;
    private ArrayList<Entity> entities;
    private ArrayList<Entity> playersOtherTeams;

    public MinimapRadar(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
        this.players = new ArrayList();
        this.living = new ArrayList();
        this.livingTamed = new ArrayList();
        this.hostile = new ArrayList();
        this.items = new ArrayList();
        this.entities = new ArrayList();
        this.playersOtherTeams = new ArrayList();
    }

    public int getType(Entity e, EntityPlayer p, boolean ignoreTamed) {
        if (e instanceof EntityPlayer) {
            if (p.func_96124_cp() != ((EntityLivingBase)e).func_96124_cp()) {
                return 6;
            }
            return 1;
        }
        if (!ignoreTamed && e instanceof EntityTameable && ((EntityTameable)e).func_70909_n()) {
            return 7;
        }
        if (e.getEntityData().func_74764_b("hostileMinimap") ? e.getEntityData().func_74767_n("hostileMinimap") : Minecraft.func_71410_x().field_71441_e.func_175659_aa() != EnumDifficulty.PEACEFUL && !this.hostileException(e) && (e instanceof EntityMob || e instanceof IMob)) {
            return 2;
        }
        if (e instanceof EntityLiving) {
            return 3;
        }
        if (e instanceof EntityItem) {
            return 4;
        }
        return 0;
    }

    public void updateRadar(WorldClient world, EntityPlayer p, Entity renderEntity) {
        this.players.clear();
        this.hostile.clear();
        this.living.clear();
        this.items.clear();
        this.entities.clear();
        this.playersOtherTeams.clear();
        this.livingTamed.clear();
        List worldEntities = world.field_72996_f;
        for (Entity e : worldEntities) {
            try {
                int type = this.getType(e, p, false);
                if (type == 1 ? e != p && !this.modMain.getSettings().getShowPlayers() : (type == 2 ? !this.modMain.getSettings().getShowHostile() : (type == 3 ? !this.modMain.getSettings().getShowMobs() : (type == 4 ? !this.modMain.getSettings().getShowItems() : (type == 6 ? !this.modMain.getSettings().getShowOtherTeam() : (type == 7 ? !this.modMain.getSettings().getShowTamedMobs() : !this.modMain.getSettings().getShowOther())))))) continue;
                double offx = e.field_70165_t - renderEntity.field_70165_t;
                double offy = e.field_70161_v - renderEntity.field_70161_v;
                double offh = renderEntity.field_70163_u - e.field_70163_u;
                double offheight2 = offh * offh;
                double offx2 = offx * offx;
                double offy2 = offy * offy;
                double maxDistance = 50625.0 / (this.minimapSession.getMinimapProcessor().getMinimapZoom() * this.minimapSession.getMinimapProcessor().getMinimapZoom());
                if (offx2 > maxDistance || offy2 > maxDistance || offheight2 > (double)(this.modMain.getSettings().heightLimit * this.modMain.getSettings().heightLimit)) continue;
                ArrayList<Entity> typeList = this.entities;
                switch (type) {
                    case 1: {
                        typeList = this.players;
                        break;
                    }
                    case 2: {
                        typeList = this.hostile;
                        break;
                    }
                    case 3: {
                        typeList = this.living;
                        break;
                    }
                    case 4: {
                        typeList = this.items;
                        break;
                    }
                    case 6: {
                        typeList = this.playersOtherTeams;
                        break;
                    }
                    case 7: {
                        typeList = this.livingTamed;
                    }
                }
                typeList.add(e);
                if (this.modMain.getSettings().entityAmount == 0 || typeList.size() < 100 * this.modMain.getSettings().entityAmount) continue;
                break;
            }
            catch (Exception exc) {
            }
        }
    }

    private boolean hostileException(Entity e) {
        return false;
    }

    public double getEntityX(Entity e, float partial) {
        return e.field_70142_S + (e.field_70165_t - e.field_70142_S) * (double)partial;
    }

    public double getEntityZ(Entity e, float partial) {
        return e.field_70136_U + (e.field_70161_v - e.field_70136_U) * (double)partial;
    }

    public boolean shouldRenderEntity(Entity e) {
        return !e.func_70093_af() && !e.func_82150_aj();
    }

    public int getPlayerTeamColour(EntityPlayer p) {
        int teamColour = -1;
        if (p.func_96124_cp() != null && ((ScorePlayerTeam)p.func_96124_cp()).func_96668_e() != null && ((ScorePlayerTeam)p.func_96124_cp()).func_96668_e().length() >= 2) {
            String prefix = ((ScorePlayerTeam)p.func_96124_cp()).func_96668_e();
            try {
                teamColour = Minecraft.func_71410_x().field_71466_p.func_175064_b(prefix.charAt(prefix.length() - 1));
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }
        return teamColour;
    }

    public int getEntityColour(EntityPlayer p, Entity e, float offh) {
        int entityTeamColour;
        int type = this.getType(e, p, this.modMain.getSettings().tamedMobsColor == -1);
        if (type == 6 && this.modMain.getSettings().otherTeamColor == -1) {
            type = 1;
        }
        int color = type == 1 ? (this.modMain.getSettings().playersColor != -1 ? ModSettings.COLORS[this.modMain.getSettings().playersColor] : ((entityTeamColour = this.getPlayerTeamColour((EntityPlayer)e)) != -1 ? entityTeamColour : -1)) : (type == 2 ? ModSettings.COLORS[this.modMain.getSettings().hostileColor] : (type == 3 ? ModSettings.COLORS[this.modMain.getSettings().mobsColor] : (type == 4 ? ModSettings.COLORS[this.modMain.getSettings().itemsColor] : (type == 6 ? ModSettings.COLORS[this.modMain.getSettings().otherTeamColor] : (type == 7 ? ModSettings.COLORS[this.modMain.getSettings().tamedMobsColor] : ModSettings.COLORS[this.modMain.getSettings().otherColor])))));
        float brightness = this.getEntityBrightness(offh);
        if (brightness < 1.0f) {
            int l = color >> 16 & 0xFF;
            int i1 = color >> 8 & 0xFF;
            int j1 = color & 0xFF;
            if ((l = (int)((float)l * brightness)) > 255) {
                l = 255;
            }
            if ((i1 = (int)((float)i1 * brightness)) > 255) {
                i1 = 255;
            }
            if ((j1 = (int)((float)j1 * brightness)) > 255) {
                j1 = 255;
            }
            color = 0xFF000000 | l << 16 | i1 << 8 | j1;
        }
        return color;
    }

    public float getEntityBrightness(float offh) {
        float level = (float)this.modMain.getSettings().heightLimit - offh;
        if (level < 0.0f) {
            level = 0.0f;
        }
        float brightness = 1.0f;
        if (level <= (float)(this.modMain.getSettings().heightLimit / 2) && this.modMain.getSettings().showEntityHeight) {
            brightness = 0.25f + 0.25f * level / (float)this.modMain.getSettings().heightLimit;
        }
        return brightness;
    }

    public Iterator<Entity> getEntitiesIterator() {
        return this.entities.iterator();
    }

    public Iterator<Entity> getItemsIterator() {
        return this.items.iterator();
    }

    public Iterator<Entity> getLivingIterator() {
        return this.living.iterator();
    }

    public Iterator<Entity> getLivingTamedIterator() {
        return this.livingTamed.iterator();
    }

    public Iterator<Entity> getHostileIterator() {
        return this.hostile.iterator();
    }

    public Iterator<Entity> getPlayersIterator() {
        return this.players.iterator();
    }

    public Iterator<Entity> getPlayersOtherTeamsIterator() {
        return this.playersOtherTeams.iterator();
    }
}

