/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render.radar;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBat;
import net.minecraft.client.model.ModelDragon;
import net.minecraft.client.model.ModelEnderMite;
import net.minecraft.client.model.ModelGhast;
import net.minecraft.client.model.ModelGuardian;
import net.minecraft.client.model.ModelHorse;
import net.minecraft.client.model.ModelMagmaCube;
import net.minecraft.client.model.ModelSilverfish;
import net.minecraft.client.model.ModelSlime;
import net.minecraft.client.model.ModelSquid;
import net.minecraft.client.model.ModelWither;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderEnderman;
import net.minecraft.client.renderer.entity.RenderHorse;
import net.minecraft.client.renderer.entity.RenderOcelot;
import net.minecraft.client.renderer.entity.RenderPig;
import net.minecraft.client.renderer.entity.RenderSlime;
import net.minecraft.client.renderer.entity.RenderSpider;
import net.minecraft.client.renderer.entity.RenderWolf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.EntitySlime;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.util.ResourceLocation;
import xaero.common.minimap.render.radar.EntityIconPrerenderer;
import xaero.common.minimap.render.radar.custom.EndermanIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.EntityIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.HorseIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.PigIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.SlimeIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.SpiderIconCustomRenderer;
import xaero.common.minimap.render.radar.custom.WolfIconCustomRenderer;

public class EntityIconDefinitions {
    private static Method entityTextureMethod;
    public static Field horseModelHorseLeftEarField;
    public static Field horseModelHorseRightEarField;
    public static Field horseModelMuleLeftEarField;
    public static Field horseModelMuleRightEarField;
    private static ImmutableList<String> FIELD_FORCED_CLASSES;
    static ImmutableList<String> HEAD_HARDCODED_NAMES;
    static ImmutableList<String> HEAD_PARTS_HARDCODED_NAMES;
    static float slimeSquishBU;

    static boolean forceFieldCheck(ModelBase em) {
        return FIELD_FORCED_CLASSES.contains((Object)em.getClass().getName());
    }

    static void customTransformation(ModelBase em, Entity entity, EntityIconPrerenderer prerenderer) {
        if (em instanceof ModelBat) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (em instanceof ModelHorse) {
            GlStateManager.func_179114_b((float)65.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.7f, (float)0.7f, (float)0.7f);
        } else if (em instanceof ModelGuardian || em instanceof ModelSquid) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (entity instanceof EntitySlime) {
            EntitySlime slime = (EntitySlime)entity;
            slimeSquishBU = slime.field_70811_b;
            slime.field_70811_b = 0.0f;
        } else if (em instanceof ModelGhast || em instanceof ModelDragon) {
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)0.5f);
        } else if (em instanceof ModelWither) {
            GlStateManager.func_179152_a((float)0.35f, (float)0.35f, (float)0.35f);
        }
    }

    public static void customPostRenderTransformation(ModelBase ModelBase2, Entity entity) {
        if (entity instanceof EntitySlime) {
            EntitySlime slime = (EntitySlime)entity;
            slime.field_70811_b = slimeSquishBU;
        }
    }

    static boolean fullModelIcon(ModelBase em) {
        return em instanceof ModelEnderMite || em instanceof ModelGhast || em instanceof ModelMagmaCube || em instanceof ModelSlime || em instanceof ModelSilverfish || em instanceof ModelWither;
    }

    public static EntityIconCustomRenderer getCustomLayer(Render entityRenderer, Entity entity) {
        if (entityRenderer instanceof RenderSlime) {
            return new SlimeIconCustomRenderer();
        }
        if (entityRenderer instanceof RenderEnderman) {
            return new EndermanIconCustomRenderer();
        }
        if (entityRenderer instanceof RenderSpider) {
            return new SpiderIconCustomRenderer();
        }
        if (entityRenderer instanceof RenderHorse) {
            return new HorseIconCustomRenderer();
        }
        if (entityRenderer instanceof RenderWolf) {
            return new WolfIconCustomRenderer();
        }
        if (entityRenderer instanceof RenderPig) {
            return new PigIconCustomRenderer();
        }
        return null;
    }

    public static String getVariantString(Render entityRenderer, Entity entity) {
        ResourceLocation entityTexture = EntityIconDefinitions.getEntityTexture(entityRenderer, entity);
        if (entityTexture == null) {
            return "";
        }
        if (entityRenderer instanceof RenderOcelot) {
            return entityTexture + "%" + ((EntityOcelot)entity).func_70909_n();
        }
        if (entityRenderer instanceof RenderWolf) {
            return entityTexture + "%" + ((EntityWolf)entity).func_70909_n();
        }
        if (entityRenderer instanceof RenderPig) {
            EntityPig pig = (EntityPig)entity;
            return entityTexture + "%" + pig.func_70901_n();
        }
        return entityTexture.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ResourceLocation getEntityTexture(Render Render2, Entity e) {
        boolean accessibleBU = entityTextureMethod.isAccessible();
        try {
            entityTextureMethod.setAccessible(true);
            try {
                ResourceLocation resourceLocation = (ResourceLocation)entityTextureMethod.invoke((Object)Render2, e);
                return resourceLocation;
            }
            catch (Exception exc) {
                exc.printStackTrace();
                ResourceLocation resourceLocation = null;
                entityTextureMethod.setAccessible(accessibleBU);
                return resourceLocation;
            }
        }
        finally {
            entityTextureMethod.setAccessible(accessibleBU);
        }
    }

    static {
        FIELD_FORCED_CLASSES = ImmutableList.of();
        HEAD_HARDCODED_NAMES = ImmutableList.of((Object)"net.minecraft.client.model.ModelBat;batHead", (Object)"net.minecraft.client.model.ModelBat;field_82895_a", (Object)"net.minecraft.client.model.ModelBlaze;blazeHead", (Object)"net.minecraft.client.model.ModelBlaze;field_78105_b", (Object)"net.minecraft.client.model.ModelSpider;spiderHead", (Object)"net.minecraft.client.model.ModelSpider;field_78209_a", (Object)"net.minecraft.client.model.ModelCod;headFront", (Object)"net.minecraft.client.model.ModelCod;field_203726_d", (Object)"net.minecraft.client.model.ModelCreeper;head", (Object)"net.minecraft.client.model.ModelCreeper;field_78135_a", (Object)"net.minecraft.client.model.ModelParrot;head", (Object)"net.minecraft.client.model.ModelParrot;field_192768_e", (Object[])new String[]{"net.minecraft.client.model.ModelPhantom;body", "net.minecraft.client.model.ModelPhantom;field_203070_a", "net.minecraft.client.model.ModelRabbit;rabbitHead", "net.minecraft.client.model.ModelRabbit;field_178704_h", "net.minecraft.client.model.ModelRavager;head", "net.minecraft.client.model.ModelRavager;field_217168_a", "net.minecraft.client.model.ModelSquid;squidBody", "net.minecraft.client.model.ModelSquid;field_78202_a", "", "net.minecraft.client.model.ModelStrider;field_239120_f_", "net.minecraft.client.model.ModelIronGolem;ironGolemHead", "net.minecraft.client.model.ModelIronGolem;field_78178_a", "net.minecraft.client.model.ModelSnowMan;head", "net.minecraft.client.model.ModelSnowMan;field_78195_c", "net.minecraft.client.model.ModelDragon;head", "net.minecraft.client.model.ModelDragon;field_78221_a", "", "net.minecraft.client.model.ModelSalmon;field_203762_b", "net.minecraft.client.model.ModelOcelot;ocelotHead", "net.minecraft.client.model.ModelOcelot;field_78156_g", "net.minecraft.client.model.ModelChicken;head", "net.minecraft.client.model.ModelChicken;field_78142_a", "", "net.minecraft.client.model.ModelDolphin;field_205082_b", "net.minecraft.client.model.ModelGuardian;guardianBody", "net.minecraft.client.model.ModelGuardian;field_178710_a", "net.minecraft.client.model.ModelHorse;head", "net.minecraft.client.model.ModelHorse;field_110709_a", "net.minecraft.client.model.ModelMagmaCube;core", "net.minecraft.client.model.ModelMagmaCube;field_78108_b", "", "net.minecraft.client.model.ModelFox;field_217115_a", "net.minecraft.client.model.ModelWolf;wolfHeadMain", "net.minecraft.client.model.ModelWolf;field_78185_a", "net.minecraft.client.model.ModelIllager;head", "net.minecraft.client.model.ModelIllager;field_191217_a", "net.minecraft.client.model.ModelVillager;villagerHead", "net.minecraft.client.model.ModelVillager;field_78191_a"});
        HEAD_PARTS_HARDCODED_NAMES = ImmutableList.of((Object)"net.minecraft.client.model.ModelRabbit;rabbitRightEar", (Object)"net.minecraft.client.model.ModelRabbit;field_178705_i", (Object)"net.minecraft.client.model.ModelRabbit;rabbitLeftEar", (Object)"net.minecraft.client.model.ModelRabbit;field_178702_j", (Object)"net.minecraft.client.model.ModelRabbit;rabbitNose", (Object)"net.minecraft.client.model.ModelRabbit;field_178700_l", (Object)"", (Object)"net.minecraft.client.model.ModelSalmon;field_203761_a", (Object)"", (Object)"net.minecraft.client.model.ModelSalmon;field_203763_c", (Object)"", (Object)"net.minecraft.client.model.ModelSalmon;field_203767_g", (Object[])new String[]{"", "net.minecraft.client.model.ModelSalmon;field_203768_h", "net.minecraft.client.model.ModelChicken;bill", "net.minecraft.client.model.ModelChicken;field_78137_g", "net.minecraft.client.model.ModelChicken;chin", "net.minecraft.client.model.ModelChicken;field_78143_h", "net.minecraft.client.model.ModelHorse;mane", "net.minecraft.client.model.ModelHorse;field_110714_j"});
        try {
            entityTextureMethod = Render.class.getDeclaredMethod("func_110775_a", Entity.class);
        }
        catch (Exception e) {
            try {
                entityTextureMethod = Render.class.getDeclaredMethod("getEntityTexture", Entity.class);
            }
            catch (Exception e1) {
                throw new RuntimeException(e1);
            }
        }
        try {
            horseModelHorseLeftEarField = ModelHorse.class.getDeclaredField("horseLeftEar");
        }
        catch (NoSuchFieldException e) {
            try {
                horseModelHorseLeftEarField = ModelHorse.class.getDeclaredField("field_110705_d");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
        try {
            horseModelHorseRightEarField = ModelHorse.class.getDeclaredField("horseRightEar");
        }
        catch (NoSuchFieldException e) {
            try {
                horseModelHorseRightEarField = ModelHorse.class.getDeclaredField("field_110706_e");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
        try {
            horseModelMuleLeftEarField = ModelHorse.class.getDeclaredField("muleLeftEar");
        }
        catch (NoSuchFieldException e) {
            try {
                horseModelMuleLeftEarField = ModelHorse.class.getDeclaredField("field_110703_f");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
        try {
            horseModelMuleRightEarField = ModelHorse.class.getDeclaredField("muleRightEar");
        }
        catch (NoSuchFieldException e) {
            try {
                horseModelMuleRightEarField = ModelHorse.class.getDeclaredField("field_110704_g");
            }
            catch (NoSuchFieldException e1) {
                e1.printStackTrace();
            }
        }
    }
}

