/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.event.ClickEvent;
import net.minecraft.event.HoverEvent;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.common.DimensionManager;
import xaero.common.IXaeroMinimap;
import xaero.common.XaeroMinimapSession;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;

public class WaypointSharingHandler
implements GuiYesNoCallback {
    public static final String WAYPOINT_OLD_SHARE_PREFIX = "xaero_waypoint:";
    public static final String WAYPOINT_ADD_PREFIX = "xaero_waypoint_add:";
    public static final String WAYPOINT_SHARE_PREFIX = "xaero-waypoint:";
    private IXaeroMinimap modMain;
    private XaeroMinimapSession minimapSession;
    private GuiScreen parent;
    private Waypoint w;
    private WaypointWorld wWorld;

    public WaypointSharingHandler(IXaeroMinimap modMain, XaeroMinimapSession minimapSession) {
        this.modMain = modMain;
        this.minimapSession = minimapSession;
    }

    public void shareWaypoint(GuiScreen parent, Waypoint w, WaypointWorld wWorld) {
        this.parent = parent;
        this.w = w;
        this.wWorld = wWorld;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_share_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_share_msg2", (Object[])new Object[0]), 0));
    }

    public void onWaypointReceived(String text, ClientChatReceivedEvent e) {
        boolean newFormat = (text = text.replaceAll("\u00a7.", "")).contains(WAYPOINT_SHARE_PREFIX);
        String sharePrefix = newFormat ? WAYPOINT_SHARE_PREFIX : WAYPOINT_OLD_SHARE_PREFIX;
        String[] args = text.substring(text.indexOf(sharePrefix)).split(":");
        if (newFormat) {
            args[1] = this.restoreFormatting(args[1]);
            args[2] = this.restoreFormatting(args[2]);
            if (args.length > 9) {
                args[9] = this.restoreFormatting(args[9]);
            }
        }
        ChatComponentText component = null;
        if (args.length < 9) {
            System.out.println("Incorrect format of the shared waypoint! Error: 0");
        } else {
            String newText;
            block14: {
                String playerName = text.substring(0, text.indexOf(sharePrefix));
                int lastGreater = playerName.lastIndexOf(">");
                if (lastGreater != -1) {
                    playerName = playerName.substring(0, lastGreater).replaceFirst("<", "");
                }
                newText = playerName + " shared a waypoint called \"" + I18n.func_135052_a((String)Waypoint.getStringFromStringSafe(args[1], "^col^"), (Object[])new Object[0]) + "\"";
                if (args.length > 9 && args[9].startsWith("Internal_")) {
                    try {
                        String details = args[9].substring(9, args[9].lastIndexOf("_")).replace("^col^", ":");
                        newText = newText + " from ";
                        if (details.startsWith("dim%")) {
                            if (details.length() == 4) {
                                newText = newText + "an unknown dimension";
                                break block14;
                            }
                            Integer dimId = this.minimapSession.getWaypointsManager().getDimensionForDirectoryName(details);
                            if (dimId == null) {
                                newText = newText + "an unknown dimension";
                                break block14;
                            }
                            Integer dt = null;
                            try {
                                dt = DimensionManager.getProviderType((int)dimId);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                            newText = dt == null ? newText + "an unknown dimension" : newText + DimensionManager.createProviderFor((int)dimId).func_80007_l();
                            break block14;
                        }
                        newText = newText + details;
                    }
                    catch (IndexOutOfBoundsException details) {
                        // empty catch block
                    }
                }
            }
            newText = newText + "! \u00a72\u00a7n[Add]";
            newText = newText.replaceAll("\u00a7r", "\u00a7r\u00a77").replaceAll("\u00a7f", "\u00a77");
            component = new ChatComponentText(newText);
            ChatComponentText hoverComponent = new ChatComponentText(args[3] + ", " + args[4] + ", " + args[5]);
            StringBuilder addCommandBuilder = new StringBuilder();
            addCommandBuilder.append("/xaero ");
            addCommandBuilder.append(WAYPOINT_ADD_PREFIX);
            addCommandBuilder.append(args[1]);
            for (int i = 2; i < args.length; ++i) {
                addCommandBuilder.append(':').append(args[i]);
            }
            String addCommand = addCommandBuilder.toString();
            component.func_150256_b().func_150238_a(EnumChatFormatting.GRAY).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, addCommand)).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (IChatComponent)hoverComponent));
        }
        e.message = component;
    }

    public void onWaypointAdd(String[] args) {
        String waypointName = Waypoint.getStringFromStringSafe(args[1], "^col^");
        if (waypointName.length() < 1 || waypointName.length() > 32) {
            System.out.println("Incorrect format of the shared waypoint! Error: 1");
            return;
        }
        String waypointSymbol = Waypoint.getStringFromStringSafe(args[2], "^col^");
        if (waypointSymbol.length() < 1 || waypointSymbol.length() > 3) {
            System.out.println("Incorrect format of the shared waypoint! Error: 2");
            return;
        }
        try {
            if (this.minimapSession.getWaypointsManager().getAutoContainerID() == null) {
                System.out.println("Can't add a waypoint at this time!");
                return;
            }
            int x = Integer.parseInt(args[3]);
            int y = Integer.parseInt(args[4]);
            int z = Integer.parseInt(args[5]);
            int color = Integer.parseInt(args[6]);
            String yawString = args[8];
            if (yawString.length() > 4) {
                System.out.println("Incorrect format of the shared waypoint! Error: 4");
                return;
            }
            int yaw = Integer.parseInt(yawString);
            boolean rotation = args[7].equals("true");
            Waypoint w = new Waypoint(x, y, z, waypointName, waypointSymbol, color, 0);
            w.setRotation(rotation);
            w.setYaw(yaw);
            String externalContainerId = this.minimapSession.getWaypointsManager().getCurrentContainerID().split("/")[0];
            WaypointWorld externalWorld = this.minimapSession.getWaypointsManager().getCurrentWorld();
            String parentContainerId = externalContainerId;
            WaypointWorld currentWorld = externalWorld;
            if (args.length > 9) {
                String worldDetails = args[9];
                if (worldDetails.length() > 9 && worldDetails.startsWith("Internal_")) {
                    String subContainers;
                    int divider = worldDetails.lastIndexOf(95);
                    if (divider < 1 || divider == worldDetails.length() - 1) {
                        System.out.println("Incorrect format of the shared waypoint! Error: 5");
                        return;
                    }
                    String worldId = worldDetails.substring(divider + 1);
                    if (!worldId.replaceAll("[^a-zA-Z0-9,\\$-]+", "").equals(worldId)) {
                        System.out.println("Incorrect format of the shared waypoint! Error: 7");
                        return;
                    }
                    boolean destinationDimensionExists = true;
                    try {
                        subContainers = worldDetails.substring(9, divider);
                    }
                    catch (IndexOutOfBoundsException eoobe) {
                        subContainers = null;
                    }
                    parentContainerId = this.minimapSession.getWaypointsManager().getAutoRootContainerID();
                    String containerId = null;
                    if (subContainers != null) {
                        CharSequence[] subContainersArgs = (subContainers = subContainers.replace("^col^", ":")).split("/");
                        if (subContainersArgs.length > 1) {
                            System.out.println("Incorrect format of the shared waypoint! Error: 8");
                            return;
                        }
                        for (int i = 0; i < subContainersArgs.length; ++i) {
                            String s = subContainersArgs[i];
                            if (!s.isEmpty()) continue;
                            System.out.println("Incorrect format of the shared waypoint! Error: 11");
                            return;
                        }
                        String dimContainer = subContainersArgs[0];
                        Integer dimId = null;
                        if (!dimContainer.startsWith("dim%")) {
                            if (!dimContainer.replaceAll("[^a-zA-Z0-9_]+", "").equals(dimContainer)) {
                                System.out.println("Incorrect format of the shared waypoint! Error: 18");
                                return;
                            }
                            dimId = this.minimapSession.getWaypointsManager().findFirstDimensionId(dimContainer);
                        } else {
                            dimId = this.minimapSession.getWaypointsManager().getDimensionForDirectoryName(dimContainer);
                        }
                        if (dimId == null) {
                            System.out.println("Destination dimension doesn't exists! Handling waypoint as external.");
                            parentContainerId = externalContainerId;
                            currentWorld = externalWorld;
                            destinationDimensionExists = false;
                        } else {
                            subContainersArgs[0] = this.minimapSession.getWaypointsManager().getDimensionDirectoryName(dimId);
                            subContainers = String.join((CharSequence)"/", subContainersArgs);
                            containerId = parentContainerId + "/" + subContainers;
                            WaypointWorldContainer rootContainer = this.minimapSession.getWaypointsManager().getWorldContainer(parentContainerId);
                            rootContainer.renameOldContainer(containerId);
                        }
                    } else {
                        containerId = parentContainerId;
                    }
                    if (destinationDimensionExists) {
                        String autoWorldId = this.minimapSession.getWaypointsManager().getAutoWorldID();
                        if (worldId.equals("waypoints")) {
                            worldId = autoWorldId;
                        } else if (autoWorldId.equals("waypoints")) {
                            worldId = "waypoints";
                        }
                        File securityTest = new File(this.modMain.getWaypointsFolder(), containerId + "/" + worldId + (worldId.equals("waypoints") ? "" : "_1") + ".txt");
                        try {
                            if (!securityTest.getPath().equals(securityTest.getCanonicalPath())) {
                                System.out.println("Dangerously incorrect format of the shared waypoint! Error: 10");
                                return;
                            }
                        }
                        catch (IOException e) {
                            System.out.println("IO error adding a shared waypoint!");
                            return;
                        }
                        currentWorld = this.minimapSession.getWaypointsManager().getWorld(containerId, worldId);
                    }
                } else if (!worldDetails.equals("External")) {
                    System.out.println("Incorrect format of the shared waypoint! Error: 12");
                    return;
                }
            }
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAddWaypoint(this.modMain, this.minimapSession.getWaypointsManager(), null, Lists.newArrayList((Object[])new Waypoint[]{w}), parentContainerId, currentWorld, true));
        }
        catch (NumberFormatException nfe) {
            System.out.println("Incorrect format of the shared waypoint! Error: 3");
            return;
        }
    }

    public void func_73878_a(boolean p_confirmResult_1_, int p_confirmResult_2_) {
        switch (p_confirmResult_2_) {
            case 0: {
                String worldDetails;
                WaypointWorldRootContainer autoRootContainer;
                if (!p_confirmResult_1_) break;
                WaypointWorldRootContainer rootContainer = this.wWorld.getContainer().getRootContainer();
                if (rootContainer == (autoRootContainer = this.minimapSession.getWaypointsManager().getAutoWorld().getContainer().getRootContainer())) {
                    String details;
                    String containerId = this.wWorld.getContainer().getKey();
                    int firstSlashIndex = containerId.indexOf("/");
                    if (firstSlashIndex != -1) {
                        String subContainers = containerId.substring(firstSlashIndex + 1);
                        CharSequence[] subContainersSplit = subContainers.split("/");
                        if (subContainersSplit[0].equals("dim%0")) {
                            subContainersSplit[0] = "Overworld";
                        } else if (subContainersSplit[0].equals("dim%-1")) {
                            subContainersSplit[0] = "Nether";
                        } else if (((String)subContainersSplit[0]).equals("dim%1")) {
                            subContainersSplit[0] = "TheEnd";
                        }
                        subContainers = String.join((CharSequence)"/", subContainersSplit);
                        details = subContainers.replace(":", "^col^") + "_" + this.wWorld.getId();
                    } else {
                        details = this.wWorld.getId();
                    }
                    worldDetails = "Internal_" + details;
                } else {
                    worldDetails = "External";
                }
                String message = WAYPOINT_SHARE_PREFIX + this.removeFormatting(this.w.getNameSafe("^col^")) + ":" + this.removeFormatting(this.w.getSymbolSafe("^col^")) + ":" + this.w.getX() + ":" + this.w.getY() + ":" + this.w.getZ() + ":" + this.w.getColor() + ":" + this.w.isRotation() + ":" + this.w.getYaw() + ":" + this.removeFormatting(worldDetails);
                Minecraft.func_71410_x().field_71462_r.func_175281_b(message, true);
                Minecraft.func_71410_x().func_147108_a(null);
                return;
            }
        }
        Minecraft.func_71410_x().func_147108_a(this.parent);
    }

    private String removeFormatting(String s) {
        return s.replace("-", "^min^").replace("_", "-").replace("*", "^ast^");
    }

    private String restoreFormatting(String s) {
        return s.replace("^ast^", "*").replace("-", "_").replace("^min^", "-");
    }
}

