/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.event;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import melonslise.locks.client.init.LocksRenderTypes;
import melonslise.locks.client.util.LocksClientUtil;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ISelection;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksItemTags;
import melonslise.locks.common.util.Lockable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.culling.ClippingHelper;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.properties.AttachFace;
import net.minecraft.util.Hand;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="locks", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LocksClientForgeEvents {
    public static Lockable tooltipLockable;

    private LocksClientForgeEvents() {
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (e.phase != TickEvent.Phase.START || mc.field_71441_e == null || mc.func_147113_T()) {
            return;
        }
        ((ILockableHandler)mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null)).getLoaded().values().forEach(lkb -> lkb.tick());
    }

    @SubscribeEvent
    public static void onRenderWorld(RenderWorldLastEvent e) {
        Minecraft mc = Minecraft.func_71410_x();
        MatrixStack mtx = e.getMatrixStack();
        IRenderTypeBuffer.Impl buf = mc.func_228019_au_().func_228487_b_();
        LocksClientForgeEvents.renderSelection(mtx, buf);
    }

    public static boolean holdingPick(PlayerEntity player) {
        for (Hand hand : Hand.values()) {
            if (!player.func_184586_b(hand).func_77973_b().func_206844_a(LocksItemTags.LOCK_PICKS)) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void onRenderOverlay(RenderGameOverlayEvent.Pre e) {
        Minecraft mc = Minecraft.func_71410_x();
        if (e.getType() != RenderGameOverlayEvent.ElementType.ALL || tooltipLockable == null) {
            return;
        }
        if (LocksClientForgeEvents.holdingPick((PlayerEntity)mc.field_71439_g)) {
            MatrixStack mtx = e.getMatrixStack();
            Vector3f vec = LocksClientUtil.worldToScreen(LocksClientForgeEvents.tooltipLockable.getLockState((World)mc.field_71441_e).pos, e.getPartialTicks());
            if ((double)vec.func_195902_c() < 0.0) {
                mtx.func_227860_a_();
                mtx.func_227861_a_((double)vec.func_195899_a(), (double)vec.func_195900_b(), 0.0);
                LocksClientForgeEvents.renderHudTooltip(mtx, Lists.transform((List)LocksClientForgeEvents.tooltipLockable.stack.func_82840_a((PlayerEntity)mc.field_71439_g, (ITooltipFlag)(mc.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL)), ITextComponent::func_241878_f), mc.field_71466_p);
                mtx.func_227865_b_();
            }
        }
        tooltipLockable = null;
    }

    public static void renderLocks(MatrixStack mtx, IRenderTypeBuffer.Impl buf, ClippingHelper ch, float pt) {
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d o = LocksClientUtil.getCamera().func_216785_c();
        BlockPos.Mutable mut = new BlockPos.Mutable();
        double dMin = 0.0;
        for (Lockable lkb : ((ILockableHandler)mc.field_71441_e.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null)).getLoaded().values()) {
            Vector3d look;
            double d1;
            Lockable.State state = lkb.getLockState((World)mc.field_71441_e);
            if (state == null || !state.inRange(o) || !state.inView(ch)) continue;
            double d = o.func_178788_d(state.pos).func_189985_c();
            if (d <= 25.0 && (d1 = LocksClientUtil.distanceToLineSq(state.pos, o, look = o.func_178787_e(mc.field_71439_g.func_70676_i(pt)))) <= 4.0 && (dMin == 0.0 || d1 < dMin)) {
                tooltipLockable = lkb;
                dMin = d1;
            }
            mtx.func_227860_a_();
            mtx.func_227861_a_(state.pos.field_72450_a - o.field_72450_a, state.pos.field_72448_b - o.field_72448_b, state.pos.field_72449_c - o.field_72449_c);
            mtx.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(-state.tr.dir.func_185119_l() - 180.0f));
            if (state.tr.face != AttachFace.WALL) {
                mtx.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            }
            mtx.func_227861_a_(0.0, 0.1, 0.0);
            mtx.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(MathHelper.func_76126_a((float)(LocksClientUtil.cubicBezier1d(1.0f, 1.0f, LocksClientUtil.lerp(lkb.maxSwingTicks - lkb.oldSwingTicks, lkb.maxSwingTicks - lkb.swingTicks, pt) / (float)lkb.maxSwingTicks) * (float)lkb.maxSwingTicks / 5.0f * 3.14f)) * 10.0f));
            mtx.func_227861_a_(0.0, -0.1, 0.0);
            mtx.func_227862_a_(0.5f, 0.5f, 0.5f);
            int light = WorldRenderer.func_228421_a_((IBlockDisplayReader)mc.field_71441_e, (BlockPos)mut.func_189532_c(state.pos.field_72450_a, state.pos.field_72448_b, state.pos.field_72449_c));
            mc.func_175599_af().func_229110_a_(lkb.stack, ItemCameraTransforms.TransformType.FIXED, light, OverlayTexture.field_229196_a_, mtx, (IRenderTypeBuffer)buf);
            mtx.func_227865_b_();
        }
        buf.func_228461_a_();
    }

    public static void renderSelection(MatrixStack mtx, IRenderTypeBuffer.Impl buf) {
        Minecraft mc = Minecraft.func_71410_x();
        Vector3d o = LocksClientUtil.getCamera().func_216785_c();
        ISelection select = (ISelection)mc.field_71439_g.getCapability(LocksCapabilities.SELECTION).orElse(null);
        if (select == null) {
            return;
        }
        BlockPos pos = select.get();
        if (pos == null) {
            return;
        }
        BlockPos pos1 = mc.field_71476_x instanceof BlockRayTraceResult ? ((BlockRayTraceResult)mc.field_71476_x).func_216350_a() : pos;
        boolean allow = Math.abs(pos.func_177958_n() - pos1.func_177958_n()) * Math.abs(pos.func_177956_o() - pos1.func_177956_o()) * Math.abs(pos.func_177952_p() - pos1.func_177952_p()) <= (Integer)LocksServerConfig.MAX_LOCKABLE_VOLUME.get() && LocksServerConfig.canLock((World)mc.field_71441_e, pos1);
        WorldRenderer.func_228427_a_((MatrixStack)mtx, (IVertexBuilder)buf.getBuffer(LocksRenderTypes.OVERLAY_LINES), (double)((double)Math.min(pos.func_177958_n(), pos1.func_177958_n()) - o.field_72450_a), (double)((double)Math.min(pos.func_177956_o(), pos1.func_177956_o()) - o.field_72448_b), (double)((double)Math.min(pos.func_177952_p(), pos1.func_177952_p()) - o.field_72449_c), (double)((double)Math.max(pos.func_177958_n(), pos1.func_177958_n()) + 1.0 - o.field_72450_a), (double)((double)Math.max(pos.func_177956_o(), pos1.func_177956_o()) + 1.0 - o.field_72448_b), (double)((double)Math.max(pos.func_177952_p(), pos1.func_177952_p()) + 1.0 - o.field_72449_c), (float)(allow ? 0.0f : 1.0f), (float)(allow ? 1.0f : 0.0f), (float)0.0f, (float)0.5f);
        RenderSystem.disableDepthTest();
        buf.func_228461_a_();
    }

    /*
     * WARNING - void declaration
     */
    public static void renderHudTooltip(MatrixStack mtx, List<? extends IReorderingProcessor> lines, FontRenderer font) {
        if (lines.isEmpty()) {
            return;
        }
        int width = 0;
        for (IReorderingProcessor iReorderingProcessor : lines) {
            int j = font.func_243245_a(iReorderingProcessor);
            if (j <= width) continue;
            width = j;
        }
        int x = 36;
        int n = -36;
        int height = 8;
        if (lines.size() > 1) {
            height += 2 + (lines.size() - 1) * 10;
        }
        mtx.func_227860_a_();
        BufferBuilder buf = Tessellator.func_178181_a().func_178180_c();
        buf.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        LocksClientUtil.square(buf, mtx, 0.0f, 0.0f, 4.0f, 0.05f, 0.0f, 0.3f, 0.8f);
        LocksClientUtil.line(buf, mtx, 1.0f, -1.0f, (float)x / 3.0f + 0.6f, (float)n / 2.0f, 2.0f, 0.05f, 0.0f, 0.3f, 0.8f);
        LocksClientUtil.line(buf, mtx, (float)x / 3.0f, (float)n / 2.0f, (float)x - 3.0f, (float)n / 2.0f, 2.0f, 0.05f, 0.0f, 0.3f, 0.8f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n - 4, x + width + 3, n - 3, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n + height + 3, x + width + 3, n + height + 4, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n - 3, x + width + 3, n + height + 3, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f);
        LocksClientUtil.vGradient(buf, mtx, x - 4, n - 3, x - 3, n + height + 3, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f);
        LocksClientUtil.vGradient(buf, mtx, x + width + 3, n - 3, x + width + 4, n + height + 3, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f, 0.0627451f, 0.0f, 0.0627451f, 0.9411765f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n - 3 + 1, x - 3 + 1, n + height + 3 - 1, 0.3137255f, 0.0f, 1.0f, 0.3137255f, 0.15686275f, 0.0f, 0.49803922f, 0.3137255f);
        LocksClientUtil.vGradient(buf, mtx, x + width + 2, n - 3 + 1, x + width + 3, n + height + 3 - 1, 0.3137255f, 0.0f, 1.0f, 0.3137255f, 0.15686275f, 0.0f, 0.49803922f, 0.3137255f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n - 3, x + width + 3, n - 3 + 1, 0.3137255f, 0.0f, 1.0f, 0.3137255f, 0.3137255f, 0.0f, 1.0f, 0.3137255f);
        LocksClientUtil.vGradient(buf, mtx, x - 3, n + height + 2, x + width + 3, n + height + 3, 0.15686275f, 0.0f, 0.49803922f, 0.3137255f, 0.15686275f, 0.0f, 0.49803922f, 0.3137255f);
        RenderSystem.enableDepthTest();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        buf.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)buf);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableTexture();
        IRenderTypeBuffer.Impl buf1 = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        Matrix4f last = mtx.func_227866_c_().func_227870_a_();
        for (int a = 0; a < lines.size(); ++a) {
            IReorderingProcessor line = lines.get(a);
            if (line != null) {
                void var5_8;
                font.func_238416_a_(line, (float)x, (float)var5_8, -1, true, last, (IRenderTypeBuffer)buf1, false, 0, 0xF000F0);
            }
            if (a == 0) {
                var5_8 += 2;
            }
            var5_8 += 10;
        }
        buf1.func_228461_a_();
        mtx.func_227865_b_();
    }
}

