/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.client.gui.sprite;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayDeque;
import java.util.Queue;
import melonslise.locks.client.gui.sprite.TextureInfo;
import melonslise.locks.client.gui.sprite.action.IAction;
import melonslise.locks.client.util.LocksClientUtil;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class Sprite {
    private Queue<IAction> actions = new ArrayDeque<IAction>(4);
    public TextureInfo tex;
    public float posX;
    public float posY;
    public float oldPosX;
    public float oldPosY;
    public float speedX;
    public float speedY;
    public float rot;
    public float oldRot;
    public float rotSpeed;
    public float originX;
    public float originY;
    public float alpha = 1.0f;
    public float oldAlpha = 1.0f;

    public Sprite(TextureInfo tex) {
        this.tex = tex;
    }

    public Sprite position(float posX, float posY) {
        this.posX = this.oldPosX = posX;
        this.posY = this.oldPosY = posY;
        return this;
    }

    public Sprite rotation(float rot, float originX, float originY) {
        this.rot = this.oldRot = rot;
        this.originX = originX;
        this.originY = originY;
        return this;
    }

    public Sprite alpha(float alpha) {
        this.alpha = this.oldAlpha = alpha;
        return this;
    }

    public void execute(IAction ... actions) {
        for (IAction action : actions) {
            this.actions.offer(action);
        }
    }

    public boolean isExecuting() {
        return !this.actions.isEmpty();
    }

    public void draw(MatrixStack mtx, float partialTick) {
        if (this.alpha <= 0.0f) {
            return;
        }
        mtx.func_227860_a_();
        mtx.func_227861_a_((double)this.originX, (double)this.originY, 0.0);
        mtx.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(LocksClientUtil.lerp(this.oldRot, this.rot, partialTick)));
        mtx.func_227861_a_((double)(-this.originX), (double)(-this.originY), 0.0);
        this.tex.draw(mtx, LocksClientUtil.lerp(this.oldPosX, this.posX, partialTick), LocksClientUtil.lerp(this.oldPosY, this.posY, partialTick), LocksClientUtil.lerp(this.oldAlpha, this.alpha, partialTick));
        mtx.func_227865_b_();
    }

    public void update() {
        this.oldPosX = this.posX;
        this.oldPosY = this.posY;
        this.oldRot = this.rot;
        this.oldAlpha = this.alpha;
        this.posX += this.speedX;
        this.posY += this.speedY;
        this.rot += this.rotSpeed;
        IAction action = this.actions.peek();
        if (action == null) {
            return;
        }
        if (action.isFinished(this)) {
            this.actions.poll().finish(this);
        } else {
            action.update(this);
        }
    }
}

