/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.capability;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.util.Lockable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.chunk.Chunk;

public class LockableStorage
implements ILockableStorage {
    public static final ResourceLocation ID = new ResourceLocation("locks", "lockable_storage");
    public final Chunk chunk;
    public Int2ObjectMap<Lockable> lockables = new Int2ObjectLinkedOpenHashMap();

    public LockableStorage(Chunk chunk) {
        this.chunk = chunk;
    }

    @Override
    public Int2ObjectMap<Lockable> get() {
        return this.lockables;
    }

    @Override
    public void add(Lockable lkb) {
        this.lockables.put(lkb.id, (Object)lkb);
        this.chunk.func_76630_e();
    }

    @Override
    public void remove(int id) {
        this.lockables.remove(id);
        this.chunk.func_76630_e();
    }

    public ListNBT serializeNBT() {
        ListNBT list = new ListNBT();
        for (Lockable lkb : this.lockables.values()) {
            list.add((Object)Lockable.toNbt(lkb));
        }
        return list;
    }

    public void deserializeNBT(ListNBT nbt) {
        ILockableHandler handler = (ILockableHandler)this.chunk.func_177412_p().getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        Int2ObjectMap<Lockable> lkbs = handler.getLoaded();
        for (int a = 0; a < nbt.size(); ++a) {
            CompoundNBT nbt1 = nbt.func_150305_b(a);
            Lockable lkb = (Lockable)lkbs.get(Lockable.idFromNbt(nbt1));
            if (lkb == lkbs.defaultReturnValue()) {
                lkb = Lockable.fromNbt(nbt1);
                lkb.addObserver(handler);
                lkbs.put(lkb.id, (Object)lkb);
            }
            this.lockables.put(lkb.id, (Object)lkb);
        }
    }
}

