/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.event;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ILockableStorage;
import melonslise.locks.common.capability.ISelection;
import melonslise.locks.common.config.LocksClientConfig;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksConfiguredFeatures;
import melonslise.locks.common.init.LocksItemTags;
import melonslise.locks.common.init.LocksItems;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.KeyRingItem;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="locks", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class LocksForgeEvents {
    public static final ITextComponent LOCKED_MESSAGE = new TranslationTextComponent("locks.status.locked");

    private LocksForgeEvents() {
    }

    @SubscribeEvent
    public static void attachCapabilitiesToWorld(AttachCapabilitiesEvent<World> e) {
        LocksCapabilities.attachToWorld(e);
    }

    @SubscribeEvent
    public static void attachCapabilitiesToChunk(AttachCapabilitiesEvent<Chunk> e) {
        LocksCapabilities.attachToChunk(e);
    }

    @SubscribeEvent
    public static void attachCapabilitiesToEntity(AttachCapabilitiesEvent<Entity> e) {
        LocksCapabilities.attachToEntity(e);
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void onBiomeLoad(BiomeLoadingEvent e) {
        LocksConfiguredFeatures.addTo(e);
    }

    @SubscribeEvent
    public static void onLootTableLoad(LootTableLoadEvent e) {
        ResourceLocation name = e.getName();
        if (!name.func_110624_b().equals("minecraft") || !name.func_110623_a().startsWith("chests")) {
            return;
        }
        ResourceLocation injectLoc = new ResourceLocation("locks", "loot_tables/inject/" + name.func_110623_a() + ".json");
        if (!LocksUtil.resourceManager.func_219533_b(injectLoc)) {
            return;
        }
        try {
            LocksUtil.mergeEntries(e.getTable(), LocksUtil.lootTableFrom(injectLoc));
        }
        catch (IOException | IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException ex) {
            ex.printStackTrace();
        }
    }

    @SubscribeEvent
    public static void addVillagerTrades(VillagerTradesEvent e) {
        if (e.getType() != VillagerProfession.field_221164_n) {
            return;
        }
        Int2ObjectMap levels = e.getTrades();
        List trades = (List)levels.get(1);
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)LocksItems.WOOD_LOCK_PICK.get()), 1, 2, 16, 2, 0.05f));
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)LocksItems.WOOD_LOCK_MECHANISM.get()), 2, 1, 12, 1, 0.2f));
        trades = (List)levels.get(2);
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)LocksItems.IRON_LOCK_PICK.get()), 2, 2, 16, 5, 0.05f));
        trades = (List)levels.get(3);
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)LocksItems.GOLD_LOCK_PICK.get()), 6, 2, 12, 20, 0.05f));
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)LocksItems.IRON_LOCK_MECHANISM.get()), 5, 1, 8, 10, 0.2f));
        trades = (List)levels.get(4);
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)LocksItems.STEEL_LOCK_PICK.get()), 4, 2, 16, 20, 0.05f));
        trades = (List)levels.get(5);
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)LocksItems.DIAMOND_LOCK_PICK.get()), 8, 2, 12, 30, 0.05f));
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade(new ItemStack((IItemProvider)LocksItems.STEEL_LOCK_MECHANISM.get()), 8, 1, 8, 30, 0.2f));
    }

    @SubscribeEvent
    public static void addWandererTrades(WandererTradesEvent e) {
        List trades = e.getGenericTrades();
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade((Item)LocksItems.GOLD_LOCK_PICK.get(), 5, 2, 6, 1));
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade((Item)LocksItems.STEEL_LOCK_PICK.get(), 3, 2, 8, 1));
        trades.add(new VillagerTrades.EnchantedItemForEmeraldsTrade((Item)LocksItems.STEEL_LOCK.get(), 16, 4, 1));
        trades = e.getRareTrades();
        trades.add(new VillagerTrades.ItemsForEmeraldsTrade((Item)LocksItems.STEEL_LOCK_MECHANISM.get(), 6, 1, 4, 1));
        trades.add(new VillagerTrades.EnchantedItemForEmeraldsTrade((Item)LocksItems.DIAMOND_LOCK.get(), 28, 4, 1));
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload e) {
        Chunk ch = (Chunk)e.getChunk();
        ILockableHandler handler = (ILockableHandler)ch.func_177412_p().getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        ((ILockableStorage)ch.getCapability(LocksCapabilities.LOCKABLE_STORAGE).orElse(null)).get().values().forEach(lkb -> {
            handler.getLoaded().remove(lkb.id);
            lkb.deleteObserver(handler);
        });
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock e) {
        BlockPos pos = e.getPos();
        World world = e.getWorld();
        PlayerEntity player = e.getPlayer();
        ILockableHandler handler = (ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        Lockable[] intersect = (Lockable[])handler.getInChunk(pos).values().stream().filter(lkb -> lkb.bb.intersects(pos)).toArray(Lockable[]::new);
        if (intersect.length == 0) {
            return;
        }
        if (e.getHand() != Hand.MAIN_HAND) {
            e.setUseBlock(Event.Result.DENY);
            return;
        }
        ItemStack stack = e.getItemStack();
        Optional<Lockable> locked = Arrays.stream(intersect).filter(LocksPredicates.LOCKED).findFirst();
        if (locked.isPresent()) {
            Lockable lkb2 = locked.get();
            e.setUseBlock(Event.Result.DENY);
            Item item = stack.func_77973_b();
            if (!(item.func_206844_a(LocksItemTags.LOCK_PICKS) || item == LocksItems.MASTER_KEY.get() || item.func_206844_a(LocksItemTags.KEYS) && LockingItem.getOrSetId(stack) == lkb2.lock.id || item == LocksItems.KEY_RING.get() && KeyRingItem.containsId(stack, lkb2.lock.id))) {
                lkb2.swing(20);
                world.func_184133_a(player, pos, (SoundEvent)LocksSoundEvents.LOCK_RATTLE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            player.func_184609_a(Hand.MAIN_HAND);
            if (world.field_72995_K && ((Boolean)LocksClientConfig.DEAF_MODE.get()).booleanValue()) {
                player.func_146105_b(LOCKED_MESSAGE, true);
            }
            return;
        }
        if (((Boolean)LocksServerConfig.ALLOW_REMOVING_LOCKS.get()).booleanValue() && player.func_225608_bj_() && stack.func_190926_b()) {
            Lockable[] match = (Lockable[])Arrays.stream(intersect).filter(LocksPredicates.NOT_LOCKED).toArray(Lockable[]::new);
            if (match.length == 0) {
                return;
            }
            e.setUseBlock(Event.Result.DENY);
            world.func_184133_a(player, pos, SoundEvents.field_187635_cQ, SoundCategory.BLOCKS, 0.8f, 0.8f + world.field_73012_v.nextFloat() * 0.4f);
            player.func_184609_a(Hand.MAIN_HAND);
            if (!world.field_72995_K) {
                for (Lockable lkb3 : match) {
                    world.func_217376_c((Entity)new ItemEntity(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, lkb3.stack));
                    handler.remove(lkb3.id);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent e) {
        if (e.phase != TickEvent.Phase.START) {
            return;
        }
        ISelection select = (ISelection)e.player.getCapability(LocksCapabilities.SELECTION).orElse(null);
        if (select.get() == null) {
            return;
        }
        for (ItemStack stack : e.player.func_184214_aD()) {
            if (!stack.func_77973_b().func_206844_a(LocksItemTags.LOCKS)) continue;
            return;
        }
        select.set(null);
    }

    public static boolean canBreakLockable(PlayerEntity player, BlockPos pos) {
        return (Boolean)LocksServerConfig.PROTECT_LOCKABLES.get() == false || player.func_184812_l_() || !LocksUtil.locked(player.field_70170_p, pos);
    }

    @SubscribeEvent
    public static void onBlockBreaking(PlayerEvent.BreakSpeed e) {
        if (!LocksForgeEvents.canBreakLockable(e.getPlayer(), e.getPos())) {
            e.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent e) {
        if (!LocksForgeEvents.canBreakLockable(e.getPlayer(), e.getPos())) {
            e.setCanceled(true);
        }
    }
}

