/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import melonslise.locks.common.capability.ILockableHandler;
import melonslise.locks.common.capability.ISelection;
import melonslise.locks.common.config.LocksServerConfig;
import melonslise.locks.common.init.LocksCapabilities;
import melonslise.locks.common.init.LocksSoundEvents;
import melonslise.locks.common.item.LockingItem;
import melonslise.locks.common.util.Cuboid6i;
import melonslise.locks.common.util.Lock;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.Transform;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.state.properties.DoorHingeSide;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class LockItem
extends LockingItem {
    public final int length;
    public final int enchantmentValue;
    public final int resistance;
    public static final String KEY_OPEN = "Open";
    public static final String KEY_LENGTH = "Length";

    public LockItem(int length, int enchVal, int resist, Item.Properties props) {
        super(props);
        this.length = length;
        this.enchantmentValue = enchVal;
        this.resistance = resist;
    }

    public static boolean isOpen(ItemStack stack) {
        return stack.func_196082_o().func_74767_n(KEY_OPEN);
    }

    public static void setOpen(ItemStack stack, boolean open) {
        stack.func_196082_o().func_74757_a(KEY_OPEN, open);
    }

    public static byte getOrSetLength(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b(KEY_LENGTH)) {
            nbt.func_74774_a(KEY_LENGTH, (byte)((LockItem)stack.func_77973_b()).length);
        }
        return nbt.func_74771_c(KEY_LENGTH);
    }

    public static int getResistance(ItemStack stack) {
        return ((LockItem)stack.func_77973_b()).resistance;
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        BlockPos pos;
        World world = ctx.func_195991_k();
        if (!LocksServerConfig.canLock(world, pos = ctx.func_195995_a()) || ((ILockableHandler)ctx.func_195991_k().getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null)).getInChunk(pos).values().stream().anyMatch(lkb -> lkb.bb.intersects(pos))) {
            return ActionResultType.PASS;
        }
        return (Boolean)LocksServerConfig.EASY_LOCK.get() != false ? this.easyLock(ctx) : this.freeLock(ctx);
    }

    public ActionResultType freeLock(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        BlockPos pos = ctx.func_195995_a();
        ISelection select = (ISelection)player.getCapability(LocksCapabilities.SELECTION).orElse(null);
        BlockPos pos1 = select.get();
        if (pos1 == null) {
            select.set(pos);
        } else {
            World world = ctx.func_195991_k();
            select.set(null);
            world.func_184133_a(player, pos, (SoundEvent)LocksSoundEvents.LOCK_CLOSE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            ItemStack stack = ctx.func_195996_i();
            ItemStack lockStack = stack.func_77946_l();
            lockStack.func_190920_e(1);
            ILockableHandler handler = (ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
            if (!handler.add(new Lockable(new Cuboid6i(pos1, pos), Lock.from(stack), Transform.fromDirection(ctx.func_196000_l(), player.func_174811_aO().func_176734_d()), lockStack, world))) {
                return ActionResultType.PASS;
            }
            if (!player.func_184812_l_()) {
                stack.func_190918_g(1);
            }
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResultType easyLock(ItemUseContext ctx) {
        PlayerEntity player = ctx.func_195999_j();
        World world = ctx.func_195991_k();
        BlockPos pos = ctx.func_195995_a();
        world.func_184133_a(player, pos, (SoundEvent)LocksSoundEvents.LOCK_CLOSE.get(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        BlockState state = world.func_180495_p(pos);
        BlockPos pos1 = pos;
        if (state.func_235901_b_((Property)BlockStateProperties.field_208140_ao) && state.func_177229_b((Property)BlockStateProperties.field_208140_ao) != ChestType.SINGLE) {
            pos1 = pos.func_177972_a(ChestBlock.func_196311_i((BlockState)state));
        } else if (state.func_235901_b_((Property)BlockStateProperties.field_208163_P)) {
            BlockPos blockPos = pos1 = state.func_177229_b((Property)BlockStateProperties.field_208163_P) == DoubleBlockHalf.LOWER ? pos.func_177984_a() : pos.func_177977_b();
            if (state.func_235901_b_((Property)BlockStateProperties.field_208142_aq) && state.func_235901_b_((Property)BlockStateProperties.field_208157_J)) {
                Direction dir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J);
                BlockPos pos2 = pos1.func_177972_a(state.func_177229_b((Property)BlockStateProperties.field_208142_aq) == DoorHingeSide.LEFT ? dir.func_176746_e() : dir.func_176735_f());
                if (world.func_180495_p(pos2).func_203425_a(state.func_177230_c())) {
                    pos1 = pos2;
                }
            }
        }
        ItemStack stack = ctx.func_195996_i();
        ItemStack lockStack = stack.func_77946_l();
        lockStack.func_190920_e(1);
        ILockableHandler handler = (ILockableHandler)world.getCapability(LocksCapabilities.LOCKABLE_HANDLER).orElse(null);
        if (!handler.add(new Lockable(new Cuboid6i(pos, pos1), Lock.from(stack), Transform.fromDirection(ctx.func_196000_l(), player.func_174811_aO().func_176734_d()), lockStack, world))) {
            return ActionResultType.PASS;
        }
        if (!player.func_184812_l_()) {
            stack.func_190918_g(1);
        }
        return ActionResultType.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!LockItem.isOpen(stack)) {
            return super.func_77659_a(world, player, hand);
        }
        LockItem.setOpen(stack, false);
        world.func_184148_a(player, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)LocksSoundEvents.PIN_MATCH.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_77616_k(ItemStack p_77616_1_) {
        return true;
    }

    public int func_77619_b() {
        return this.enchantmentValue;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag flag) {
        super.func_77624_a(stack, world, lines, flag);
        lines.add((ITextComponent)new TranslationTextComponent("locks.tooltip.length", new Object[]{ItemStack.field_111284_a.format(stack.func_77942_o() && stack.func_77978_p().func_74764_b(KEY_LENGTH) ? (long)stack.func_77978_p().func_74771_c(KEY_LENGTH) : (long)this.length)}).func_240699_a_(TextFormatting.DARK_GREEN));
    }
}

