/*
 * Decompiled with CFR 0.152.
 */
package melonslise.locks.common.item;

import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import melonslise.locks.common.container.LockPickingContainer;
import melonslise.locks.common.init.LocksEnchantments;
import melonslise.locks.common.util.Lockable;
import melonslise.locks.common.util.LocksPredicates;
import melonslise.locks.common.util.LocksUtil;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class LockPickItem
extends Item {
    public static final ITextComponent TOO_COMPLEX_MESSAGE = new TranslationTextComponent("locks.status.too_complex");
    public final float strength;
    public static final String KEY_STRENGTH = "Strength";

    public LockPickItem(float strength, Item.Properties props) {
        super(props);
        this.strength = strength;
    }

    public static float getOrSetStrength(ItemStack stack) {
        CompoundNBT nbt = stack.func_196082_o();
        if (!nbt.func_74764_b(KEY_STRENGTH)) {
            nbt.func_74776_a(KEY_STRENGTH, ((LockPickItem)stack.func_77973_b()).strength);
        }
        return nbt.func_74760_g(KEY_STRENGTH);
    }

    public static boolean canPick(ItemStack stack, int cmp) {
        return LockPickItem.getOrSetStrength(stack) > (float)cmp * 0.25f;
    }

    public static boolean canPick(ItemStack stack, Lockable lkb) {
        return LockPickItem.canPick(stack, EnchantmentHelper.func_77506_a((Enchantment)((Enchantment)LocksEnchantments.COMPLEXITY.get()), (ItemStack)lkb.stack));
    }

    public ActionResultType func_195939_a(ItemUseContext ctx) {
        World world = ctx.func_195991_k();
        PlayerEntity player = ctx.func_195999_j();
        BlockPos pos = ctx.func_195995_a();
        List match = LocksUtil.intersecting(world, pos).filter(LocksPredicates.LOCKED).collect(Collectors.toList());
        if (match.isEmpty()) {
            return ActionResultType.PASS;
        }
        Lockable lkb = (Lockable)match.get(0);
        if (!LockPickItem.canPick(ctx.func_195996_i(), lkb)) {
            if (world.field_72995_K) {
                player.func_146105_b(TOO_COMPLEX_MESSAGE, true);
            }
            return ActionResultType.PASS;
        }
        if (world.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        Hand hand = ctx.func_221531_n();
        NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new LockPickingContainer.Provider(hand, lkb), (Consumer)new LockPickingContainer.Writer(hand, lkb));
        return ActionResultType.SUCCESS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> lines, ITooltipFlag flag) {
        super.func_77624_a(stack, world, lines, flag);
        lines.add((ITextComponent)new TranslationTextComponent("locks.tooltip.strength", new Object[]{ItemStack.field_111284_a.format(stack.func_77942_o() && stack.func_77978_p().func_74764_b(KEY_STRENGTH) ? (double)stack.func_77978_p().func_74760_g(KEY_STRENGTH) : (double)this.strength)}).func_240699_a_(TextFormatting.DARK_GREEN));
    }
}

