/*
 * Decompiled with CFR 0.152.
 */
package com.xray.gui.manage;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.xray.XRay;
import com.xray.gui.GuiSelectionScreen;
import com.xray.gui.manage.GuiAddBlock;
import com.xray.gui.utils.GuiBase;
import com.xray.gui.utils.ScrollingList;
import com.xray.store.GameBlockStore;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiBlockList
extends GuiBase {
    private ScrollingBlockList blockList;
    private ArrayList<GameBlockStore.BlockWithItemStack> blocks = XRay.gameBlockStore.getStore();
    private TextFieldWidget search;
    private String lastSearched = "";

    public GuiBlockList() {
        super(false);
    }

    public void func_231160_c_() {
        this.blockList = new ScrollingBlockList(this.getWidth() / 2 + 1, this.getHeight() / 2 - 12, 202, 185, this.blocks);
        this.field_230705_e_.add(this.blockList);
        this.search = new TextFieldWidget(this.getFontRender(), this.getWidth() / 2 - 100, this.getHeight() / 2 + 85, 140, 18, (ITextComponent)new StringTextComponent(""));
        this.search.func_231049_c__(true);
        this.func_231035_a_((IGuiEventListener)this.search);
        this.func_230480_a_((Widget)new Button(this.getWidth() / 2 + 43, this.getHeight() / 2 + 84, 60, 20, (ITextComponent)new TranslationTextComponent("xray.single.cancel"), b -> {
            this.func_231175_as__();
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiSelectionScreen());
        }));
    }

    public void func_231023_e_() {
        this.search.func_146178_a();
        if (!this.search.func_146179_b().equals(this.lastSearched)) {
            this.reloadBlocks();
        }
        super.func_231023_e_();
    }

    private void reloadBlocks() {
        if (this.lastSearched.equals(this.search.func_146179_b())) {
            return;
        }
        this.blockList.updateEntries(this.search.func_146179_b().length() == 0 ? this.blocks : this.blocks.stream().filter(e -> e.getItemStack().func_200301_q().getString().toLowerCase().contains(this.search.func_146179_b().toLowerCase())).collect(Collectors.toList()));
        this.lastSearched = this.search.func_146179_b();
        this.blockList.func_230932_a_(0.0);
    }

    @Override
    public void renderExtra(MatrixStack stack, int x, int y, float partialTicks) {
        this.search.func_230430_a_(stack, x, y, partialTicks);
        this.blockList.func_230430_a_(stack, x, y, partialTicks);
    }

    public boolean func_231044_a_(double x, double y, int button) {
        if (this.search.func_231044_a_(x, y, button)) {
            this.func_231035_a_((IGuiEventListener)this.search);
        }
        return super.func_231044_a_(x, y, button);
    }

    public boolean func_231043_a_(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double p_mouseScrolled_5_) {
        this.blockList.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
        return super.func_231043_a_(p_mouseScrolled_1_, p_mouseScrolled_3_, p_mouseScrolled_5_);
    }

    static class ScrollingBlockList
    extends ScrollingList<BlockSlot> {
        static final int SLOT_HEIGHT = 35;

        ScrollingBlockList(int x, int y, int width, int height, List<GameBlockStore.BlockWithItemStack> blocks) {
            super(x, y, width, height, 35);
            this.updateEntries(blocks);
        }

        public void setSelected(@Nullable BlockSlot entry) {
            if (entry == null) {
                return;
            }
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiAddBlock(entry.getBlock().getBlock(), GuiBlockList::new));
        }

        void updateEntries(List<GameBlockStore.BlockWithItemStack> blocks) {
            this.func_230963_j_();
            blocks.forEach(block -> this.func_230513_b_(new BlockSlot((GameBlockStore.BlockWithItemStack)block, this)));
        }

        public static class BlockSlot
        extends AbstractList.AbstractListEntry<BlockSlot> {
            GameBlockStore.BlockWithItemStack block;
            ScrollingBlockList parent;

            BlockSlot(GameBlockStore.BlockWithItemStack block, ScrollingBlockList parent) {
                this.block = block;
                this.parent = parent;
            }

            public GameBlockStore.BlockWithItemStack getBlock() {
                return this.block;
            }

            public void func_230432_a_(MatrixStack stack, int entryIdx, int top, int left, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean p_194999_5_, float partialTicks) {
                FontRenderer font = ((ScrollingBlockList)this.parent).field_230668_b_.field_71466_p;
                ResourceLocation resource = this.block.getItemStack().func_77973_b().getRegistryName();
                font.func_238421_b_(stack, this.block.getItemStack().func_77973_b().func_200296_o().getString(), (float)(left + 40), (float)(top + 7), Color.WHITE.getRGB());
                font.func_238421_b_(stack, resource != null ? resource.func_110624_b() : "", (float)(left + 40), (float)(top + 17), Color.WHITE.getRGB());
                RenderHelper.func_227780_a_();
                this.parent.field_230668_b_.func_175599_af().func_180450_b(this.block.getItemStack(), left + 15, top + 7);
                RenderHelper.func_74518_a();
            }

            public boolean func_231044_a_(double p_mouseClicked_1_, double p_mouseClicked_3_, int p_mouseClicked_5_) {
                this.parent.setSelected(this);
                return false;
            }
        }
    }
}

