/*
 * Decompiled with CFR 0.152.
 */
package com.xray.gui.utils;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.xray.gui.utils.SupportButton;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.LanguageMap;
import net.minecraft.util.text.StringTextComponent;

public abstract class GuiBase
extends Screen {
    public static final ResourceLocation BG_NORMAL = new ResourceLocation("xray:textures/gui/bg.png");
    public static final ResourceLocation BG_LARGE = new ResourceLocation("xray:textures/gui/bg-help.png");
    private boolean hasSide;
    private String sideTitle = "";
    private int backgroundWidth = 229;
    private int backgroundHeight = 235;

    public abstract void renderExtra(MatrixStack var1, int var2, int var3, float var4);

    public GuiBase(boolean hasSide) {
        super((ITextComponent)new StringTextComponent(""));
        this.hasSide = hasSide;
    }

    public boolean func_231042_a_(char keyTyped, int __unknown) {
        super.func_231042_a_(keyTyped, __unknown);
        if (keyTyped == '\u0001' && this.getMinecraft().field_71439_g != null) {
            this.getMinecraft().field_71439_g.func_71053_j();
        }
        return false;
    }

    public static void drawTexturedQuadFit(double x, double y, double width, double height, int[] color, float alpha) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder tessellate = tessellator.func_178180_c();
        RenderSystem.pushMatrix();
        tessellate.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        if (color != null) {
            RenderSystem.color4f((float)((float)color[0] / 255.0f), (float)((float)color[1] / 255.0f), (float)((float)color[2] / 255.0f), (float)(alpha / 255.0f));
        }
        tessellate.func_225582_a_(x + 0.0, y + height, 0.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        tessellate.func_225582_a_(x + width, y + height, 0.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        tessellate.func_225582_a_(x + width, y + 0.0, 0.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        tessellate.func_225582_a_(x + 0.0, y + 0.0, 0.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.popMatrix();
    }

    public static void drawTexturedQuadFit(double x, double y, double width, double height, int[] color) {
        GuiBase.drawTexturedQuadFit(x, y, width, height, color, 255.0f);
    }

    public static void drawTexturedQuadFit(double x, double y, double width, double height, int color) {
        GuiBase.drawTexturedQuadFit(x, y, width, height, new int[]{color >> 16 & 0xFF, color >> 8 & 0xFF, color & 0xFF}, 255.0f);
    }

    public void func_230430_a_(MatrixStack stack, int x, int y, float partialTicks) {
        this.func_230446_a_(stack);
        RenderSystem.pushMatrix();
        int width = this.field_230708_k_;
        int height = this.field_230709_l_;
        this.getMinecraft().func_110434_K().func_110577_a(this.getBackground());
        if (this.hasSide) {
            GuiBase.drawTexturedQuadFit((double)width / 2.0 + 60.0, (double)((float)height / 2.0f - 90.0f), 150.0, 180.0, 0xFFFFFF);
            GuiBase.drawTexturedQuadFit((double)((float)width / 2.0f - 150.0f), (double)((float)height / 2.0f - 118.0f), (double)this.backgroundWidth, (double)this.backgroundHeight, 0xFFFFFF);
            if (this.hasSideTitle()) {
                this.getFontRender().func_238405_a_(stack, this.sideTitle, (float)width / 2.0f + 80.0f, (float)height / 2.0f - 77.0f, 0xFFFF00);
            }
        }
        if (!this.hasSide) {
            GuiBase.drawTexturedQuadFit((double)((float)width / 2.0f - (float)this.backgroundWidth / 2.0f + 1.0f), (double)((float)height / 2.0f - (float)this.backgroundHeight / 2.0f), (double)this.backgroundWidth, (double)this.backgroundHeight, 0xFFFFFF);
        }
        RenderSystem.enableTexture();
        if (this.hasTitle()) {
            if (this.hasSide) {
                this.getFontRender().func_238405_a_(stack, this.title(), (float)width / 2.0f - 138.0f, (float)height / 2.0f - 105.0f, 0xFFFF00);
            } else {
                this.getFontRender().func_238405_a_(stack, this.title(), (float)width / 2.0f - (float)this.backgroundWidth / 2.0f + 14.0f, (float)height / 2.0f - (float)this.backgroundHeight / 2.0f + 13.0f, 0xFFFF00);
            }
        }
        RenderSystem.popMatrix();
        this.renderExtra(stack, x, y, partialTicks);
        List buttons = this.field_230710_m_;
        for (Widget button : buttons) {
            button.func_230430_a_(stack, x, y, partialTicks);
        }
        for (Widget button : buttons) {
            if (!(button instanceof SupportButton) || !button.func_230449_g_()) continue;
            this.func_238654_b_(stack, LanguageMap.func_74808_a().func_244260_a(((SupportButton)button).getSupport()), x, y);
        }
        super.func_230430_a_(stack, x, y, partialTicks);
    }

    public ResourceLocation getBackground() {
        return BG_NORMAL;
    }

    public boolean hasTitle() {
        return false;
    }

    public String title() {
        return "";
    }

    private boolean hasSideTitle() {
        return !this.sideTitle.isEmpty();
    }

    protected void setSideTitle(String title) {
        this.sideTitle = title;
    }

    public void setSize(int width, int height) {
        this.backgroundWidth = width;
        this.backgroundHeight = height;
    }

    public FontRenderer getFontRender() {
        return this.getMinecraft().field_71466_p;
    }

    public int getWidth() {
        return this.field_230708_k_;
    }

    public int getHeight() {
        return this.field_230709_l_;
    }

    public boolean func_231177_au__() {
        return false;
    }
}

