/*
 * Decompiled with CFR 0.152.
 */
package com.xray.store;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import com.xray.XRay;
import com.xray.utils.BlockData;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.Tags;
import org.apache.logging.log4j.Level;

public class JsonStore {
    private static final String FILE = "block_store.json";
    private static final String CONFIG_DIR = XRay.mc.field_71412_D + "/config/";
    private static final Random rand = new Random();
    private static final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public boolean created = false;
    private File jsonFile;

    public JsonStore() {
        File configDir = new File(CONFIG_DIR, "xray");
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        this.jsonFile = new File(CONFIG_DIR + "xray", FILE);
        if (!this.jsonFile.exists()) {
            this.created = true;
            this.write((List<BlockData.SerializableBlockData>)new ArrayList<BlockData.SerializableBlockData>());
        }
    }

    public void write(ArrayList<BlockData> blockData) {
        ArrayList<BlockData.SerializableBlockData> simpleBlockData = new ArrayList<BlockData.SerializableBlockData>();
        blockData.forEach(e -> simpleBlockData.add(new BlockData.SerializableBlockData(e.getEntryName(), e.getBlockName(), e.getColor(), e.isDrawing(), e.getOrder())));
        this.write((List<BlockData.SerializableBlockData>)simpleBlockData);
    }

    private void write(List<BlockData.SerializableBlockData> simpleBlockData) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.jsonFile));){
            gson.toJson(simpleBlockData, (Appendable)writer);
        }
        catch (IOException e) {
            XRay.logger.log(Level.ERROR, "Failed to write json data to block_store.json");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<BlockData.SerializableBlockData> read() {
        if (!this.jsonFile.exists()) {
            return new ArrayList<BlockData.SerializableBlockData>();
        }
        try {
            Type type = new TypeToken<List<BlockData.SerializableBlockData>>(){}.getType();
            try (BufferedReader reader = new BufferedReader(new FileReader(this.jsonFile));){
                List list = (List)gson.fromJson((Reader)reader, type);
                return list;
            }
            catch (JsonSyntaxException ex) {
                XRay.logger.log(Level.ERROR, "Failed to read json data from block_store.json");
                return new ArrayList<BlockData.SerializableBlockData>();
            }
        }
        catch (IOException e) {
            XRay.logger.log(Level.ERROR, "Failed to read json data from block_store.json");
        }
        return new ArrayList<BlockData.SerializableBlockData>();
    }

    public List<BlockData.SerializableBlockData> populateDefault() {
        ArrayList<BlockData.SerializableBlockData> oresData = new ArrayList<BlockData.SerializableBlockData>();
        Tags.Blocks.ORES.func_230236_b_().forEach(e -> {
            if (e.getRegistryName() == null) {
                return;
            }
            oresData.add(new BlockData.SerializableBlockData(new TranslationTextComponent(e.func_149739_a()).getString(), e.getRegistryName().toString(), (rand.nextInt(255) << 16) + (rand.nextInt(255) << 8) + rand.nextInt(255), false, 0));
        });
        for (int i = 0; i < oresData.size(); ++i) {
            ((BlockData.SerializableBlockData)oresData.get(i)).setOrder(i);
        }
        XRay.logger.info("Setting up default syncRenderList");
        this.write((List<BlockData.SerializableBlockData>)oresData);
        return oresData;
    }
}

