/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import com.mojang.math.Vector3f;
import java.util.EnumSet;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import untamedwilds.entity.ComplexMobAmphibious;
import untamedwilds.entity.ComplexMobTerrestrial;

public class GotoSleepGoal
extends Goal {
    private final ComplexMobTerrestrial creature;
    protected Vector3f target;
    private final int executionChance;
    private final double speed;
    private final boolean usesHome;

    public GotoSleepGoal(ComplexMobTerrestrial entityIn, double speedIn) {
        this(entityIn, speedIn, 200, true);
    }

    public GotoSleepGoal(ComplexMobTerrestrial entityIn, double speedIn, int chance) {
        this(entityIn, speedIn, chance, true);
    }

    public GotoSleepGoal(ComplexMobTerrestrial entityIn, double speedIn, int chance, boolean usesHome) {
        this.creature = entityIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.usesHome = usesHome;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        if (this.creature.m_21187_().nextInt(this.executionChance) != 0 || this.creature.m_5448_() != null) {
            return false;
        }
        if (this.creature.m_5803_() && this.creature.isActive() && this.creature.forceSleep <= 0 || !(this.creature instanceof ComplexMobAmphibious) && this.creature.m_20069_()) {
            this.creature.setSleeping(false);
            return false;
        }
        if (this.creature.getCommandInt() != 0 || this.creature.isActive() || !this.creature.canMove() || this.creature.m_20069_() && !(this.creature instanceof ComplexMobAmphibious)) {
            return false;
        }
        if (this.isValidShelter(this.creature.m_142538_()) || !this.usesHome) {
            this.creature.setHome(this.creature.m_142538_());
            this.creature.setSleeping(true);
            return false;
        }
        if (this.creature.getHome() == BlockPos.f_121853_ || !this.canEasilyReach(this.creature.getHome()) || this.creature.m_20238_(this.creature.getHomeAsVec()) > 100000.0) {
            this.creature.setHome(BlockPos.f_121853_);
            BlockPos pos = this.checkForNewHome();
            if (pos == null) {
                return false;
            }
            this.creature.setHome(pos);
        }
        this.target = new Vector3f(this.creature.getHomeAsVec());
        return true;
    }

    private boolean canEasilyReach(BlockPos target) {
        int j;
        Path path = this.creature.m_21573_().m_7864_(target, 0);
        if (path == null) {
            return false;
        }
        Node pathpoint = path.m_77395_();
        if (pathpoint == null) {
            return false;
        }
        int i = pathpoint.f_77271_ - Mth.m_14143_((float)target.m_123341_());
        return (double)(i * i + (j = pathpoint.f_77273_ - Mth.m_14143_((float)target.m_123343_())) * j) <= 2.25;
    }

    public void m_8056_() {
        this.creature.m_21573_().m_26519_((double)this.target.m_122239_(), (double)this.target.m_122260_(), (double)this.target.m_122269_(), this.speed);
    }

    public boolean m_8045_() {
        return !this.creature.m_21573_().m_26571_();
    }

    @Nullable
    public BlockPos checkForNewHome() {
        Random random = this.creature.m_21187_();
        BlockPos blockpos = this.creature.m_142538_();
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos1 = blockpos.m_142082_(random.nextInt(12) - 6, random.nextInt(4) - 2, random.nextInt(12) - 6);
            if (!this.isValidShelter(blockpos1) || !(this.creature.m_21692_(blockpos1) < 0.0f)) continue;
            return blockpos1;
        }
        return null;
    }

    private boolean isValidShelter(BlockPos blockPos) {
        return !this.creature.f_19853_.m_45527_(blockPos);
    }
}

