/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraftforge.event.ForgeEventFactory;
import untamedwilds.entity.ComplexMobTerrestrial;

public class RaidCropsGoal
extends Goal {
    private BlockPos targetPos;
    private final ComplexMobTerrestrial taskOwner;
    private boolean continueTask;

    public RaidCropsGoal(ComplexMobTerrestrial entityIn) {
        this.taskOwner = entityIn;
        this.continueTask = true;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.taskOwner.m_21824_() || !ForgeEventFactory.getMobGriefingEvent((Level)this.taskOwner.f_19853_, (Entity)this.taskOwner)) {
            return false;
        }
        if (this.taskOwner.getHunger() > 80 || this.taskOwner.m_5448_() != null) {
            return false;
        }
        if (this.taskOwner.m_21187_().nextInt(120) != 0) {
            return false;
        }
        BlockPos pos = this.taskOwner.m_142538_();
        this.targetPos = this.getNearbyFarmland(pos);
        return this.targetPos != null;
    }

    public void m_8056_() {
        this.taskOwner.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)(this.targetPos.m_123342_() + 1), (double)this.targetPos.m_123343_() + 0.5, 1.0);
    }

    public void m_8037_() {
        if (this.taskOwner.m_20275_(this.targetPos.m_123341_(), this.targetPos.m_123342_(), this.targetPos.m_123343_()) < 4.0) {
            BlockState block = this.taskOwner.f_19853_.m_8055_(this.targetPos);
            if (block.m_60734_() instanceof CropBlock) {
                LootContext.Builder loot = new LootContext.Builder((ServerLevel)this.taskOwner.f_19853_).m_78977_(this.taskOwner.m_21187_()).m_78963_(1.0f);
                List drops = block.m_60734_().m_7381_(block, loot);
                if (!drops.isEmpty()) {
                    this.taskOwner.addHunger(Math.max(drops.size() * 10, 10));
                    this.taskOwner.f_19853_.m_46961_(this.targetPos, false);
                    this.taskOwner.m_21573_().m_26573_();
                }
            }
            this.continueTask = false;
        }
    }

    public boolean m_8045_() {
        if (this.taskOwner.getHunger() > 80 || this.taskOwner.f_19853_.m_46859_(this.targetPos)) {
            return false;
        }
        return this.continueTask;
    }

    private BlockPos getNearbyFarmland(BlockPos roomCenter) {
        int X = 15;
        int Y = 3;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)roomCenter.m_142082_(-X, -Y, -X), (BlockPos)roomCenter.m_142082_(X, Y, X))) {
            if (!(this.taskOwner.f_19853_.m_8055_(blockpos).m_60734_() instanceof FarmBlock) || !this.hasPlantedCrop((LevelReader)this.taskOwner.f_19853_, blockpos)) continue;
            return blockpos.m_7494_();
        }
        return null;
    }

    private boolean hasPlantedCrop(LevelReader worldIn, BlockPos pos) {
        BlockState block = worldIn.m_8055_(pos.m_7494_());
        return block.m_60734_() instanceof CropBlock;
    }
}

