/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ISpecies;

public class DontThreadOnMeTarget<T extends LivingEntity>
extends TargetGoal {
    protected final Class<T> targetClass;
    protected final int targetChance;
    protected LivingEntity nearestTarget;
    protected Predicate<T> targetEntitySelector;

    public DontThreadOnMeTarget(Mob entityIn, Class<T> targetClassIn, boolean checkSight) {
        this(entityIn, targetClassIn, checkSight, false);
    }

    public DontThreadOnMeTarget(Mob entityIn, Class<T> targetClassIn, boolean checkSight, boolean nearbyOnlyIn) {
        this(entityIn, targetClassIn, 6, checkSight, nearbyOnlyIn);
    }

    public DontThreadOnMeTarget(Mob entityIn, Class<T> targetClassIn, int targetChanceIn, boolean checkSight, boolean nearbyOnlyIn) {
        super(entityIn, checkSight, nearbyOnlyIn);
        this.targetClass = targetClassIn;
        this.targetChance = targetChanceIn;
        this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
        this.targetEntitySelector = entity -> {
            if (entity instanceof Creeper) {
                return false;
            }
            if (this.f_26135_.getClass() == entity.getClass()) {
                if (this.f_26135_ instanceof ISpecies && entity instanceof ISpecies) {
                    ComplexMob attacker = (ComplexMob)this.f_26135_;
                    ComplexMob defender = (ComplexMob)((Object)entity);
                    if (attacker.getVariant() == defender.getVariant()) {
                        return false;
                    }
                }
                return false;
            }
            return TargetingConditions.m_148352_().m_26885_((LivingEntity)this.f_26135_, entity) && this.m_26150_((LivingEntity)entity, TargetingConditions.f_26872_);
        };
    }

    public boolean m_8036_() {
        if (!((Boolean)ConfigGamerules.contactAgression.get()).booleanValue() || this.f_26135_.m_21187_().nextInt(this.targetChance) != 0 || this.f_26135_.m_21573_().m_26571_()) {
            return false;
        }
        List list = this.f_26135_.f_19853_.m_6443_(this.targetClass, this.f_26135_.m_142469_(), this.targetEntitySelector);
        if (list.isEmpty()) {
            return false;
        }
        this.nearestTarget = (LivingEntity)list.get(0);
        return true;
    }

    public void m_8056_() {
        this.f_26135_.m_6710_(this.nearestTarget);
        super.m_8056_();
    }
}

