/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Creeper;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ai.target.HuntMobTarget;

public class HuntWeakerTarget<T extends LivingEntity>
extends HuntMobTarget<T> {
    private final int executionChance;

    public HuntWeakerTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public HuntWeakerTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 300, checkSight, onlyNearby, null);
    }

    public HuntWeakerTarget(ComplexMob creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, Predicate<LivingEntity> targetSelector) {
        super(creature, classTarget, checkSight, 200, false, targetSelector);
        this.executionChance = chance;
        this.targetEntitySelector = entity -> {
            if (targetSelector != null && !targetSelector.test((LivingEntity)entity)) {
                return false;
            }
            if (entity instanceof ComplexMob) {
                ComplexMob ctarget = (ComplexMob)((Object)entity);
                return this.f_26135_.getClass() == entity.getClass() && ((ComplexMob)this.f_26135_).getVariant() == ctarget.getVariant() || !ctarget.canBeTargeted();
            }
            return this.m_26150_((LivingEntity)entity, TargetingConditions.f_26872_);
        };
    }

    @Override
    public boolean m_8036_() {
        if (this.f_26135_.m_6162_() || this.f_26135_.m_21187_().nextInt(this.executionChance) != 0) {
            return false;
        }
        double perception = this.m_7623_();
        List list = this.f_26135_.f_19853_.m_6443_(this.targetClass, this.f_26135_.m_142469_().m_82377_(perception, 8.0, perception), this.targetEntitySelector);
        list.removeIf(this::shouldRemoveTarget);
        if (list.isEmpty()) {
            return false;
        }
        list.sort(this.sorter);
        this.targetEntity = (LivingEntity)list.get(0);
        return true;
    }

    @Override
    public boolean shouldRemoveTarget(LivingEntity entity) {
        if (entity instanceof Creeper || entity == this.f_26135_ || entity.m_20160_() || (double)(entity.m_21223_() / entity.m_21233_()) < 0.8) {
            return true;
        }
        if (entity instanceof ComplexMob) {
            ComplexMob ctarget = (ComplexMob)entity;
            return this.f_26135_.getClass() == entity.getClass() && ((ComplexMob)this.f_26135_).getVariant() == ctarget.getVariant() || !ctarget.canBeTargeted();
        }
        return false;
    }
}

