/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.target;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ai.target.HuntMobTarget;

public class ProtectChildrenTarget<T extends LivingEntity>
extends HuntMobTarget<T> {
    private final int executionChance;
    private Mob protectTarget;

    public ProtectChildrenTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight) {
        this(creature, classTarget, checkSight, false);
    }

    public ProtectChildrenTarget(ComplexMob creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null);
    }

    public ProtectChildrenTarget(ComplexMob creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, Predicate<? super LivingEntity> targetSelector) {
        super(creature, classTarget, checkSight, 200, false, null);
        this.executionChance = chance;
        this.targetEntitySelector = entity -> {
            if (targetSelector != null && !targetSelector.test((LivingEntity)entity)) {
                return false;
            }
            if (ComplexMob.getEcoLevel(entity) < ComplexMob.getEcoLevel((LivingEntity)this.f_26135_)) {
                return false;
            }
            return this.m_26150_((LivingEntity)entity, TargetingConditions.f_26872_);
        };
    }

    @Override
    public boolean m_8036_() {
        if (this.f_26135_.m_6162_()) {
            return false;
        }
        if (this.f_26135_ instanceof ComplexMob) {
            ComplexMob temp = (ComplexMob)this.f_26135_;
            if (temp.m_21824_()) {
                return false;
            }
            for (Mob child : this.f_26135_.f_19853_.m_45976_(this.f_26135_.getClass(), this.f_26135_.m_142469_().m_82377_(8.0, 4.0, 8.0))) {
                if (!child.m_6162_() || ((ComplexMob)child).getVariant() != temp.getVariant()) continue;
                this.protectTarget = child;
                List list = this.f_26135_.f_19853_.m_6443_(this.targetClass, this.getTargetableArea(this.m_7623_()), this.targetEntitySelector);
                list.removeIf(this::shouldRemoveTarget);
                if (list.isEmpty()) {
                    return false;
                }
                list.sort(this.sorter);
                this.targetEntity = (LivingEntity)list.get(0);
                return true;
            }
        }
        return false;
    }

    public boolean m_8045_() {
        if (this.protectTarget.m_20270_((Entity)this.f_26135_) > 12.0f) {
            this.f_26135_.m_6710_(null);
            this.f_26137_ = null;
            this.f_26135_.m_21573_().m_5624_((Entity)this.protectTarget, 1.0);
            return false;
        }
        return super.m_8045_();
    }

    protected double m_7623_() {
        return super.m_7623_() * 0.5;
    }
}

