/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.ai.unique;

import com.mojang.datafixers.util.Pair;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.entity.mammal.EntityBear;

public class BearRaidChestsGoal
extends Goal {
    private Container targetInventory;
    private BlockPos targetPos;
    private final EntityBear taskOwner;
    private final int executionChance;
    private int searchCooldown;
    private boolean continueTask;

    public BearRaidChestsGoal(EntityBear entityIn, int chance) {
        this.taskOwner = entityIn;
        this.executionChance = chance;
        this.searchCooldown = 100;
        this.continueTask = true;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (this.taskOwner.m_21824_() || !this.taskOwner.m_20096_() || this.taskOwner.getHunger() > 60 || this.taskOwner.m_21187_().nextInt(this.executionChance) != 0 || this.taskOwner.m_5448_() != null) {
            return false;
        }
        BlockPos pos = this.taskOwner.m_142538_();
        this.targetPos = this.getNearbyInventories(pos);
        return this.targetPos != null;
    }

    public void m_8056_() {
        this.taskOwner.m_21573_().m_26519_((double)this.targetPos.m_123341_() + 0.5, (double)(this.targetPos.m_123342_() + 1), (double)this.targetPos.m_123343_() + 0.5, 1.0);
        super.m_8056_();
    }

    public void m_8041_() {
    }

    public void m_8037_() {
        if (this.targetPos != null && this.taskOwner.m_20275_(this.targetPos.m_123341_(), this.targetPos.m_123342_(), this.targetPos.m_123343_()) < 4.0) {
            this.taskOwner.m_21563_().m_24950_((double)this.targetPos.m_123341_(), (double)((float)this.targetPos.m_123342_() + 1.5f), (double)this.targetPos.m_123343_(), 10.0f, (float)this.taskOwner.m_8132_());
            this.taskOwner.m_21573_().m_26573_();
            this.taskOwner.setSitting(true);
            --this.searchCooldown;
            if (this.taskOwner.f_19853_.m_7702_(this.targetPos) instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)this.taskOwner.f_19853_.m_7702_(this.targetPos);
                this.taskOwner.f_19853_.m_7696_(this.targetPos, chest.m_58900_().m_60734_(), 1, 1);
            }
            if (this.searchCooldown == 0) {
                this.searchCooldown = 100;
                this.continueTask = this.stealItem();
            }
        }
        super.m_8037_();
    }

    public boolean m_8045_() {
        if (this.taskOwner.getHunger() >= 60 || this.targetInventory.m_7983_()) {
            this.taskOwner.setSitting(false);
            if (this.taskOwner.f_19853_.m_7702_(this.targetPos) instanceof ChestBlockEntity) {
                ChestBlockEntity chest = (ChestBlockEntity)this.taskOwner.f_19853_.m_7702_(this.targetPos);
                this.taskOwner.f_19853_.m_7696_(this.targetPos, chest.m_58900_().m_60734_(), 1, 0);
            }
            return false;
        }
        return this.continueTask;
    }

    private boolean stealItem() {
        block16: {
            if (this.targetInventory == null) break block16;
            Direction enumfacing = Direction.DOWN;
            if (BearRaidChestsGoal.isInventoryEmpty(this.targetInventory, enumfacing)) {
                return false;
            }
            if (this.targetInventory instanceof WorldlyContainer) {
                int[] aint;
                WorldlyContainer isidedinventory = (WorldlyContainer)this.targetInventory;
                for (int i : aint = isidedinventory.m_7071_(enumfacing)) {
                    ItemStack itemstack = this.targetInventory.m_8020_(i);
                    if (itemstack.m_41619_() || !BearRaidChestsGoal.canExtractItemFromSlot(this.targetInventory, itemstack, i, enumfacing)) continue;
                    ItemStack itemstack1 = itemstack.m_41777_();
                    this.targetInventory.m_6836_(i, ItemStack.f_41583_);
                    if (itemstack1.m_41720_().m_41472_()) {
                        this.taskOwner.m_5496_(SoundEvents.f_12321_, 1.0f, 1.0f);
                        this.taskOwner.addHunger(itemstack1.m_41720_().m_41473_().m_38744_() * 10 * itemstack1.m_41613_());
                        for (Pair pair : itemstack1.m_41720_().m_41473_().m_38749_()) {
                            if (pair.getFirst() == null || !(this.taskOwner.f_19853_.f_46441_.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                            this.taskOwner.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                        }
                        return false;
                    }
                    if (!PotionUtils.m_43547_((ItemStack)itemstack1).isEmpty()) {
                        this.taskOwner.m_5496_(SoundEvents.f_12321_, 1.0f, 1.0f);
                        this.taskOwner.addHunger(10);
                        for (MobEffectInstance effectinstance : PotionUtils.m_43547_((ItemStack)itemstack1)) {
                            if (effectinstance.m_19544_().m_8093_()) {
                                effectinstance.m_19544_().m_19461_((Entity)this.taskOwner, (Entity)this.taskOwner, (LivingEntity)this.taskOwner, effectinstance.m_19564_(), 1.0);
                                continue;
                            }
                            this.taskOwner.m_7292_(new MobEffectInstance(effectinstance));
                        }
                        return false;
                    }
                    this.taskOwner.m_5552_(itemstack, 0.2f);
                    return true;
                }
            } else {
                int j = this.targetInventory.m_6643_();
                for (int k = 0; k < j; ++k) {
                    ItemStack itemstack = this.targetInventory.m_8020_(k);
                    if (itemstack.m_41619_() || !BearRaidChestsGoal.canExtractItemFromSlot(this.targetInventory, itemstack, k, enumfacing)) continue;
                    ItemStack itemstack1 = itemstack.m_41777_();
                    this.targetInventory.m_6836_(k, ItemStack.f_41583_);
                    this.taskOwner.setAnimation(EntityBear.ATTACK_SWIPE);
                    if (itemstack1.m_41720_().m_41472_()) {
                        this.taskOwner.m_5496_(SoundEvents.f_12321_, 1.0f, 1.0f);
                        this.taskOwner.addHunger(itemstack1.m_41720_().m_41473_().m_38744_() * 10 * itemstack1.m_41613_());
                        for (Pair pair : itemstack1.m_41720_().m_41473_().m_38749_()) {
                            if (pair.getFirst() == null || !(this.taskOwner.f_19853_.f_46441_.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                            this.taskOwner.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                        }
                        return false;
                    }
                    if (!PotionUtils.m_43547_((ItemStack)itemstack1).isEmpty()) {
                        this.taskOwner.m_5496_(SoundEvents.f_11911_, 1.0f, 1.0f);
                        this.taskOwner.addHunger(10);
                        for (MobEffectInstance effectinstance : PotionUtils.m_43547_((ItemStack)itemstack1)) {
                            if (effectinstance.m_19544_().m_8093_()) {
                                effectinstance.m_19544_().m_19461_((Entity)this.taskOwner, (Entity)this.taskOwner, (LivingEntity)this.taskOwner, effectinstance.m_19564_(), 1.0);
                                continue;
                            }
                            this.taskOwner.m_7292_(new MobEffectInstance(effectinstance));
                        }
                        return false;
                    }
                    if (itemstack1.m_41720_().m_41472_() && PotionUtils.m_43547_((ItemStack)itemstack).isEmpty()) {
                        this.taskOwner.m_5496_(SoundEvents.f_12321_, 1.0f, 1.0f);
                        return false;
                    }
                    this.taskOwner.m_5552_(itemstack, 0.2f);
                    return true;
                }
            }
        }
        return false;
    }

    private static Container getInventoryAtPosition(Level worldIn, BlockPos pos) {
        BlockEntity tileentity;
        Container iinventory = null;
        BlockState state = worldIn.m_8055_(pos);
        if (worldIn.m_7702_(pos) != null && (tileentity = worldIn.m_7702_(pos)) instanceof Container) {
            iinventory = (Container)tileentity;
        }
        return iinventory;
    }

    private static boolean isInventoryEmpty(Container inventoryIn, Direction side) {
        if (inventoryIn instanceof WorldlyContainer) {
            int[] aint;
            WorldlyContainer isidedinventory = (WorldlyContainer)inventoryIn;
            for (int i : aint = isidedinventory.m_7071_(side)) {
                if (isidedinventory.m_8020_(i).m_41619_()) continue;
                return false;
            }
        } else {
            int j = inventoryIn.m_6643_();
            for (int k = 0; k < j; ++k) {
                if (inventoryIn.m_8020_(k).m_41619_()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean canExtractItemFromSlot(Container inventoryIn, ItemStack stack, int index, Direction side) {
        return !(inventoryIn instanceof WorldlyContainer) || ((WorldlyContainer)inventoryIn).m_7157_(index, stack, side);
    }

    private BlockPos getNearbyInventories(BlockPos roomCenter) {
        int X = 15;
        int Y = 3;
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)roomCenter.m_142082_(-X, -Y, -X), (BlockPos)roomCenter.m_142082_(X, Y, X))) {
            if (this.taskOwner.f_19853_.m_7702_(blockpos) == null || BearRaidChestsGoal.getInventoryAtPosition(this.taskOwner.f_19853_, blockpos) == null || BearRaidChestsGoal.isInventoryEmpty(BearRaidChestsGoal.getInventoryAtPosition(this.taskOwner.f_19853_, blockpos), Direction.UP)) continue;
            this.targetInventory = BearRaidChestsGoal.getInventoryAtPosition(this.taskOwner.f_19853_, blockpos);
            return blockpos;
        }
        return null;
    }
}

