/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.entity.reptile;

import com.github.alexthe666.citadel.animation.Animation;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.INewSkins;
import untamedwilds.entity.ISpecies;
import untamedwilds.entity.ai.SmartAvoidGoal;
import untamedwilds.entity.ai.SmartMateGoal;
import untamedwilds.entity.ai.SmartSwimGoal_Land;
import untamedwilds.entity.ai.SmartWanderGoal;
import untamedwilds.entity.ai.target.DontThreadOnMeTarget;
import untamedwilds.entity.ai.target.HuntMobTarget;
import untamedwilds.init.ModItems;
import untamedwilds.util.EntityUtils;

public class EntitySnake
extends ComplexMobTerrestrial
implements ISpecies,
INewSkins,
INeedsPostUpdate {
    private static final EntityDataAccessor<Boolean> RATTLER = SynchedEntityData.m_135353_(EntitySnake.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public static Animation ANIMATION_TONGUE;
    public float offset;

    public EntitySnake(EntityType<? extends ComplexMobTerrestrial> type, Level worldIn) {
        super(type, worldIn);
        this.f_19804_.m_135372_(RATTLER, (Object)false);
        ANIMATION_TONGUE = Animation.create((int)10);
        this.ticksToSit = 20;
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return LivingEntity.m_21183_().m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22279_, 0.33).m_22268_(Attributes.f_22277_, 12.0).m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22284_, 0.0);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SmartSwimGoal_Land(this));
        this.f_21345_.m_25352_(2, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.3, false));
        this.f_21345_.m_25352_(2, (Goal)new SmartMateGoal(this, 1.0));
        this.f_21345_.m_25352_(2, new SmartAvoidGoal<LivingEntity>(this, LivingEntity.class, 16.0f, 1.2, 1.6, input -> EntitySnake.getEcoLevel(input) > EntitySnake.getEcoLevel((LivingEntity)this)));
        this.f_21345_.m_25352_(3, (Goal)new SmartWanderGoal(this, 1.0, true));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, new HuntMobTarget<LivingEntity>(this, LivingEntity.class, true, 30, false, input -> EntitySnake.getEcoLevel(input) < EntitySnake.getEcoLevel((LivingEntity)this)));
        this.f_21346_.m_25352_(3, new DontThreadOnMeTarget<LivingEntity>((Mob)this, LivingEntity.class, true));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            if (this.f_19797_ % 1000 == 0) {
                if (this.wantsToBreed() && !this.isMale()) {
                    this.breed();
                }
                if (this.f_19796_.nextInt(40) == 0) {
                    this.m_5552_(new ItemStack((ItemLike)ModItems.MATERIAL_SNAKE_SKIN.get()), 0.2f);
                }
            }
            if (this.f_19853_.m_46467_() % 4000L == 0L) {
                this.m_5634_(1.0f);
            }
            if (this.f_19797_ % 120 == 0) {
                this.setAnimation(ANIMATION_TONGUE);
            }
            if (this.getAnimation() == NO_ANIMATION && this.m_5448_() == null && !this.m_5803_()) {
                int i = this.f_19796_.nextInt(3000);
                if (i <= 10 && !this.m_20069_() && this.isNotMoving() && this.canMove()) {
                    this.m_21573_().m_26573_();
                    this.setSitting(true);
                }
                if ((i == 11 || this.m_20069_() || this.isActive()) && this.isSitting()) {
                    this.setSitting(false);
                }
            }
            this.setAngry(this.m_5448_() != null);
        } else if ((double)Math.abs(this.m_146908_() - this.f_19859_) > 0.005) {
            this.offset = Mth.m_14189_((float)0.05f, (float)this.offset, (float)(this.m_146908_() - this.f_19859_));
        }
    }

    @Override
    public boolean wantsToBreed() {
        if (super.wantsToBreed() && !this.m_5803_() && this.m_146764_() == 0 && EntityUtils.hasFullHealth((LivingEntity)this)) {
            List list = this.f_19853_.m_45976_(EntitySnake.class, this.m_142469_().m_82377_(6.0, 4.0, 6.0));
            list.removeIf(input -> EntityUtils.isInvalidPartner(this, input, false));
            if (list.size() >= 1) {
                this.m_146762_(this.getPregnancyTime());
                ((EntitySnake)list.get(0)).m_146762_(this.getPregnancyTime());
                return true;
            }
        }
        return false;
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
    }

    @Override
    protected SoundEvent m_7515_() {
        if (this.isAngry()) {
            super.m_7515_();
        }
        return null;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverWorld, AgeableMob ageableEntity) {
        EntityUtils.dropEggs(this, "egg_snake", this.getOffspring());
        return null;
    }

    @Override
    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(InteractionHand.MAIN_HAND);
        if (itemstack.m_41619_() && this.m_6084_()) {
            EntityUtils.turnEntityIntoItem((LivingEntity)this, "spawn_snake");
            return InteractionResult.m_19078_((boolean)this.f_19853_.f_46443_);
        }
        return super.m_6071_(player, hand);
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_TONGUE};
    }

    public boolean m_7327_(Entity entityIn) {
        float f = (float)this.m_21051_(Attributes.f_22281_).m_22135_();
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), f);
        if (flag && this.getVenomStrength() > 0) {
            if (entityIn instanceof LivingEntity) {
                ((LivingEntity)entityIn).m_7292_(new MobEffectInstance(MobEffects.f_19614_, 140, this.getVenomStrength() - 1));
            }
            return true;
        }
        return flag;
    }

    public Integer getVenomStrength() {
        return EntitySnake.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "venom");
    }

    @Override
    public void updateAttributes() {
        this.setRattler(EntitySnake.getEntityData(this.m_6095_()).getFlags(this.getVariant(), "rattler") == 1);
    }

    public boolean isRattler() {
        return (Boolean)this.f_19804_.m_135370_(RATTLER);
    }

    private void setRattler(boolean dimorphism) {
        this.f_19804_.m_135381_(RATTLER, (Object)dimorphism);
    }

    @Override
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("rattler", this.isRattler());
    }

    @Override
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setRattler(compound.m_128471_("rattler"));
    }
}

