/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.util;

import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import untamedwilds.UntamedWilds;
import untamedwilds.entity.ComplexMob;
import untamedwilds.init.ModEntity;
import untamedwilds.network.SyncTextureData;
import untamedwilds.network.UntamedInstance;
import untamedwilds.util.EntityDataHolder;
import untamedwilds.util.JSONLoader;
import untamedwilds.util.SpeciesDataHolder;

@Mod.EventBusSubscriber(modid="untamedwilds")
public class EntityDataListenerEvent {
    public static final JSONLoader<EntityDataHolder> ENTITY_DATA_HOLDERS = new JSONLoader<EntityDataHolder>("entities", EntityDataHolder.CODEC);
    public static EntityDataHolder TARANTULA;
    public static EntityDataHolder GIANT_CLAM;
    public static EntityDataHolder GIANT_SALAMANDER;
    public static EntityDataHolder NEWT;
    public static EntityDataHolder AROWANA;
    public static EntityDataHolder FOOTBALL_FISH;
    public static EntityDataHolder SHARK;
    public static EntityDataHolder SUNFISH;
    public static EntityDataHolder WHALE_SHARK;
    public static EntityDataHolder TREVALLY;
    public static EntityDataHolder TRIGGERFISH;
    public static EntityDataHolder CATFISH;
    public static EntityDataHolder SNAKE;
    public static EntityDataHolder ANACONDA;
    public static EntityDataHolder SOFTSHELL_TURTLE;
    public static EntityDataHolder TORTOISE;
    public static EntityDataHolder AARDVARK;
    public static EntityDataHolder HIPPO;
    public static EntityDataHolder RHINO;
    public static EntityDataHolder HYENA;
    public static EntityDataHolder BOAR;
    public static EntityDataHolder BEAR;
    public static EntityDataHolder BIG_CAT;
    public static EntityDataHolder BISON;
    public static EntityDataHolder CAMEL;
    public static EntityDataHolder MANATEE;

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener(ENTITY_DATA_HOLDERS);
        EntityDataListenerEvent.registerData();
    }

    private static void registerData() {
        TARANTULA = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.TARANTULA.get());
        GIANT_CLAM = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.GIANT_CLAM.get());
        GIANT_SALAMANDER = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.GIANT_SALAMANDER.get());
        NEWT = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.NEWT.get());
        AROWANA = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.AROWANA.get());
        FOOTBALL_FISH = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.FOOTBALL_FISH.get());
        SHARK = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SHARK.get());
        SUNFISH = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SUNFISH.get());
        TREVALLY = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.TREVALLY.get());
        WHALE_SHARK = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.WHALE_SHARK.get());
        TRIGGERFISH = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.TRIGGERFISH.get());
        CATFISH = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.CATFISH.get());
        SNAKE = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SNAKE.get());
        ANACONDA = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.ANACONDA.get());
        SOFTSHELL_TURTLE = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.SOFTSHELL_TURTLE.get());
        TORTOISE = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.TORTOISE.get());
        BEAR = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.BEAR.get());
        BIG_CAT = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.BIG_CAT.get());
        AARDVARK = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.AARDVARK.get());
        BOAR = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.BOAR.get());
        RHINO = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.RHINO.get());
        HYENA = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.HYENA.get());
        HIPPO = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.HIPPO.get());
        BISON = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.BISON.get());
        CAMEL = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.CAMEL.get());
        MANATEE = EntityDataListenerEvent.registerEntityData((EntityType)ModEntity.MANATEE.get());
    }

    @SubscribeEvent
    public static void onPlayerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        UntamedWilds.LOGGER.info("Firing player login event");
        EntityDataListenerEvent.registerData();
        for (EntityType<?> types : ComplexMob.ENTITY_DATA_HASH.keySet()) {
            ResourceLocation entityName = types.getRegistryName();
            int size = 0;
            for (SpeciesDataHolder speciesData : ComplexMob.ENTITY_DATA_HASH.get(types).getSpeciesData()) {
                UntamedInstance.sendToClient(new SyncTextureData(entityName, speciesData.getName(), speciesData.getSkins(), size++), (ServerPlayer)event.getPlayer());
            }
        }
    }

    public static EntityDataHolder registerEntityData(EntityType<?> typeIn) {
        String nameIn = Objects.requireNonNull(typeIn.getRegistryName()).m_135815_();
        if (ENTITY_DATA_HOLDERS.getData(new ResourceLocation("untamedwilds", nameIn)) != null) {
            EntityDataHolder data = ENTITY_DATA_HOLDERS.getData(new ResourceLocation("untamedwilds", nameIn));
            ComplexMob.processData(data, typeIn);
            return data;
        }
        return null;
    }
}

