/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import net.minecraftforge.registries.ForgeRegistries;
import untamedwilds.UntamedWilds;
import untamedwilds.config.ConfigGamerules;
import untamedwilds.entity.ComplexMob;
import untamedwilds.entity.ComplexMobTerrestrial;
import untamedwilds.entity.INeedsPostUpdate;
import untamedwilds.entity.ISpecies;
import untamedwilds.util.EntityDataHolder;

public abstract class EntityUtils {
    public static void destroyBoat(Level worldIn, LivingEntity entityIn) {
        Entity entity;
        if (entityIn.m_20202_() != null && (entity = entityIn.m_20202_()) instanceof Boat) {
            Boat boat = (Boat)entity;
            boat.m_142687_(Entity.RemovalReason.KILLED);
            if (worldIn.m_46469_().m_46207_(GameRules.f_46135_)) {
                for (int j = 0; j < 3; ++j) {
                    boat.m_19998_((ItemLike)boat.m_38387_().m_38434_());
                }
                for (int k = 0; k < 2; ++k) {
                    boat.m_19998_((ItemLike)Items.f_42398_);
                }
            }
        }
    }

    public static <T extends ParticleOptions> void spawnParticlesOnEntity(Level worldIn, LivingEntity entityIn, T particle, int count, int iter) {
        if (worldIn.f_46443_) {
            return;
        }
        if (entityIn.isMultipartEntity()) {
            for (PartEntity part : entityIn.getParts()) {
                for (int i = 0; i < iter; ++i) {
                    ((ServerLevel)worldIn).m_8767_(particle, part.m_20185_(), part.m_20186_() + (double)part.m_20206_() / 1.5, part.m_20189_(), count, (double)(part.m_20205_() / 4.0f), (double)(part.m_20206_() / 4.0f), (double)(part.m_20205_() / 4.0f), 0.05);
                }
            }
        } else {
            for (int i = 0; i < iter; ++i) {
                ((ServerLevel)worldIn).m_8767_(particle, entityIn.m_20185_(), entityIn.m_20186_() + (double)entityIn.m_20206_() / 1.5, entityIn.m_20189_(), count, (double)(entityIn.m_20205_() / 4.0f), (double)(entityIn.m_20206_() / 4.0f), (double)(entityIn.m_20205_() / 4.0f), 0.05);
            }
        }
    }

    public static int getPackSize(EntityType<?> type, int variant) {
        return ComplexMob.getEntityData(type).getGroupCount(variant);
    }

    public static EntityType<?> getEntityTypeFromTag(CompoundTag nbt, @Nullable EntityType<?> alt) {
        CompoundTag entityNBT;
        if (nbt != null && nbt.m_128425_("EntityTag", 10) && (entityNBT = nbt.m_128469_("EntityTag")).m_128425_("id", 8)) {
            return EntityType.m_20632_((String)entityNBT.m_128461_("id")).orElse(alt);
        }
        return alt;
    }

    public static void buildTooltipData(ItemStack stack, List<Component> tooltip, EntityType<?> entity, String path) {
        if (stack.m_41783_() != null && stack.m_41783_().m_128441_("EntityTag")) {
            CompoundTag compound = stack.m_41737_("EntityTag");
            String gender = compound.m_128441_("Gender") ? new TranslatableComponent("mobspawn.tooltip." + (compound.m_128451_("Gender") == 0 ? "male" : "female")).getString() + " " : "";
            String type = path.isEmpty() ? new TranslatableComponent(entity.m_20675_()).getString() : new TranslatableComponent(entity.m_20675_() + "_" + path).getString();
            if (stack.m_41783_().m_128469_("EntityTag").m_128441_("CustomName")) {
                String customName = stack.m_41783_().m_128469_("EntityTag").m_128461_("CustomName");
                tooltip.add((Component)new TextComponent(customName.substring(9, customName.length() - 2) + " (" + gender + type + ")").m_130940_(ChatFormatting.GRAY));
            } else {
                tooltip.add((Component)new TextComponent(gender + type).m_130940_(ChatFormatting.GRAY));
            }
        }
        if (((Boolean)ConfigGamerules.scientificNames.get()).booleanValue()) {
            Object scipath = path.isEmpty() ? "" : "_" + path;
            TranslatableComponent tooltipText = new TranslatableComponent(entity.m_20675_() + (String)scipath + ".sciname");
            if (!tooltipText.getString().contains(".")) {
                tooltip.add((Component)tooltipText.m_130944_(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.GRAY}));
            }
        }
    }

    public static void createMobFromItem(ServerLevel worldIn, ItemStack itemstack, EntityType<?> entity, @Nullable Integer species, BlockPos spawnPos, @Nullable Player player, boolean offset) {
        EntityUtils.createMobFromItem(worldIn, itemstack, entity, species, spawnPos, player, offset, false);
    }

    public static void createMobFromItem(ServerLevel worldIn, ItemStack itemstack, EntityType<?> entity, @Nullable Integer species, BlockPos spawnPos, @Nullable Player player, boolean offset, boolean skipNBTCheck) {
        if (itemstack.m_41783_() != null) {
            if (itemstack.m_41783_().m_128441_("EntityTag") && !skipNBTCheck) {
                Entity spawn;
                if (itemstack.m_41737_("EntityTag").m_128441_("UUID") && worldIn.m_8791_(itemstack.m_41737_("EntityTag").m_128342_("UUID")) != null) {
                    itemstack.m_41737_("EntityTag").m_128362_("UUID", Mth.m_14062_((Random)worldIn.f_46441_));
                }
                if ((spawn = entity.m_20592_(worldIn, itemstack, player, spawnPos, MobSpawnType.BUCKET, true, offset)) != null && itemstack.m_41788_()) {
                    spawn.m_6593_(itemstack.m_41786_());
                }
            } else {
                Entity spawn = entity.m_20655_(worldIn, null, null, player, spawnPos, MobSpawnType.SPAWN_EGG, true, offset);
                if (spawn instanceof ComplexMob) {
                    ComplexMob entitySpawn = (ComplexMob)spawn;
                    int true_species = species != null ? species.intValue() : entitySpawn.m_21187_().nextInt(ComplexMob.getEntityData(entitySpawn.m_6095_()).getSpeciesData().size());
                    entitySpawn.setVariant(true_species);
                    entitySpawn.chooseSkinForSpecies(entitySpawn, true);
                    entitySpawn.setRandomMobSize();
                    entitySpawn.setGender(entitySpawn.m_21187_().nextInt(2));
                    if (spawn instanceof INeedsPostUpdate) {
                        ((INeedsPostUpdate)spawn).updateAttributes();
                    }
                }
                if (spawn != null) {
                    if (itemstack.m_41788_()) {
                        spawn.m_6593_(itemstack.m_41786_());
                    }
                    worldIn.m_47205_(spawn);
                }
            }
        }
    }

    public static void dropEggs(ComplexMob entity, String item_name, int number) {
        if (((Boolean)ConfigGamerules.mobsLayEggs.get()).booleanValue()) {
            CompoundTag baseTag = new CompoundTag();
            ItemStack item = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("untamedwilds:" + item_name.toLowerCase())));
            baseTag.m_128405_("variant", entity.getVariant());
            baseTag.m_128405_("custom_model_data", entity.getVariant());
            item.m_41751_(baseTag);
            ItemEntity entityitem = entity.m_5552_(item, 0.2f);
            if (entityitem != null) {
                entityitem.m_32055_().m_41764_(1 + entity.m_21187_().nextInt(number - 1));
            }
        }
    }

    public static void turnEntityIntoItem(LivingEntity entity, String item_name) {
        if (((Boolean)ConfigGamerules.easyMobCapturing.get()).booleanValue() || ((Mob)entity).m_5448_() == null) {
            ItemEntity entityitem = entity.m_5552_(new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("untamedwilds:" + item_name.toLowerCase()))), 0.2f);
            Random rand = entity.m_21187_();
            if (entityitem != null) {
                entityitem.m_20334_((double)((rand.nextFloat() - rand.nextFloat()) * 0.1f), (double)(rand.nextFloat() * 0.05f), (double)((rand.nextFloat() - rand.nextFloat()) * 0.1f));
                entityitem.m_32055_().m_41751_(EntityUtils.writeEntityToNBT(entity, false, true));
                if (entity.m_8077_()) {
                    entityitem.m_32055_().m_41714_(entity.m_7770_());
                }
                entity.m_146870_();
            }
        }
    }

    public static void mutateEntityIntoItem(LivingEntity entity, Player player, InteractionHand hand, String item_name, ItemStack itemstack) {
        if (((Boolean)ConfigGamerules.easyMobCapturing.get()).booleanValue() || ((Mob)entity).m_5448_() == null) {
            entity.m_5496_(SoundEvents.f_11782_, 1.0f, 1.0f);
            itemstack.m_41774_(1);
            ItemStack newitem = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation("untamedwilds:" + item_name.toLowerCase())));
            newitem.m_41751_(EntityUtils.writeEntityToNBT(entity, false, true));
            if (entity.m_8077_()) {
                newitem.m_41714_(entity.m_7770_());
            }
            if (!entity.m_183503_().f_46443_) {
                CriteriaTriggers.f_10576_.m_38772_((ServerPlayer)player, newitem);
            }
            if (itemstack.m_41619_()) {
                player.m_21008_(hand, newitem);
            } else if (!player.m_150109_().m_36054_(newitem)) {
                player.m_36176_(newitem, false);
            }
            entity.m_146870_();
        }
    }

    public static List<ItemStack> getItemFromLootTable(ResourceLocation lootTableIn, Level worldIn) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)worldIn);
        if (worldIn.m_142572_() != null) {
            return worldIn.m_142572_().m_129898_().m_79217_(lootTableIn).m_79129_(lootcontext$builder.m_78975_(new LootContextParamSet.Builder().m_81405_()));
        }
        return Lists.newArrayList();
    }

    public static CompoundTag writeEntityToNBT(LivingEntity entity) {
        return EntityUtils.writeEntityToNBT(entity, false);
    }

    public static CompoundTag writeEntityToNBT(LivingEntity entity, boolean keepHomeData) {
        return EntityUtils.writeEntityToNBT(entity, keepHomeData, false);
    }

    public static CompoundTag writeEntityToNBT(LivingEntity entity, boolean keepHomeData, boolean attachModelData) {
        CompoundTag baseTag = new CompoundTag();
        CompoundTag entityTag = new CompoundTag();
        entity.m_20223_(entityTag);
        entityTag.m_128473_("Pos");
        entityTag.m_128473_("Motion");
        if (entityTag.m_128441_("BoundingBox")) {
            entityTag.m_128473_("BoundingBox");
        }
        if (entity instanceof ISpecies && !keepHomeData) {
            entityTag.m_128473_("HomePosX");
            entityTag.m_128473_("HomePosY");
            entityTag.m_128473_("HomePosZ");
        }
        if (attachModelData && entity instanceof ComplexMob) {
            baseTag.m_128405_("CustomModelData", ((ComplexMob)entity).getVariant());
        }
        baseTag.m_128365_("EntityTag", (Tag)entityTag);
        return baseTag;
    }

    public static boolean hasFullHealth(LivingEntity entityIn) {
        return entityIn.m_21223_() >= entityIn.m_21233_();
    }

    public static Pair<Integer, Integer> buildSkinArrays(String name, String species, EntityDataHolder dataIn, int variant, HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> common_list, HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> rare_list) {
        return EntityUtils.buildSkinArrays(name, species, dataIn.getSkins(variant), variant, common_list, rare_list);
    }

    public static Pair<Integer, Integer> buildSkinArrays(String name, String species, int skins, int variant, HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> common_list, HashMap<String, HashMap<Integer, ArrayList<ResourceLocation>>> rare_list) {
        String full_path;
        int i;
        String path = "textures/entity/" + name + "/" + species;
        if (!common_list.containsKey(name)) {
            common_list.put(name, new HashMap());
        }
        if (!rare_list.containsKey(name)) {
            rare_list.put(name, new HashMap());
        }
        Pair values = new Pair((Object)(skins / 10 - 1), (Object)(skins % 10 - 1));
        common_list.get(name).put(variant, new ArrayList());
        if ((Integer)values.getFirst() >= 1) {
            for (i = 0; i <= (Integer)values.getFirst(); ++i) {
                full_path = String.format(path + "_%d.png", i + 1);
                common_list.get(name).get(variant).add(new ResourceLocation("untamedwilds", full_path));
            }
        } else {
            common_list.get(name).get(variant).add(new ResourceLocation("untamedwilds", path + ".png"));
        }
        if ((Integer)values.getSecond() >= 0) {
            rare_list.get(name).put(variant, new ArrayList());
            for (i = 0; i <= (Integer)values.getSecond(); ++i) {
                full_path = String.format(path + "_%dr.png", i + 1);
                rare_list.get(name).get(variant).add(new ResourceLocation("untamedwilds", full_path));
            }
        }
        return values;
    }

    @Deprecated
    public static int populateSkinArray(String path, String suffix, int variant, HashMap<Integer, ArrayList<ResourceLocation>> list, boolean addDefault) {
        list.put(variant, new ArrayList());
        for (int i = 0; i < 99; ++i) {
            int k = i;
            try {
                if (!suffix.matches("[^a-z0-9/._:-]")) {
                    String full_path = String.format(path + suffix, i + 1);
                    Minecraft.m_91087_().m_91098_().m_142591_(new ResourceLocation("untamedwilds", full_path));
                    list.get(variant).add(new ResourceLocation("untamedwilds", full_path));
                    continue;
                }
                UntamedWilds.LOGGER.error("Invalid character in " + suffix + ", terminating Skin registry");
                break;
            }
            catch (Exception e) {
                if (k == 0 && addDefault) {
                    list.get(variant).add(new ResourceLocation("untamedwilds", path + ".png"));
                    ++k;
                }
                if (list.get(variant).isEmpty()) {
                    list.remove(variant);
                }
                return k;
            }
        }
        return 0;
    }

    public static String getVariantName(EntityType<?> typeIn, int variantIn) {
        if (ComplexMob.ENTITY_DATA_HASH.containsKey(typeIn)) {
            return ComplexMob.ENTITY_DATA_HASH.get(typeIn).getName(variantIn);
        }
        if (ComplexMob.CLIENT_DATA_HASH.containsKey(typeIn)) {
            return ComplexMob.CLIENT_DATA_HASH.get(typeIn).getSpeciesName(variantIn);
        }
        return "";
    }

    public static int getNumberOfSpecies(EntityType<?> typeIn) {
        if (ComplexMob.ENTITY_DATA_HASH.containsKey(typeIn)) {
            return ComplexMob.ENTITY_DATA_HASH.get(typeIn).getSpeciesData().size();
        }
        if (ComplexMob.CLIENT_DATA_HASH.containsKey(typeIn)) {
            return ComplexMob.CLIENT_DATA_HASH.get(typeIn).getNumberOfSpecies();
        }
        UntamedWilds.LOGGER.warn("There's no species provided for the EntityType");
        return 0;
    }

    public static SoundEvent getSound(EntityType<?> typeIn, int variantIn, String sound_type) {
        return EntityUtils.getSound(typeIn, variantIn, sound_type, null);
    }

    public static SoundEvent getSound(EntityType<?> typeIn, int variantIn, String sound_type, @Nullable SoundEvent fallback) {
        SoundEvent location;
        if (ComplexMob.ENTITY_DATA_HASH.containsKey(typeIn) && (location = ComplexMob.ENTITY_DATA_HASH.get(typeIn).getSounds(variantIn, sound_type)) != null) {
            return (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(location.m_11660_());
        }
        return fallback;
    }

    public static int getClampedNumberOfSpecies(int i, EntityType<?> typeIn) {
        int size = Math.max(0, EntityUtils.getNumberOfSpecies(typeIn) - 1);
        if (i > size) {
            UntamedWilds.LOGGER.warn("Correcting wrong Variant value of " + i + " to " + size);
        }
        return Mth.m_14045_((int)i, (int)0, (int)size);
    }

    public static ResourceLocation getSkinFromEntity(ComplexMob entityIn) {
        if (entityIn.m_6095_().getRegistryName() != null) {
            String name = entityIn.m_6095_().getRegistryName().m_135815_();
            if (entityIn.getSkin() > 99 && ComplexMob.TEXTURES_RARE.get(name).containsKey(entityIn.getVariant())) {
                return ComplexMob.TEXTURES_RARE.get(name).get(entityIn.getVariant()).get(Math.min(entityIn.getSkin() - 100, ComplexMob.TEXTURES_RARE.get(name).get(entityIn.getVariant()).size() - 1));
            }
            return ComplexMob.TEXTURES_COMMON.get(name).get(entityIn.getVariant()).get(Math.min(entityIn.getSkin(), ComplexMob.TEXTURES_COMMON.get(name).get(entityIn.getVariant()).size() - 1));
        }
        return ResourceLocation.m_135820_((String)"");
    }

    public static void consumeItemStack(TamableAnimal entityIn, ItemStack itemstack) {
        block8: {
            block7: {
                if (!itemstack.m_41614_()) break block7;
                FoodProperties itemFood = itemstack.m_41720_().m_41473_();
                if (itemFood == null) break block8;
                entityIn.m_5496_(SoundEvents.f_11912_, 1.0f, 1.0f);
                if (entityIn instanceof ComplexMobTerrestrial) {
                    ((ComplexMobTerrestrial)entityIn).addHunger(itemFood.m_38744_() * 10);
                } else {
                    entityIn.m_5634_((float)itemFood.m_38744_());
                }
                for (Pair pair : itemFood.m_38749_()) {
                    if (pair.getFirst() == null || !(entityIn.f_19853_.f_46441_.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                    entityIn.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
                }
                break block8;
            }
            if (!PotionUtils.m_43547_((ItemStack)itemstack).isEmpty()) {
                entityIn.m_5496_(SoundEvents.f_11911_, 1.0f, 1.0f);
                if (entityIn instanceof ComplexMobTerrestrial) {
                    ((ComplexMobTerrestrial)entityIn).addHunger(10);
                }
                for (MobEffectInstance effectinstance : PotionUtils.m_43547_((ItemStack)itemstack)) {
                    if (effectinstance.m_19544_().m_8093_()) {
                        effectinstance.m_19544_().m_19461_((Entity)entityIn.m_142480_(), (Entity)entityIn.m_142480_(), (LivingEntity)entityIn, effectinstance.m_19564_(), 1.0);
                        continue;
                    }
                    entityIn.m_7292_(new MobEffectInstance(effectinstance));
                }
            }
        }
    }

    public static Vec3 getOvershootPath(Entity entityIn, Entity targetIn, double overshoot) {
        double x = targetIn.m_20185_() - entityIn.m_20185_();
        double z = targetIn.m_20189_() - entityIn.m_20189_();
        float angle = (float)Math.atan2(z, x);
        double dist = Mth.m_14116_((float)((float)(Math.pow(x, 2.0) + Math.pow(z, 2.0))));
        double add_x = (double)Mth.m_14089_((float)angle) * (dist + overshoot);
        double add_z = (double)Mth.m_14031_((float)angle) * (dist + overshoot);
        return new Vec3(entityIn.m_20185_() + add_x, targetIn.m_20186_(), entityIn.m_20189_() + add_z);
    }

    public static boolean isInvalidPartner(ComplexMob entityIn, ComplexMob partnerIn, boolean isHermaphrodite) {
        return (Boolean)ConfigGamerules.genderedBreeding.get() != false && (partnerIn.getGender() == entityIn.getGender() || isHermaphrodite) || partnerIn.getVariant() != entityIn.getVariant() || partnerIn.m_146764_() != 0;
    }
}

