/*
 * Decompiled with CFR 0.152.
 */
package untamedwilds.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import untamedwilds.entity.ComplexMobTerrestrial;

public class SpeciesDataHolder {
    public static final Codec<SpeciesDataHolder> CODEC = RecordCodecBuilder.create(p_237051_0_ -> p_237051_0_.group((App)Codec.STRING.fieldOf("name").orElse((Object)"").forGetter(p_237056_0_ -> p_237056_0_.name), (App)Codec.INT.fieldOf("variant").orElse((Object)0).forGetter(p_237054_0_ -> p_237054_0_.variant), (App)Codec.FLOAT.fieldOf("scale").orElse((Object)Float.valueOf(-1.0f)).forGetter(p_237055_0_ -> p_237055_0_.modelScale), (App)Codec.INT.fieldOf("rarity").orElse((Object)-1).forGetter(p_237054_0_ -> p_237054_0_.rarity), (App)Codec.FLOAT.fieldOf("attack").orElse((Object)Float.valueOf(-1.0f)).forGetter(p_237055_0_ -> Float.valueOf(p_237055_0_.attack)), (App)Codec.FLOAT.fieldOf("health").orElse((Object)Float.valueOf(-1.0f)).forGetter(p_237055_0_ -> Float.valueOf(p_237055_0_.health)), (App)ComplexMobTerrestrial.ActivityType.CODEC.fieldOf("activityType").orElse((Object)ComplexMobTerrestrial.ActivityType.INSOMNIAC).forGetter(p_237052_0_ -> p_237052_0_.activityType), (App)Codec.STRING.fieldOf("favourite_food").orElse((Object)"").forGetter(p_237052_0_ -> p_237052_0_.favouriteFood_input), (App)Codec.INT.fieldOf("growing_time").orElse((Object)-1).forGetter(p_237054_0_ -> p_237054_0_.growing_time), (App)Codec.INT.fieldOf("offspring").orElse((Object)-1).forGetter(p_237054_0_ -> p_237054_0_.offspring), (App)Codec.INT.fieldOf("skins").orElse((Object)10).forGetter(p_237054_0_ -> p_237054_0_.skins), (App)Codec.STRING.fieldOf("breeding_season").orElse((Object)"NONE").forGetter(p_237054_0_ -> p_237054_0_.breeding_season), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)SoundEvent.f_11655_).fieldOf("sounds").orElse(Collections.emptyMap()).forGetter(p_237052_0_ -> p_237052_0_.sounds), (App)Codec.unboundedMap((Codec)Codec.STRING, (Codec)Codec.INT).fieldOf("flags").orElse(Collections.emptyMap()).forGetter(p_237054_0_ -> p_237054_0_.flags), (App)Codec.STRING.listOf().listOf().fieldOf("spawnBiomes").orElse(new ArrayList()).forGetter(p_237052_0_ -> p_237052_0_.spawnBiomes)).apply((Applicative)p_237051_0_, SpeciesDataHolder::new));
    private final String name;
    private final int variant;
    private final Float modelScale;
    private final int rarity;
    private final float attack;
    private final float health;
    private final ComplexMobTerrestrial.ActivityType activityType;
    private final String favouriteFood_input;
    private final ItemStack favouriteFood;
    private final int growing_time;
    private final int offspring;
    private final int skins;
    private final String breeding_season;
    private final Map<String, SoundEvent> sounds;
    private final Map<String, Integer> flags;
    private final List<List<String>> spawnBiomes;
    private final List<List<BiomeTestHolder>> spawnBiomeData;

    public SpeciesDataHolder(String p_i232114_1_, int variant, float p_i232114_2_, int p_i232114_3_, float attack, float health, ComplexMobTerrestrial.ActivityType activityType, String favourite_food, int growing_time, int offspring, int skins, String breeding_season, Map<String, SoundEvent> sounds, Map<String, Integer> flags, List<List<String>> spawn_biomes) {
        this.name = p_i232114_1_;
        this.variant = variant;
        this.modelScale = Float.valueOf(p_i232114_2_);
        this.rarity = p_i232114_3_;
        this.attack = attack;
        this.health = health;
        this.activityType = activityType;
        this.favouriteFood_input = favourite_food;
        this.favouriteFood = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.m_135820_((String)this.favouriteFood_input)));
        this.growing_time = growing_time;
        this.offspring = offspring;
        this.skins = skins;
        this.breeding_season = breeding_season;
        this.sounds = sounds;
        this.flags = flags;
        this.spawnBiomes = spawn_biomes;
        this.spawnBiomeData = new ArrayList<List<BiomeTestHolder>>();
        for (List<String> sublist : this.spawnBiomes) {
            ArrayList<BiomeTestHolder> subsublist = new ArrayList<BiomeTestHolder>();
            Iterator<String> iterator = sublist.iterator();
            while (iterator.hasNext()) {
                String condition;
                String key = condition = iterator.next();
                if (condition.contains("|")) {
                    key = condition.split("\\|")[1];
                }
                ConditionTypes type = SpeciesDataHolder.getTypeOfCondition(condition);
                ConditionModifiers modifier = SpeciesDataHolder.getModifierFromString(condition);
                BiomeTestHolder testHolder = new BiomeTestHolder(key, type, modifier);
                subsublist.add(testHolder);
            }
            this.spawnBiomeData.add(subsublist);
        }
    }

    public String getString() {
        return this.name + ": Scale: " + this.modelScale + " Rarity: " + this.rarity + " Spawn Biomes: " + this.spawnBiomes;
    }

    public String getName() {
        return this.name;
    }

    public int getVariant() {
        return this.variant;
    }

    public Float getModelScale() {
        return this.modelScale;
    }

    public Integer getRarity() {
        return this.rarity;
    }

    public Float getAttack() {
        return Float.valueOf(this.attack);
    }

    public Float getHealth() {
        return Float.valueOf(this.health);
    }

    public ComplexMobTerrestrial.ActivityType getActivityType() {
        return this.activityType;
    }

    @Nullable
    public ItemStack getFavouriteFood() {
        return this.favouriteFood;
    }

    public Integer getGrowingTime() {
        return this.growing_time;
    }

    public Integer getOffspring() {
        return this.offspring;
    }

    public Integer getSkins() {
        return this.skins;
    }

    public String getBreedingSeason() {
        return this.breeding_season;
    }

    public Map<String, SoundEvent> getSounds() {
        return this.sounds;
    }

    public Map<String, Integer> getFlags() {
        return this.flags;
    }

    public List<List<BiomeTestHolder>> getBiomeCategories() {
        return this.spawnBiomeData;
    }

    public static ConditionModifiers getModifierFromString(String strIn) {
        if (strIn.contains("!")) {
            return ConditionModifiers.INVERTED;
        }
        if (strIn.contains("#")) {
            return ConditionModifiers.PRIORITY;
        }
        return ConditionModifiers.NONE;
    }

    public static ConditionTypes getTypeOfCondition(String strIn) {
        String clean = strIn.replaceAll("[!#]", "");
        if (clean.contains("|")) {
            String str;
            switch (str = clean.split("\\|")[0]) {
                case "category": {
                    return ConditionTypes.BIOME_CATEGORY;
                }
                case "dictionary": {
                    return ConditionTypes.FORGE_DICTIONARY;
                }
                case "tag": {
                    return ConditionTypes.BIOME_TAG;
                }
                case "resource": {
                    return ConditionTypes.REGISTRY_NAME;
                }
            }
        }
        return ConditionTypes.BIOME_CATEGORY;
    }

    public static enum ConditionTypes {
        BIOME_CATEGORY("Category"),
        FORGE_DICTIONARY("Dictionary"),
        BIOME_TAG("Tag"),
        REGISTRY_NAME("Resource Location");

        public String type;

        private ConditionTypes(String type) {
            this.type = type;
        }

        public String getString() {
            return this.type;
        }
    }

    public static enum ConditionModifiers {
        NONE(" "),
        INVERTED(" Inverted "),
        PRIORITY(" Priority ");

        public String type;

        private ConditionModifiers(String type) {
            this.type = type;
        }

        public String getString() {
            return this.type;
        }
    }

    public static class BiomeTestHolder {
        private final String key;
        private final ConditionTypes type;
        private final ConditionModifiers modifier;

        public BiomeTestHolder(String key, ConditionTypes typeIn, ConditionModifiers modifierIn) {
            this.key = key;
            this.type = typeIn;
            this.modifier = modifierIn;
        }

        public boolean isValidBiome(Holder<Biome> biomekey, Biome biome) {
            boolean result;
            switch (this.type) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case BIOME_CATEGORY: {
                    boolean bl;
                    if (biome.f_47442_ == Biome.BiomeCategory.m_47643_((String)this.key)) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case FORGE_DICTIONARY: {
                    boolean bl = BiomeDictionary.hasType((ResourceKey)((ResourceKey)biomekey.m_203543_().get()), (BiomeDictionary.Type)BiomeDictionary.Type.getType((String)this.key, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]));
                    break;
                }
                case BIOME_TAG: {
                    boolean bl = biomekey.m_203373_(new ResourceLocation(this.key));
                    break;
                }
                case REGISTRY_NAME: {
                    boolean bl = result = biome.getRegistryName().equals((Object)new ResourceLocation(this.key));
                }
            }
            if (this.modifier == ConditionModifiers.INVERTED) {
                return !result;
            }
            return result;
        }
    }
}

