/*
 * Decompiled with CFR 0.152.
 */
package MessiahOfDoom.DWE.common.utils;

import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static Logger log;

    public static Logger getLog() {
        if (log == null) {
            log = LogManager.getFormatterLogger((String)"dragonwingselytra");
        }
        return log;
    }

    public static boolean isInstanceOfTE(World world, BlockPos pos, Class<? extends TileEntity> te) {
        return world.func_175625_s(pos) != null && world.func_175625_s(pos).getClass().getSuperclass().equals(te);
    }

    public static boolean isEqualToTE(World world, BlockPos pos, Class<? extends TileEntity> te) {
        return world.func_175625_s(pos) != null && world.func_175625_s(pos).getClass().equals(te);
    }

    public static boolean hasBlockAndEntity(World world, BlockPos pos, Class<? extends TileEntity> te, Block block) {
        return Utils.hasBlock(world, pos, block) && Utils.isEqualToTE(world, pos, te);
    }

    public static boolean hasBlock(World world, BlockPos pos, Block block) {
        return world.func_180495_p(pos).func_177230_c() == block;
    }

    public static boolean isBlockAir(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockAir;
    }

    public static boolean isUnbreakable(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c().func_176195_g(world.func_180495_p(pos), world, pos) == -1.0f;
    }

    public static TextFormatting getFormattingForRarity(int rarity) {
        switch (rarity) {
            case 1: {
                return TextFormatting.AQUA;
            }
            case 2: {
                return TextFormatting.BLUE;
            }
            case 3: {
                return TextFormatting.LIGHT_PURPLE;
            }
            case 4: {
                return TextFormatting.GOLD;
            }
            case 5: {
                return TextFormatting.DARK_RED;
            }
            case 6: {
                return TextFormatting.BLACK;
            }
        }
        return TextFormatting.WHITE;
    }

    public static ItemStack getStackForPotion(int type, String potion) {
        ItemStack stack = new ItemStack((Item)(type == 0 ? Items.field_151068_bn : (type == 1 ? Items.field_185155_bH : Items.field_185156_bI)));
        PotionUtils.func_185188_a((ItemStack)stack, (PotionType)PotionType.func_185168_a((String)potion));
        return stack;
    }
}

