/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimatedGeoModel;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.geo.render.built.GeoBone;

@OnlyIn(value=Dist.CLIENT)
public class ModelGeckoBiped
extends MowzieAnimatedGeoModel<GeckoPlayer> {
    private ResourceLocation animationFileLocation;
    private ResourceLocation modelLocation;
    private ResourceLocation textureLocation;
    public boolean isSitting = false;
    public boolean isChild = true;
    public float swingProgress;
    public boolean isSneak;
    public float swimAnimation;
    public BipedModel.ArmPose leftArmPose = BipedModel.ArmPose.EMPTY;
    public BipedModel.ArmPose rightArmPose = BipedModel.ArmPose.EMPTY;
    protected boolean useSmallArms;

    public ResourceLocation getAnimationFileLocation(GeckoPlayer animatable) {
        return this.animationFileLocation;
    }

    public ResourceLocation getModelLocation(GeckoPlayer animatable) {
        return this.modelLocation;
    }

    public ResourceLocation getTextureLocation(GeckoPlayer animatable) {
        return this.textureLocation;
    }

    @Override
    public boolean resourceForModelId(AbstractClientPlayerEntity player) {
        this.animationFileLocation = new ResourceLocation("mowziesmobs", "animations/animated_player.animation.json");
        this.modelLocation = new ResourceLocation("mowziesmobs", "geo/animated_player.geo.json");
        this.textureLocation = player.func_110306_p();
        return true;
    }

    public void setUseSmallArms(boolean useSmallArms) {
        this.useSmallArms = useSmallArms;
    }

    public boolean isUsingSmallArms() {
        return this.useSmallArms;
    }

    public MowzieGeoBone bipedHead() {
        return this.getMowzieBone("Head");
    }

    public MowzieGeoBone bipedHeadwear() {
        return this.getMowzieBone("HatLayer");
    }

    public MowzieGeoBone bipedBody() {
        return this.getMowzieBone("Body");
    }

    public MowzieGeoBone bipedRightArm() {
        return this.getMowzieBone("RightArm");
    }

    public MowzieGeoBone bipedLeftArm() {
        return this.getMowzieBone("LeftArm");
    }

    public MowzieGeoBone bipedRightLeg() {
        return this.getMowzieBone("RightLeg");
    }

    public MowzieGeoBone bipedLeftLeg() {
        return this.getMowzieBone("LeftLeg");
    }

    public void setVisible(boolean visible) {
        this.bipedHead().setHidden(!visible);
        this.bipedHeadwear().setHidden(!visible);
        this.bipedBody().setHidden(!visible);
        this.bipedRightArm().setHidden(!visible);
        this.bipedLeftArm().setHidden(!visible);
        this.bipedRightLeg().setHidden(!visible);
        this.bipedLeftLeg().setHidden(!visible);
    }

    public void setRotationAngles() {
        MowzieGeoBone head = this.getMowzieBone("Head");
        MowzieGeoBone neck = this.getMowzieBone("Neck");
        float yaw = 0.0f;
        float pitch = 0.0f;
        float roll = 0.0f;
        GeoBone parent = neck.parent;
        while (parent != null) {
            pitch += parent.getRotationX();
            yaw += parent.getRotationY();
            roll += parent.getRotationZ();
            parent = parent.parent;
        }
        neck.addRotation(-yaw, -pitch, -roll);
    }

    public void setRotationAngles(PlayerEntity entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTick) {
        boolean flag3;
        if (!this.isInitialized()) {
            return;
        }
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        MowzieGeoBone rightArmClassic = this.getMowzieBone("RightArmClassic");
        MowzieGeoBone leftArmClassic = this.getMowzieBone("LeftArmClassic");
        MowzieGeoBone rightArmSlim = this.getMowzieBone("RightArmSlim");
        MowzieGeoBone leftArmSlim = this.getMowzieBone("LeftArmSlim");
        if (this.useSmallArms) {
            rightArmClassic.setHidden(true);
            leftArmClassic.setHidden(true);
            rightArmSlim.setHidden(false);
            leftArmSlim.setHidden(false);
        } else {
            rightArmSlim.setHidden(true);
            leftArmSlim.setHidden(true);
            rightArmClassic.setHidden(false);
            leftArmClassic.setHidden(false);
        }
        this.swimAnimation = entityIn.func_205015_b(partialTick);
        float headLookAmount = this.getControllerValue("HeadLookController");
        float armLookAmount = 1.0f - this.getControllerValue("ArmPitchController");
        float armLookAmountRight = this.getBone("ArmPitchController").getPositionY();
        float armLookAmountLeft = this.getBone("ArmPitchController").getPositionZ();
        boolean flag = entityIn.func_184599_cB() > 4;
        boolean flag1 = entityIn.func_213314_bj();
        this.bipedHead().addRotationY(headLookAmount * -netHeadYaw * ((float)Math.PI / 180));
        this.getMowzieBone("LeftClavicle").addRotationY(Math.min(armLookAmount + armLookAmountLeft, 1.0f) * -netHeadYaw * ((float)Math.PI / 180));
        this.getMowzieBone("RightClavicle").addRotationY(Math.min(armLookAmount + armLookAmountRight, 1.0f) * -netHeadYaw * ((float)Math.PI / 180));
        if (flag) {
            this.bipedHead().addRotationX(-0.7853982f);
        } else if (this.swimAnimation > 0.0f) {
            if (flag1) {
                this.bipedHead().addRotationX(headLookAmount * this.rotLerpRad(this.swimAnimation, this.bipedHead().getRotationX(), -0.7853982f));
            } else {
                this.bipedHead().addRotationX(headLookAmount * this.rotLerpRad(this.swimAnimation, this.bipedHead().getRotationX(), headPitch * ((float)Math.PI / 180)));
            }
        } else {
            this.bipedHead().addRotationX(headLookAmount * -headPitch * ((float)Math.PI / 180));
            this.getMowzieBone("LeftClavicle").addRotationX(Math.min(armLookAmount + armLookAmountLeft, 1.0f) * -headPitch * ((float)Math.PI / 180));
            this.getMowzieBone("RightClavicle").addRotationX(Math.min(armLookAmount + armLookAmountRight, 1.0f) * -headPitch * ((float)Math.PI / 180));
        }
        float f = 1.0f;
        if (flag) {
            f = (float)entityIn.func_213322_ci().func_189985_c();
            f /= 0.2f;
            f = f * f * f;
        }
        if (f < 1.0f) {
            f = 1.0f;
        }
        float legWalkAmount = this.getControllerValue("LegWalkController");
        float armSwingAmount = this.getControllerValue("ArmSwingController");
        float armSwingAmountRight = 1.0f - this.getBone("ArmSwingController").getPositionY();
        float armSwingAmountLeft = 1.0f - this.getBone("ArmSwingController").getPositionZ();
        this.bipedRightArm().addRotationX(armSwingAmount * armSwingAmountRight * MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 2.0f * limbSwingAmount * 0.5f / f);
        this.bipedLeftArm().addRotationX(armSwingAmount * armSwingAmountLeft * MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 2.0f * limbSwingAmount * 0.5f / f);
        this.bipedRightLeg().addRotationX(legWalkAmount * MathHelper.func_76134_b((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount / f);
        this.bipedLeftLeg().addRotationX(legWalkAmount * MathHelper.func_76134_b((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount / f);
        if (this.isSitting) {
            this.bipedRightArm().setRotationX(this.bipedRightArm().getRotationX() + -0.62831855f);
            this.bipedLeftArm().setRotationX(this.bipedRightArm().getRotationX() + -0.62831855f);
            this.bipedRightLeg().setRotationX(-1.4137167f);
            this.bipedRightLeg().setRotationY(0.31415927f);
            this.bipedRightLeg().setRotationZ(0.07853982f);
            this.bipedLeftLeg().setRotationX(-1.4137167f);
            this.bipedLeftLeg().setRotationY(-0.31415927f);
            this.bipedLeftLeg().setRotationZ(-0.07853982f);
            this.getMowzieBone("Waist").setRotation(0.0f, 0.0f, 0.0f);
            this.getMowzieBone("Root").setRotation(0.0f, 0.0f, 0.0f);
        }
        boolean flag2 = entityIn.func_184591_cq() == HandSide.RIGHT;
        boolean bl = flag3 = flag2 ? this.leftArmPose.func_241657_a_() : this.rightArmPose.func_241657_a_();
        if (flag2 != flag3) {
            this.func_241655_c_(entityIn);
            this.func_241654_b_(entityIn);
        } else {
            this.func_241654_b_(entityIn);
            this.func_241655_c_(entityIn);
        }
        float sneakController = this.getControllerValue("CrouchController");
        if (this.isSneak) {
            this.bipedBody().addRotationX(-0.5f * sneakController);
            this.getMowzieBone("Neck").addRotationX(0.5f * sneakController);
            this.bipedRightArm().addRotation(0.4f * sneakController, 0.0f, 0.0f);
            this.bipedLeftArm().addRotation(0.4f * sneakController, 0.0f, 0.0f);
            this.bipedHead().addPositionY(-1.0f * sneakController);
            this.bipedBody().addPosition(0.0f, -1.5f * sneakController, 1.7f * sneakController);
            this.getMowzieBone("Waist").addPosition(0.0f, -0.2f * sneakController, 4.0f * sneakController);
            this.bipedLeftArm().addRotationX(-0.4f * sneakController);
            this.bipedLeftArm().addPosition(0.0f, 0.2f * sneakController, -1.0f * sneakController);
            this.bipedRightArm().addRotationX(-0.4f * sneakController);
            this.bipedRightArm().addPosition(0.0f, 0.2f * sneakController, -1.0f * sneakController);
            this.getMowzieBone("Waist").addPositionY(2.0f * (1.0f - sneakController));
        }
        float armBreathAmount = this.getControllerValue("ArmBreathController");
        ModelGeckoBiped.breathAnim(this.bipedRightArm(), this.bipedLeftArm(), ageInTicks, armBreathAmount);
        AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)entityIn);
        if (abilityCapability != null && abilityCapability.getActiveAbility() != null) {
            abilityCapability.codeAnimations(this, partialTick);
        }
    }

    protected MowzieGeoBone getArmForSide(HandSide side) {
        return side == HandSide.LEFT ? this.bipedLeftArm() : this.bipedRightArm();
    }

    protected float rotLerpRad(float angleIn, float maxAngleIn, float mulIn) {
        float f = (mulIn - maxAngleIn) % ((float)Math.PI * 2);
        if (f < (float)(-Math.PI)) {
            f += (float)Math.PI * 2;
        }
        if (f >= (float)Math.PI) {
            f -= (float)Math.PI * 2;
        }
        return maxAngleIn + angleIn * f;
    }

    private float getArmAngleSq(float limbSwing) {
        return -65.0f * limbSwing + limbSwing * limbSwing;
    }

    protected HandSide getMainHand(PlayerEntity entityIn) {
        HandSide handside = entityIn.func_184591_cq();
        return entityIn.field_184622_au == Hand.MAIN_HAND ? handside : handside.func_188468_a();
    }

    public static void breathAnim(MowzieGeoBone rightArm, MowzieGeoBone leftArm, float ageInTicks, float armBreathAmount) {
        rightArm.addRotationZ(armBreathAmount * MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f + 0.05f);
        leftArm.addRotationZ(armBreathAmount * -MathHelper.func_76134_b((float)(ageInTicks * 0.09f)) * 0.05f - 0.05f);
        rightArm.addRotationX(armBreathAmount * MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f);
        leftArm.addRotationX(armBreathAmount * -MathHelper.func_76126_a((float)(ageInTicks * 0.067f)) * 0.05f);
    }

    private void func_241654_b_(PlayerEntity p_241654_1_) {
        float armSwingAmount = this.getControllerValue("ArmSwingController");
        switch (this.rightArmPose) {
            case EMPTY: {
                break;
            }
            case BLOCK: {
                this.bipedRightArm().addRotationX(0.9424779f * armSwingAmount);
                break;
            }
            case ITEM: {
                this.bipedRightArm().addRotationX(0.31415927f * armSwingAmount);
            }
        }
    }

    private void func_241655_c_(PlayerEntity p_241655_1_) {
        float armSwingAmount = this.getControllerValue("ArmSwingController");
        switch (this.leftArmPose) {
            case EMPTY: {
                break;
            }
            case BLOCK: {
                this.bipedLeftArm().addRotationX(0.9424779f * armSwingAmount);
                break;
            }
            case ITEM: {
                this.bipedLeftArm().addRotationX(0.31415927f * armSwingAmount);
            }
        }
    }
}

