/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.client.model.entity;

import com.bobmowzie.mowziesmobs.client.model.tools.RigUtils;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieAnimatedGeoModel;
import com.bobmowzie.mowziesmobs.client.model.tools.geckolib.MowzieGeoBone;
import com.bobmowzie.mowziesmobs.server.entity.sculptor.EntitySculptor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.processor.IBone;
import software.bernie.geckolib3.model.provider.data.EntityModelData;

public class ModelSculptor
extends MowzieAnimatedGeoModel<EntitySculptor> {
    public ResourceLocation getModelLocation(EntitySculptor object) {
        return new ResourceLocation("mowziesmobs", "geo/sculptor.geo.json");
    }

    public ResourceLocation getTextureLocation(EntitySculptor object) {
        return new ResourceLocation("mowziesmobs", "textures/entity/sculptor.png");
    }

    public ResourceLocation getAnimationFileLocation(EntitySculptor object) {
        return new ResourceLocation("mowziesmobs", "animations/sculptor.animation.json");
    }

    @Override
    public void codeAnimations(EntitySculptor entity, Integer uniqueID, AnimationEvent<?> customPredicate) {
        IBone head = this.getBone("head");
        IBone handClosedL = this.getBone("handClosedL");
        IBone handClosedR = this.getBone("handClosedR");
        IBone handOpenL = this.getBone("handOpenL");
        IBone handOpenR = this.getBone("handOpenR");
        IBone backCloth = this.getBone("clothBack");
        EntityModelData extraData = (EntityModelData)customPredicate.getExtraDataOfType(EntityModelData.class).get(0);
        head.setRotationX(head.getRotationX() + extraData.headPitch * ((float)Math.PI / 180));
        head.setRotationY(head.getRotationY() + extraData.netHeadYaw * ((float)Math.PI / 180));
        handClosedL.setHidden(entity.handLOpen);
        handClosedR.setHidden(entity.handROpen);
        handOpenL.setHidden(!entity.handLOpen);
        handOpenR.setHidden(!entity.handROpen);
        backCloth.setHidden(false);
        this.beadsCorrections(entity);
        this.skirtCorrections(entity);
    }

    private void beadsCorrections(EntitySculptor entity) {
        HashMap<MowzieGeoBone, Vector3d> beadsDirections = new HashMap<MowzieGeoBone, Vector3d>();
        beadsDirections.put(this.getMowzieBone("bead1"), new Vector3d(0.0, -1.0, 0.0));
        beadsDirections.put(this.getMowzieBone("bead2"), new Vector3d(0.0, -1.0, 0.0));
        beadsDirections.put(this.getMowzieBone("bead3"), new Vector3d(0.0, -1.0, 0.0));
        beadsDirections.put(this.getMowzieBone("bead4"), new Vector3d(0.0, -0.5, 0.25));
        beadsDirections.put(this.getMowzieBone("bead5"), new Vector3d(0.0, -0.5, 0.25));
        beadsDirections.put(this.getMowzieBone("bead6"), new Vector3d(0.0, -0.5, 1.0));
        beadsDirections.put(this.getMowzieBone("bead7"), new Vector3d(0.0, -0.5, 1.0));
        beadsDirections.put(this.getMowzieBone("bead8"), new Vector3d(0.0, -0.25, 0.75));
        beadsDirections.put(this.getMowzieBone("bead9"), new Vector3d(0.0, -0.25, 0.75));
        IBone headJoint = this.getBone("head_joint");
        Vector3d headPos = new Vector3d((double)headJoint.getPivotX(), (double)headJoint.getPivotY(), (double)headJoint.getPivotZ());
        IBone head = this.getBone("head");
        Vector3d headDir = new Vector3d(0.0, 0.0, -1.0).func_72432_b();
        headDir = headDir.func_178785_b(head.getRotationY()).func_178789_a(head.getRotationX());
        for (Map.Entry beadDir : beadsDirections.entrySet()) {
            MowzieGeoBone bead = (MowzieGeoBone)((Object)beadDir.getKey());
            Vector3d beadPos = new Vector3d((double)bead.getPivotX(), (double)bead.getPivotY(), (double)bead.getPivotZ());
            Vector3d dir = beadPos.func_178788_d(headPos).func_72432_b().func_216372_d(1.0, -1.0, 1.0);
            double dot = dir.func_72430_b(headDir);
            dot = Math.pow(Math.max(dot, 0.0), 3.5);
            Vector3d moveDir = ((Vector3d)beadDir.getValue()).func_72432_b();
            bead.addPosition(moveDir.func_186678_a(dot * 3.0));
        }
    }

    private void skirtCorrections(EntitySculptor entity) {
        MowzieGeoBone headJoint = this.getMowzieBone("head_joint");
        MowzieGeoBone thighR = this.getMowzieBone("thighR");
        MowzieGeoBone thighJointR = this.getMowzieBone("thighJointR");
        MowzieGeoBone thighJointL = this.getMowzieBone("thighJointL");
        MowzieGeoBone calfR = this.getMowzieBone("calfR");
        MowzieGeoBone thighL = this.getMowzieBone("thighL");
        MowzieGeoBone calfL = this.getMowzieBone("calfL");
        MowzieGeoBone footR = this.getMowzieBone("footR");
        MowzieGeoBone skirtBack = this.getMowzieBone("skirtBack");
        MowzieGeoBone skirtFront = this.getMowzieBone("skirtFront");
        MowzieGeoBone skirtL = this.getMowzieBone("skirtL");
        MowzieGeoBone skirtR = this.getMowzieBone("skirtR");
        MowzieGeoBone skirtJointL = this.getMowzieBone("skirtJointL");
        MowzieGeoBone skirtJointR = this.getMowzieBone("skirtJointR");
        MowzieGeoBone skirtJoint2L = this.getMowzieBone("skirtJoint2L");
        MowzieGeoBone skirtJoint2R = this.getMowzieBone("skirtJoint2R");
        MowzieGeoBone skirtEndR = this.getMowzieBone("skirtEndR");
        MowzieGeoBone skirtEndL = this.getMowzieBone("skirtEndL");
        MowzieGeoBone skirtLocFrontR = this.getMowzieBone("skirtFrontLocR");
        MowzieGeoBone skirtLocFrontL = this.getMowzieBone("skirtFrontLocL");
        MowzieGeoBone skirtLocBackR = this.getMowzieBone("skirtBackLocR");
        MowzieGeoBone skirtLocBackL = this.getMowzieBone("skirtBackLocL");
        headJoint.setHidden(false);
        Vector3d thighToKneeR = calfR.getModelPosition().func_178788_d(thighR.getModelPosition()).func_72432_b();
        Vector3d thighToKneeL = calfL.getModelPosition().func_178788_d(thighL.getModelPosition()).func_72432_b();
        skirtEndL.addPosition(-0.2f, -1.5f, 0.0f);
        skirtEndR.addPosition(0.2f, -1.5f, 0.0f);
        Vector3d thighToSkirtEndR = skirtEndR.getModelPosition().func_178788_d(thighR.getModelPosition()).func_72432_b();
        Vector3d thighToSkirtEndL = skirtEndL.getModelPosition().func_178788_d(thighL.getModelPosition()).func_72432_b();
        float rightDot = (float)thighToKneeR.func_72430_b(new Vector3d(0.0, -1.0, 0.0));
        rightDot = (float)Math.pow(Math.max(rightDot, 0.0f), 3.0);
        float leftDot = (float)thighToKneeL.func_72430_b(new Vector3d(0.0, -1.0, 0.0));
        leftDot = (float)Math.pow(Math.max(leftDot, 0.0f), 3.0);
        skirtJointR.addPosition(Math.max(-0.9f * rightDot, -0.7f), 0.0f, Math.max(-0.7f * rightDot, -0.5f));
        skirtJointL.addPosition(-Math.max(-0.9f * leftDot, -0.7f), 0.0f, Math.max(-0.7f * leftDot, -0.5f));
        MowzieGeoBone test = this.getMowzieBone("test");
        MowzieGeoBone test2 = this.getMowzieBone("test2");
        MowzieGeoBone test3 = this.getMowzieBone("test3");
        Quaternion rightRot = RigUtils.betweenVectors(thighToSkirtEndR, thighToKneeR);
        Quaternion leftRot = RigUtils.betweenVectors(thighToSkirtEndL, thighToKneeL);
        Matrix4f rightMat = new Matrix4f(rightRot);
        Matrix4f leftMat = new Matrix4f(leftRot);
        skirtJoint2R.setModelRotationMat(rightMat);
        skirtJoint2L.setModelRotationMat(leftMat);
        Vector3d average = thighToKneeL.func_178787_e(thighToKneeR).func_186678_a(2.0).func_216372_d(0.0, 1.0, 1.0).func_72432_b();
        float angleAv = (float)MathHelper.func_181159_b((double)average.func_82617_b(), (double)average.func_82616_c());
        skirtBack.setRotationX(skirtBack.getRotationX() - angleAv + 3.48f);
        skirtFront.setRotationX(skirtFront.getRotationX() - Math.min(angleAv, -2.0f) + 3.48f);
        Vector3d skirtFrontDiff = skirtLocFrontL.getModelPosition().func_178788_d(skirtLocFrontR.getModelPosition());
        skirtFront.setScaleX(Math.max((float)((double)0.3f + (double)0.15f * skirtFrontDiff.func_72433_c()), 0.4f));
        Vector3d skirtBackDiff = skirtLocBackL.getModelPosition().func_178788_d(skirtLocBackR.getModelPosition());
        skirtBack.setScaleX((float)((double)0.15f + (double)0.1f * skirtBackDiff.func_72433_c()));
        float angleF = (float)MathHelper.func_181159_b((double)skirtFrontDiff.func_72432_b().func_82616_c(), (double)skirtFrontDiff.func_72432_b().func_82615_a());
        if ((double)angleF < 0.001 || (double)angleF > 3.141) {
            angleF = 0.0f;
        }
        skirtFront.setRotationY(angleF * 0.6f);
        skirtFront.addPosition(0.5f * (float)skirtLocFrontR.getModelPosition().func_178787_e(skirtFrontDiff.func_186678_a(0.5)).func_82615_a(), 0.0f, 0.0f);
        float angleB = (float)MathHelper.func_181159_b((double)skirtBackDiff.func_72432_b().func_82616_c(), (double)skirtBackDiff.func_72432_b().func_82615_a());
        skirtBack.setRotationY(angleB * 0.5f);
        skirtBack.addPosition(0.5f * (float)skirtLocBackR.getModelPosition().func_178787_e(skirtBackDiff.func_186678_a(0.5)).func_82615_a(), 0.0f, 0.0f);
        float bothDots = (float)Math.pow(rightDot * leftDot, 1.0);
        float f = Math.min(1.0f, bothDots * 2.0f);
        skirtR.addRotation(0.0f, MathHelper.func_76131_a((float)angleF, (float)-0.5f, (float)0.5f) * (1.0f - f) - bothDots * 0.4f, 0.0f);
        skirtL.addRotation(0.0f, MathHelper.func_76131_a((float)angleF, (float)-0.5f, (float)0.5f) * (1.0f - f) + bothDots * 0.4f, 0.0f);
        MowzieGeoBone frontCloth = this.getMowzieBone("clothFront");
        MowzieGeoBone frontCloth2 = this.getMowzieBone("clothFront2");
        frontCloth.setRotation(skirtFront.getRotation());
        Matrix4f mat = frontCloth.getModelRotationMat().func_226601_d_();
        mat.func_226600_c_();
        frontCloth2.setModelRotationMat(mat);
    }
}

