/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.ability.abilities;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.ability.AbilitySection;
import com.bobmowzie.mowziesmobs.server.ability.AbilityType;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityBoulder;
import com.bobmowzie.mowziesmobs.server.potion.EffectGeomancy;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.INBT;
import net.minecraft.particles.ParticleType;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class SpawnBoulderAbility
extends Ability {
    private static int MAX_CHARGE = 60;
    public static final double SPAWN_BOULDER_REACH = 5.0;
    public BlockPos spawnBoulderPos = new BlockPos(0, 0, 0);
    public Vector3d lookPos = new Vector3d(0.0, 0.0, 0.0);
    private BlockState spawnBoulderBlock = Blocks.field_150346_d.func_176223_P();
    private int spawnBoulderCharge = 0;

    public SpawnBoulderAbility(AbilityType<? extends Ability> abilityType, LivingEntity user) {
        super(abilityType, user, new AbilitySection[]{new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.STARTUP, MAX_CHARGE), new AbilitySection.AbilitySectionInstant(AbilitySection.AbilitySectionType.ACTIVE), new AbilitySection.AbilitySectionDuration(AbilitySection.AbilitySectionType.RECOVERY, 12)});
    }

    @Override
    public void start() {
        super.start();
        this.playAnimation("spawn_boulder_start", false);
    }

    @Override
    public boolean tryAbility() {
        BlockState blockAbove;
        Vector3d to;
        Vector3d from = this.getUser().func_174824_e(1.0f);
        BlockRayTraceResult result = this.getUser().field_70170_p.func_217299_a(new RayTraceContext(from, to = from.func_178787_e(this.getUser().func_70040_Z().func_186678_a(5.0)), RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this.getUser()));
        if (result.func_216346_c() == RayTraceResult.Type.BLOCK) {
            this.lookPos = result.func_216347_e();
        }
        this.spawnBoulderPos = result.func_216350_a();
        this.spawnBoulderBlock = this.getUser().field_70170_p.func_180495_p(this.spawnBoulderPos);
        if (result.func_216354_b() != Direction.UP && ((blockAbove = this.getUser().field_70170_p.func_180495_p(this.spawnBoulderPos.func_177984_a())).func_229980_m_((IBlockReader)this.getUser().field_70170_p, this.spawnBoulderPos.func_177984_a()) || blockAbove.isAir((IBlockReader)this.getUser().field_70170_p, this.spawnBoulderPos.func_177984_a()))) {
            return false;
        }
        return EffectGeomancy.isBlockDiggable(this.spawnBoulderBlock);
    }

    @Override
    public void tickUsing() {
        super.tickUsing();
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
            int size;
            EntityType type;
            ++this.spawnBoulderCharge;
            if (this.spawnBoulderCharge > 1) {
                this.getUser().func_195064_c(new EffectInstance(Effects.field_76421_d, 3, 3, false, false));
            }
            if (this.spawnBoulderCharge == 1 && this.getUser().field_70170_p.field_72995_K) {
                MowziesMobs.PROXY.playBoulderChargeSound(this.getUser());
            }
            if ((this.spawnBoulderCharge + 10) % 10 == 0 && this.spawnBoulderCharge < 40 && this.getUser().field_70170_p.field_72995_K) {
                AdvancedParticleBase.spawnParticle(this.getUser().field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)this.getUser().func_226277_ct_(), (float)this.getUser().func_226278_cu_() + this.getUser().func_213302_cg() / 2.0f, (float)this.getUser().func_226281_cx_(), 0.0, 0.0, 0.0, false, 0.0, 1.5707963267948966, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 10.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.0f, 0.7f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd((0.8f + 2.7f * (float)this.spawnBoulderCharge / 60.0f) * 10.0f, 0.0f), false)});
            }
            if (this.spawnBoulderCharge == 50) {
                if (this.getUser().field_70170_p.field_72995_K) {
                    AdvancedParticleBase.spawnParticle(this.getUser().field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.RING2.get()), (float)this.getUser().func_226277_ct_(), (float)this.getUser().func_226278_cu_() + this.getUser().func_213302_cg() / 2.0f, (float)this.getUser().func_226281_cx_(), 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 3.5, 0.83f, 1.0, 0.39f, 1.0, 1.0, 20.0, true, true, new ParticleComponent[]{new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, ParticleComponent.KeyTrack.startAndEnd(0.7f, 0.0f), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, ParticleComponent.KeyTrack.startAndEnd(0.0f, 40.0f), false)});
                }
                this.getUser().func_184185_a((SoundEvent)MMSounds.EFFECT_GEOMANCY_MAGIC_SMALL.get(), 1.0f, 1.0f);
            }
            if (!this.getUser().field_70170_p.func_226664_a_((type = (EntityType)EntityHandler.BOULDERS[size = this.getBoulderSize() + 1].get()).func_220328_a((double)((float)this.spawnBoulderPos.func_177958_n() + 0.5f), (double)(this.spawnBoulderPos.func_177956_o() + 2), (double)((float)this.spawnBoulderPos.func_177952_p() + 0.5f))) || this.getUser().func_70092_e((double)this.spawnBoulderPos.func_177958_n(), (double)this.spawnBoulderPos.func_177956_o(), (double)this.spawnBoulderPos.func_177952_p()) > 36.0) {
                this.nextSection();
            }
        }
    }

    @Override
    protected void beginSection(AbilitySection section) {
        if (section.sectionType == AbilitySection.AbilitySectionType.ACTIVE) {
            this.spawnBoulder();
        }
    }

    private int getBoulderSize() {
        return (int)Math.min(Math.max(0.0, Math.floor((float)this.spawnBoulderCharge / 10.0f) - 1.0), 2.0);
    }

    private void spawnBoulder() {
        if (this.spawnBoulderCharge <= 2) {
            this.playAnimation("spawn_boulder_instant", false);
        } else {
            this.playAnimation("spawn_boulder_end", false);
        }
        int size = this.getBoulderSize();
        if (this.spawnBoulderCharge >= 60) {
            size = 3;
        }
        EntityBoulder boulder = new EntityBoulder((EntityType<? extends EntityBoulder>)((EntityType)EntityHandler.BOULDERS[size].get()), this.getUser().field_70170_p, this.getUser(), this.spawnBoulderBlock, this.spawnBoulderPos);
        boulder.func_70107_b((float)this.spawnBoulderPos.func_177958_n() + 0.5f, this.spawnBoulderPos.func_177956_o() + 2, (float)this.spawnBoulderPos.func_177952_p() + 0.5f);
        if (!this.getUser().field_70170_p.field_72995_K && boulder.checkCanSpawn()) {
            this.getUser().field_70170_p.func_217376_c((Entity)boulder);
        }
        if (this.spawnBoulderCharge > 2) {
            Vector3d playerEyes = this.getUser().func_174824_e(1.0f);
            Vector3d vec = playerEyes.func_178788_d(this.lookPos).func_72432_b();
            float yaw = (float)Math.atan2(vec.field_72449_c, vec.field_72450_a);
            float pitch = (float)Math.asin(vec.field_72448_b);
            this.getUser().field_70177_z = (float)((double)(yaw * 180.0f) / Math.PI + 90.0);
            this.getUser().field_70125_A = (float)((double)(pitch * 180.0f) / Math.PI);
        }
        this.spawnBoulderCharge = 0;
    }

    @Override
    public void onRightMouseUp(PlayerEntity player) {
        super.onRightMouseUp(player);
        if (this.isUsing() && this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
            if (player.func_70092_e((double)this.spawnBoulderPos.func_177958_n(), (double)this.spawnBoulderPos.func_177956_o(), (double)this.spawnBoulderPos.func_177952_p()) < 36.0) {
                this.nextSection();
            } else {
                this.spawnBoulderCharge = 0;
            }
        }
    }

    @Override
    public boolean canUse() {
        return EffectGeomancy.canUse(this.getUser()) && super.canUse();
    }

    @Override
    public void end() {
        this.spawnBoulderCharge = 0;
        super.end();
    }

    @Override
    public void readNBT(INBT nbt) {
        super.readNBT(nbt);
        if (this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP) {
            this.spawnBoulderCharge = this.getTicksInSection();
        }
    }

    @Override
    public void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        super.onRightClickBlock(event);
        if (!event.getWorld().func_201670_d()) {
            AbilityHandler.INSTANCE.sendAbilityMessage(event.getEntityLiving(), AbilityHandler.SPAWN_BOULDER_ABILITY);
        }
    }

    @Override
    public void onRightClickEmpty(PlayerInteractEvent.RightClickEmpty event) {
        super.onRightClickEmpty(event);
        AbilityHandler.INSTANCE.sendPlayerTryAbilityMessage(event.getPlayer(), AbilityHandler.SPAWN_BOULDER_ABILITY);
    }

    @Override
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        super.onRenderTick(event);
        if (this.isUsing() && this.getCurrentSection().sectionType == AbilitySection.AbilitySectionType.STARTUP && this.getTicksInSection() > 1) {
            Vector3d playerEyes = this.getUser().func_174824_e(Minecraft.func_71410_x().func_184121_ak());
            Vector3d vec = playerEyes.func_178788_d(this.lookPos).func_72432_b();
            float yaw = (float)Math.atan2(vec.field_72449_c, vec.field_72450_a);
            float pitch = (float)Math.asin(vec.field_72448_b);
            this.getUser().field_70177_z = (float)((double)(yaw * 180.0f) / Math.PI + 90.0);
            this.getUser().field_70125_A = (float)((double)(pitch * 180.0f) / Math.PI);
            this.getUser().field_70759_as = this.getUser().field_70177_z;
            this.getUser().field_70126_B = this.getUser().field_70177_z;
            this.getUser().field_70127_C = this.getUser().field_70125_A;
            this.getUser().field_70758_at = this.getUser().field_70759_as;
        }
    }
}

