/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.capability;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoFirstPersonRenderer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.server.ability.Ability;
import com.bobmowzie.mowziesmobs.server.ability.AbilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.AbilityCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarakoanToPlayer;
import com.bobmowzie.mowziesmobs.server.item.ItemEarthTalisman;
import com.bobmowzie.mowziesmobs.server.item.ItemHandler;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageLeftMouseDown;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageLeftMouseUp;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageRightMouseDown;
import com.bobmowzie.mowziesmobs.server.message.mouse.MessageRightMouseUp;
import com.bobmowzie.mowziesmobs.server.potion.EffectHandler;
import com.bobmowzie.mowziesmobs.server.power.Power;
import com.bobmowzie.mowziesmobs.server.power.PowerGeomancy;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.fml.LogicalSide;

public class PlayerCapability {

    public static class PlayerProvider
    implements ICapabilitySerializable<INBT> {
        @CapabilityInject(value=IPlayerCapability.class)
        public static final Capability<IPlayerCapability> PLAYER_CAPABILITY = null;
        private final LazyOptional<IPlayerCapability> instance = LazyOptional.of(() -> PLAYER_CAPABILITY.getDefaultInstance());

        public INBT serializeNBT() {
            return PLAYER_CAPABILITY.getStorage().writeNBT(PLAYER_CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")), null);
        }

        public void deserializeNBT(INBT nbt) {
            PLAYER_CAPABILITY.getStorage().readNBT(PLAYER_CAPABILITY, this.instance.orElseThrow(() -> new IllegalArgumentException("Lazy optional must not be empty")), null, nbt);
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }
    }

    public static class PlayerStorage
    implements Capability.IStorage<IPlayerCapability> {
        public INBT writeNBT(Capability<IPlayerCapability> capability, IPlayerCapability instance, Direction side) {
            return instance.writeNBT();
        }

        public void readNBT(Capability<IPlayerCapability> capability, IPlayerCapability instance, Direction side, INBT nbt) {
            instance.readNBT(nbt);
        }
    }

    public static class PlayerCapabilityImp
    implements IPlayerCapability {
        public boolean verticalSwing = false;
        public int untilSunstrike = 0;
        public int untilAxeSwing = 0;
        private int prevTime;
        private int time;
        public boolean mouseRightDown = false;
        public boolean mouseLeftDown = false;
        public boolean prevSneaking;
        private float prevCooledAttackStrength;
        public int tribeCircleTick;
        public List<EntityBarakoanToPlayer> tribePack = new ArrayList<EntityBarakoanToPlayer>();
        public int tribePackRadius = 3;
        @OnlyIn(value=Dist.CLIENT)
        private GeckoPlayer.GeckoPlayerThirdPerson geckoPlayer;
        private boolean usingSolarBeam;
        public boolean axeCanAttack;
        public Vector3d prevMotion;
        public PowerGeomancy geomancy = new PowerGeomancy(this);
        public Power[] powers = new Power[]{this.geomancy};

        @Override
        public boolean isVerticalSwing() {
            return this.verticalSwing;
        }

        @Override
        public void setVerticalSwing(boolean verticalSwing) {
            this.verticalSwing = verticalSwing;
        }

        @Override
        public int getUntilSunstrike() {
            return this.untilSunstrike;
        }

        @Override
        public void setUntilSunstrike(int untilSunstrike) {
            this.untilSunstrike = untilSunstrike;
        }

        @Override
        public int getUntilAxeSwing() {
            return this.untilAxeSwing;
        }

        @Override
        public void setUntilAxeSwing(int untilAxeSwing) {
            this.untilAxeSwing = untilAxeSwing;
        }

        @Override
        public void setAxeCanAttack(boolean axeCanAttack) {
            this.axeCanAttack = axeCanAttack;
        }

        @Override
        public boolean getAxeCanAttack() {
            return this.axeCanAttack;
        }

        @Override
        public boolean isMouseRightDown() {
            return this.mouseRightDown;
        }

        @Override
        public void setMouseRightDown(boolean mouseRightDown) {
            this.mouseRightDown = mouseRightDown;
        }

        @Override
        public boolean isMouseLeftDown() {
            return this.mouseLeftDown;
        }

        @Override
        public void setMouseLeftDown(boolean mouseLeftDown) {
            this.mouseLeftDown = mouseLeftDown;
        }

        @Override
        public boolean isPrevSneaking() {
            return this.prevSneaking;
        }

        @Override
        public void setPrevSneaking(boolean prevSneaking) {
            this.prevSneaking = prevSneaking;
        }

        @Override
        public int getTribeCircleTick() {
            return this.tribeCircleTick;
        }

        @Override
        public void setTribeCircleTick(int tribeCircleTick) {
            this.tribeCircleTick = tribeCircleTick;
        }

        @Override
        public List<EntityBarakoanToPlayer> getTribePack() {
            return this.tribePack;
        }

        @Override
        public void setTribePack(List<EntityBarakoanToPlayer> tribePack) {
            this.tribePack = tribePack;
        }

        @Override
        public int getTribePackRadius() {
            return this.tribePackRadius;
        }

        @Override
        public void setTribePackRadius(int tribePackRadius) {
            this.tribePackRadius = tribePackRadius;
        }

        @Override
        public Vector3d getPrevMotion() {
            return this.prevMotion;
        }

        @Override
        public PowerGeomancy getGeomancy() {
            return this.geomancy;
        }

        @Override
        public void setUsingSolarBeam(boolean b) {
            this.usingSolarBeam = b;
        }

        @Override
        public boolean getUsingSolarBeam() {
            return this.usingSolarBeam;
        }

        @Override
        public float getPrevCooledAttackStrength() {
            return this.prevCooledAttackStrength;
        }

        @Override
        public void setPrevCooledAttackStrength(float cooledAttackStrength) {
            this.prevCooledAttackStrength = cooledAttackStrength;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public GeckoPlayer.GeckoPlayerThirdPerson getGeckoPlayer() {
            return this.geckoPlayer;
        }

        @Override
        public void addedToWorld(EntityJoinWorldEvent event) {
            if (event.getWorld().func_201670_d()) {
                PlayerEntity player = (PlayerEntity)event.getEntity();
                this.geckoPlayer = new GeckoPlayer.GeckoPlayerThirdPerson(player);
                if (event.getEntity() == Minecraft.func_71410_x().field_71439_g) {
                    GeckoFirstPersonRenderer.GECKO_PLAYER_FIRST_PERSON = new GeckoPlayer.GeckoPlayerFirstPerson(player);
                }
            }
        }

        @Override
        public void tick(TickEvent.PlayerTickEvent event) {
            Ability iceBreathAbility;
            PlayerEntity player = event.player;
            this.prevMotion = player.func_213303_ch().func_178788_d(new Vector3d(player.field_70169_q, player.field_70167_r, player.field_70166_s));
            this.prevTime = this.time;
            if (this.untilSunstrike > 0) {
                --this.untilSunstrike;
            }
            if (this.untilAxeSwing > 0) {
                --this.untilAxeSwing;
            }
            if (event.side == LogicalSide.SERVER) {
                for (ItemStack itemStack : event.player.field_71071_by.field_70462_a) {
                    if (!(itemStack.func_77973_b() instanceof ItemEarthTalisman)) continue;
                    player.func_195064_c(new EffectInstance((Effect)EffectHandler.GEOMANCY, 20, 0, false, false));
                }
                if (player.func_184592_cb().func_77973_b() instanceof ItemEarthTalisman) {
                    player.func_195064_c(new EffectInstance((Effect)EffectHandler.GEOMANCY, 20, 0, false, false));
                }
                List<EntityBarakoanToPlayer> pack = this.tribePack;
                float theta = (float)Math.PI * 2 / (float)pack.size();
                for (int i = 0; i < pack.size(); ++i) {
                    EntityBarakoanToPlayer barakoan = pack.get(i);
                    barakoan.index = i;
                    float distanceToPlayer = player.func_70032_d((Entity)barakoan);
                    if (barakoan.func_70638_az() != null || barakoan.getAnimation() == EntityBarakoanToPlayer.DEACTIVATE_ANIMATION) continue;
                    if (distanceToPlayer > 4.0f) {
                        barakoan.func_70661_as().func_75492_a(player.func_226277_ct_() + (double)((float)this.tribePackRadius * MathHelper.func_76134_b((float)(theta * (float)i))), player.func_226278_cu_(), player.func_226281_cx_() + (double)((float)this.tribePackRadius * MathHelper.func_76126_a((float)(theta * (float)i))), 0.45);
                    } else {
                        barakoan.func_70661_as().func_75499_g();
                    }
                    if (!(distanceToPlayer > 20.0f) || !player.func_233570_aj_()) continue;
                    this.tryTeleportBarakoan(player, barakoan);
                }
            }
            if ((iceBreathAbility = AbilityHandler.INSTANCE.getAbility((LivingEntity)player, AbilityHandler.ICE_BREATH_ABILITY)) != null && !iceBreathAbility.isUsing()) {
                for (ItemStack stack : player.field_71071_by.field_70462_a) {
                    this.restoreIceCrystalStack(player, stack);
                }
                for (ItemStack stack : player.field_71071_by.field_184439_c) {
                    this.restoreIceCrystalStack(player, stack);
                }
            }
            this.useIceCrystalStack(player);
            if (event.side == LogicalSide.CLIENT) {
                if (Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d() && !this.mouseLeftDown) {
                    this.mouseLeftDown = true;
                    MowziesMobs.NETWORK.sendToServer((Object)new MessageLeftMouseDown());
                    for (int i = 0; i < this.powers.length; ++i) {
                        this.powers[i].onLeftMouseDown(player);
                    }
                    AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
                    if (abilityCapability != null) {
                        for (Ability ability : abilityCapability.getAbilities()) {
                            ability.onLeftMouseDown(player);
                        }
                    }
                }
                if (Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && !this.mouseRightDown) {
                    this.mouseRightDown = true;
                    MowziesMobs.NETWORK.sendToServer((Object)new MessageRightMouseDown());
                    for (int i = 0; i < this.powers.length; ++i) {
                        this.powers[i].onRightMouseDown(player);
                    }
                    AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
                    if (abilityCapability != null) {
                        for (Ability ability : abilityCapability.getAbilities()) {
                            ability.onRightMouseDown(player);
                        }
                    }
                }
                if (!Minecraft.func_71410_x().field_71474_y.field_74312_F.func_151470_d() && this.mouseLeftDown) {
                    this.mouseLeftDown = false;
                    MowziesMobs.NETWORK.sendToServer((Object)new MessageLeftMouseUp());
                    for (int i = 0; i < this.powers.length; ++i) {
                        this.powers[i].onLeftMouseUp(player);
                    }
                    AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
                    if (abilityCapability != null) {
                        for (Ability ability : abilityCapability.getAbilities()) {
                            ability.onLeftMouseUp(player);
                        }
                    }
                }
                if (!Minecraft.func_71410_x().field_71474_y.field_74313_G.func_151470_d() && this.mouseRightDown) {
                    this.mouseRightDown = false;
                    MowziesMobs.NETWORK.sendToServer((Object)new MessageRightMouseUp());
                    for (int i = 0; i < this.powers.length; ++i) {
                        this.powers[i].onRightMouseUp(player);
                    }
                    AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
                    if (abilityCapability != null) {
                        for (Ability ability : abilityCapability.getAbilities()) {
                            ability.onRightMouseUp(player);
                        }
                    }
                }
            }
            if (player.func_225608_bj_() && !this.prevSneaking) {
                for (int i = 0; i < this.powers.length; ++i) {
                    this.powers[i].onSneakDown(player);
                }
                AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
                if (abilityCapability != null) {
                    for (Ability ability : abilityCapability.getAbilities()) {
                        ability.onSneakDown(player);
                    }
                }
            } else if (!player.func_225608_bj_() && this.prevSneaking) {
                for (int i = 0; i < this.powers.length; ++i) {
                    this.powers[i].onSneakUp(player);
                }
                AbilityCapability.IAbilityCapability abilityCapability = AbilityHandler.INSTANCE.getAbilityCapability((LivingEntity)player);
                if (abilityCapability != null) {
                    for (Ability ability : abilityCapability.getAbilities()) {
                        ability.onSneakUp(player);
                    }
                }
            }
            this.prevSneaking = player.func_225608_bj_();
        }

        private void restoreIceCrystalStack(PlayerEntity entity, ItemStack stack) {
            if (stack.func_77973_b() == ItemHandler.ICE_CRYSTAL && !((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.ICE_CRYSTAL.breakable.get()).booleanValue()) {
                stack.func_196085_b(Math.max(stack.func_77952_i() - 1, 0));
            }
        }

        private void useIceCrystalStack(PlayerEntity player) {
            Ability iceBreathAbility;
            ItemStack stack = player.func_184607_cu();
            if (stack.func_77973_b() == ItemHandler.ICE_CRYSTAL && (iceBreathAbility = AbilityHandler.INSTANCE.getAbility((LivingEntity)player, AbilityHandler.ICE_BREATH_ABILITY)) != null && iceBreathAbility.isUsing()) {
                Hand handIn = player.func_184600_cs();
                if (stack.func_77952_i() + 5 < stack.func_77958_k()) {
                    stack.func_222118_a(5, (LivingEntity)player, p -> p.func_213334_d(handIn));
                } else {
                    if (((Boolean)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.ICE_CRYSTAL.breakable.get()).booleanValue()) {
                        stack.func_222118_a(5, (LivingEntity)player, p -> p.func_213334_d(handIn));
                    }
                    iceBreathAbility.end();
                }
            }
        }

        private void tryTeleportBarakoan(PlayerEntity player, EntityBarakoanToPlayer barakoan) {
            int x = MathHelper.func_76128_c((double)player.func_226277_ct_()) - 2;
            int z = MathHelper.func_76128_c((double)player.func_226281_cx_()) - 2;
            int y = MathHelper.func_76128_c((double)player.func_174813_aQ().field_72338_b);
            for (int l = 0; l <= 4; ++l) {
                for (int i1 = 0; i1 <= 4; ++i1) {
                    if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !barakoan.isTeleportFriendlyBlock(x, z, y, l, i1)) continue;
                    barakoan.func_70012_b((float)(x + l) + 0.5f, y, (float)(z + i1) + 0.5f, barakoan.field_70177_z, barakoan.field_70125_A);
                    barakoan.func_70661_as().func_75499_g();
                    return;
                }
            }
        }

        public int getTick() {
            return this.time;
        }

        public void decrementTime() {
            --this.time;
        }

        @Override
        public int getPackSize() {
            return this.tribePack.size();
        }

        @Override
        public void removePackMember(EntityBarakoanToPlayer tribePlayer) {
            this.tribePack.remove(tribePlayer);
        }

        @Override
        public void addPackMember(EntityBarakoanToPlayer tribePlayer) {
            this.tribePack.add(tribePlayer);
        }

        @Override
        public Power[] getPowers() {
            return this.powers;
        }

        @Override
        public INBT writeNBT() {
            CompoundNBT compound = new CompoundNBT();
            compound.func_74768_a("untilSunstrike", this.untilSunstrike);
            compound.func_74768_a("untilAxeSwing", this.untilAxeSwing);
            compound.func_74768_a("prevTime", this.prevTime);
            compound.func_74768_a("time", this.time);
            return compound;
        }

        @Override
        public void readNBT(INBT nbt) {
            CompoundNBT compound = (CompoundNBT)nbt;
            this.untilSunstrike = compound.func_74762_e("untilSunstrike");
            this.untilAxeSwing = compound.func_74762_e("untilAxeSwing");
            this.prevTime = compound.func_74762_e("prevTime");
            this.time = compound.func_74762_e("time");
        }
    }

    public static interface IPlayerCapability {
        public INBT writeNBT();

        public void readNBT(INBT var1);

        public Power[] getPowers();

        public void tick(TickEvent.PlayerTickEvent var1);

        public void addedToWorld(EntityJoinWorldEvent var1);

        public boolean isVerticalSwing();

        public void setVerticalSwing(boolean var1);

        public int getUntilSunstrike();

        public void setUntilSunstrike(int var1);

        public int getUntilAxeSwing();

        public void setUntilAxeSwing(int var1);

        public void setAxeCanAttack(boolean var1);

        public boolean getAxeCanAttack();

        public boolean isMouseRightDown();

        public void setMouseRightDown(boolean var1);

        public boolean isMouseLeftDown();

        public void setMouseLeftDown(boolean var1);

        public boolean isPrevSneaking();

        public void setPrevSneaking(boolean var1);

        public int getTribeCircleTick();

        public void setTribeCircleTick(int var1);

        public List<EntityBarakoanToPlayer> getTribePack();

        public void setTribePack(List<EntityBarakoanToPlayer> var1);

        public int getTribePackRadius();

        public void setTribePackRadius(int var1);

        public int getPackSize();

        public Vector3d getPrevMotion();

        public void removePackMember(EntityBarakoanToPlayer var1);

        public void addPackMember(EntityBarakoanToPlayer var1);

        public PowerGeomancy getGeomancy();

        public void setUsingSolarBeam(boolean var1);

        public boolean getUsingSolarBeam();

        public float getPrevCooledAttackStrength();

        public void setPrevCooledAttackStrength(float var1);

        @OnlyIn(value=Dist.CLIENT)
        public GeckoPlayer.GeckoPlayerThirdPerson getGeckoPlayer();
    }
}

