/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.effects;

import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.particle.ParticleHandler;
import com.bobmowzie.mowziesmobs.client.particle.ParticleOrb;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleBase;
import com.bobmowzie.mowziesmobs.client.particle.util.AdvancedParticleData;
import com.bobmowzie.mowziesmobs.client.particle.util.ParticleComponent;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoPlayer;
import com.bobmowzie.mowziesmobs.client.render.entity.player.GeckoRenderPlayer;
import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.PlayerCapability;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.damage.DamageUtil;
import com.bobmowzie.mowziesmobs.server.entity.LeaderSunstrikeImmune;
import com.bobmowzie.mowziesmobs.server.entity.barakoa.EntityBarako;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.PointOfView;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkHooks;

public class EntitySolarBeam
extends Entity {
    public static final double RADIUS_BARAKO = 30.0;
    public static final double RADIUS_PLAYER = 20.0;
    public LivingEntity caster;
    public double endPosX;
    public double endPosY;
    public double endPosZ;
    public double collidePosX;
    public double collidePosY;
    public double collidePosZ;
    public double prevCollidePosX;
    public double prevCollidePosY;
    public double prevCollidePosZ;
    public float renderYaw;
    public float renderPitch;
    public ControlledAnimation appear = new ControlledAnimation(3);
    public boolean on = true;
    public Direction blockSide = null;
    private static final DataParameter<Float> YAW = EntityDataManager.func_187226_a(EntitySolarBeam.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> PITCH = EntityDataManager.func_187226_a(EntitySolarBeam.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> DURATION = EntityDataManager.func_187226_a(EntitySolarBeam.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> HAS_PLAYER = EntityDataManager.func_187226_a(EntitySolarBeam.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CASTER = EntityDataManager.func_187226_a(EntitySolarBeam.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float prevYaw;
    public float prevPitch;
    @OnlyIn(value=Dist.CLIENT)
    private Vector3d[] attractorPos;

    public EntitySolarBeam(EntityType<? extends EntitySolarBeam> type, World world) {
        super(type, world);
        this.field_70158_ak = true;
        if (world.field_72995_K) {
            this.attractorPos = new Vector3d[]{new Vector3d(0.0, 0.0, 0.0)};
        }
    }

    public EntitySolarBeam(EntityType<? extends EntitySolarBeam> type, World world, LivingEntity caster, double x, double y, double z, float yaw, float pitch, int duration) {
        this(type, world);
        this.caster = caster;
        this.setYaw(yaw);
        this.setPitch(pitch);
        this.setDuration(duration);
        this.func_70107_b(x, y, z);
        this.calculateEndPos();
        this.func_184185_a((SoundEvent)MMSounds.LASER.get(), 2.0f, 1.0f);
        if (!world.field_72995_K) {
            this.setCasterID(caster.func_145782_y());
        }
    }

    public PushReaction func_184192_z() {
        return PushReaction.IGNORE;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevCollidePosX = this.collidePosX;
        this.prevCollidePosY = this.collidePosY;
        this.prevCollidePosZ = this.collidePosZ;
        this.prevYaw = this.renderYaw;
        this.prevPitch = this.renderPitch;
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (this.field_70173_aa == 1 && this.field_70170_p.field_72995_K) {
            this.caster = (LivingEntity)this.field_70170_p.func_73045_a(this.getCasterID());
        }
        if (this.getHasPlayer() && !this.field_70170_p.field_72995_K) {
            this.updateWithPlayer();
        }
        if (this.caster != null) {
            this.renderYaw = (float)(((double)this.caster.field_70759_as + 90.0) * Math.PI / 180.0);
            this.renderPitch = (float)((double)(-this.caster.field_70125_A) * Math.PI / 180.0);
        }
        if (!this.on && this.appear.getTimer() == 0) {
            this.func_70106_y();
        }
        if (this.on && this.field_70173_aa > 20) {
            this.appear.increaseTimer();
        } else {
            this.appear.decreaseTimer();
        }
        if (this.caster != null && !this.caster.func_70089_S()) {
            this.func_70106_y();
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa <= 10 && this.caster != null) {
            int particleCount = 8;
            while (--particleCount != 0) {
                GeckoPlayer geckoPlayer;
                double radius = 2.0f * this.caster.func_213311_cf();
                double yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                double pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                double ox = radius * Math.sin(yaw) * Math.sin(pitch);
                double oy = radius * Math.cos(pitch);
                double oz = radius * Math.cos(yaw) * Math.sin(pitch);
                double rootX = this.caster.func_226277_ct_();
                double rootY = this.caster.func_226278_cu_() + (double)(this.caster.func_213302_cg() / 2.0f) + (double)0.3f;
                double rootZ = this.caster.func_226281_cx_();
                if (this.getHasPlayer() && this.caster instanceof PlayerEntity && (this.caster != Minecraft.func_71410_x().field_71439_g || Minecraft.func_71410_x().field_71474_y.func_243230_g() != PointOfView.FIRST_PERSON) && (geckoPlayer = GeckoPlayer.getGeckoPlayer((PlayerEntity)this.caster, GeckoPlayer.Perspective.THIRD_PERSON)) != null) {
                    GeckoRenderPlayer renderPlayer = (GeckoRenderPlayer)geckoPlayer.getPlayerRenderer();
                    if (renderPlayer.betweenHandsPos != null) {
                        rootX += renderPlayer.betweenHandsPos.func_82615_a();
                        rootY += renderPlayer.betweenHandsPos.func_82617_b();
                        rootZ += renderPlayer.betweenHandsPos.func_82616_c();
                    }
                }
                this.attractorPos[0] = new Vector3d(rootX, rootY, rootZ);
                AdvancedParticleBase.spawnParticle(this.field_70170_p, (ParticleType<AdvancedParticleData>)((ParticleType)ParticleHandler.ORB2.get()), rootX + ox, rootY + oy, rootZ + oz, 0.0, 0.0, 0.0, true, 0.0, 0.0, 0.0, 0.0, 5.0, 1.0, 1.0, 1.0, 1.0, 1.0, 7.0, true, false, new ParticleComponent[]{new ParticleComponent.Attractor(this.attractorPos, 1.7f, 0.0f, ParticleComponent.Attractor.EnumAttractorBehavior.EXPONENTIAL), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.ALPHA, new ParticleComponent.KeyTrack(new float[]{0.0f, 0.8f}, new float[]{0.0f, 1.0f}), false), new ParticleComponent.PropertyControl(ParticleComponent.PropertyControl.EnumParticleProperty.SCALE, new ParticleComponent.KeyTrack(new float[]{3.0f, 6.0f}, new float[]{0.0f, 1.0f}), false)});
            }
        }
        if (this.field_70173_aa > 20) {
            this.calculateEndPos();
            List hit = this.raytraceEntities(this.field_70170_p, new Vector3d(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_()), new Vector3d(this.endPosX, this.endPosY, this.endPosZ), false, true, true).entities;
            if (this.blockSide != null) {
                this.spawnExplosionParticles(2);
            }
            if (!this.field_70170_p.field_72995_K) {
                for (LivingEntity target : hit) {
                    if (this.caster instanceof EntityBarako && target instanceof LeaderSunstrikeImmune) continue;
                    float damageFire = 1.0f;
                    float damageMob = 1.5f;
                    if (this.caster instanceof EntityBarako) {
                        damageFire = (float)((double)damageFire * (Double)ConfigHandler.COMMON.MOBS.BARAKO.combatConfig.attackMultiplier.get());
                        damageMob = (float)((double)damageMob * (Double)ConfigHandler.COMMON.MOBS.BARAKO.combatConfig.attackMultiplier.get());
                    }
                    if (this.caster instanceof PlayerEntity) {
                        damageFire = (float)((double)damageFire * (Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.sunsBlessingAttackMultiplier.get());
                        damageMob = (float)((double)damageMob * (Double)ConfigHandler.COMMON.TOOLS_AND_ABILITIES.SUNS_BLESSING.sunsBlessingAttackMultiplier.get());
                    }
                    DamageUtil.dealMixedDamage(target, DamageSource.func_188403_a((Entity)this, (LivingEntity)this.caster), damageMob, DamageSource.field_76370_b, damageFire);
                }
            } else if (this.field_70173_aa - 15 < this.getDuration()) {
                double o2z;
                double o2y;
                double o2x;
                double oz;
                double oy;
                double ox;
                double pitch;
                double yaw;
                double radius;
                int particleCount = 4;
                while (particleCount-- > 0) {
                    radius = 1.0;
                    yaw = (float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI);
                    pitch = (float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI);
                    ox = (float)(radius * Math.sin(yaw) * Math.sin(pitch));
                    oy = (float)(radius * Math.cos(pitch));
                    oz = (float)(radius * Math.cos(yaw) * Math.sin(pitch));
                    o2x = (float)(-1.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch()));
                    o2y = (float)(-1.0 * Math.sin(this.getPitch()));
                    o2z = (float)(-1.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch()));
                    this.field_70170_p.func_195594_a((IParticleData)new ParticleOrb.OrbData((float)(this.collidePosX + o2x + ox), (float)(this.collidePosY + o2y + oy), (float)(this.collidePosZ + o2z + oz), 15.0f), this.func_226277_ct_() + o2x + ox, this.func_226278_cu_() + o2y + oy, this.func_226281_cx_() + o2z + oz, 0.0, 0.0, 0.0);
                }
                particleCount = 4;
                while (particleCount-- > 0) {
                    radius = 2.0;
                    yaw = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    pitch = (double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI;
                    ox = radius * Math.sin(yaw) * Math.sin(pitch);
                    oy = radius * Math.cos(pitch);
                    oz = radius * Math.cos(yaw) * Math.sin(pitch);
                    o2x = -1.0 * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
                    o2y = -1.0 * Math.sin(this.getPitch());
                    o2z = -1.0 * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
                    this.field_70170_p.func_195594_a((IParticleData)new ParticleOrb.OrbData((float)(this.collidePosX + o2x + ox), (float)(this.collidePosY + o2y + oy), (float)(this.collidePosZ + o2z + oz), 20.0f), this.collidePosX + o2x, this.collidePosY + o2y, this.collidePosZ + o2z, 0.0, 0.0, 0.0);
                }
            }
        }
        if (this.field_70173_aa - 20 > this.getDuration()) {
            this.on = false;
        }
    }

    private void spawnExplosionParticles(int amount) {
        int i;
        for (i = 0; i < amount; ++i) {
            float velocity = 0.1f;
            float yaw = (float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI);
            float motionY = this.field_70146_Z.nextFloat() * 0.08f;
            float motionX = 0.1f * MathHelper.func_76134_b((float)yaw);
            float motionZ = 0.1f * MathHelper.func_76126_a((float)yaw);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, (double)motionX, (double)motionY, (double)motionZ);
        }
        for (i = 0; i < amount / 2; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197595_F, this.collidePosX, this.collidePosY + 0.1, this.collidePosZ, 0.0, 0.0, 0.0);
        }
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(YAW, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(PITCH, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(DURATION, (Object)0);
        this.func_184212_Q().func_187214_a(HAS_PLAYER, (Object)false);
        this.func_184212_Q().func_187214_a(CASTER, (Object)-1);
    }

    public float getYaw() {
        return ((Float)this.func_184212_Q().func_187225_a(YAW)).floatValue();
    }

    public void setYaw(float yaw) {
        this.func_184212_Q().func_187227_b(YAW, (Object)Float.valueOf(yaw));
    }

    public float getPitch() {
        return ((Float)this.func_184212_Q().func_187225_a(PITCH)).floatValue();
    }

    public void setPitch(float pitch) {
        this.func_184212_Q().func_187227_b(PITCH, (Object)Float.valueOf(pitch));
    }

    public int getDuration() {
        return (Integer)this.func_184212_Q().func_187225_a(DURATION);
    }

    public void setDuration(int duration) {
        this.func_184212_Q().func_187227_b(DURATION, (Object)duration);
    }

    public boolean getHasPlayer() {
        return (Boolean)this.func_184212_Q().func_187225_a(HAS_PLAYER);
    }

    public void setHasPlayer(boolean player) {
        this.func_184212_Q().func_187227_b(HAS_PLAYER, (Object)player);
    }

    public int getCasterID() {
        return (Integer)this.func_184212_Q().func_187225_a(CASTER);
    }

    public void setCasterID(int id) {
        this.func_184212_Q().func_187227_b(CASTER, (Object)id);
    }

    protected void func_70037_a(CompoundNBT nbt) {
    }

    protected void func_213281_b(CompoundNBT nbt) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private void calculateEndPos() {
        double radius;
        double d = radius = this.caster instanceof EntityBarako ? 30.0 : 20.0;
        if (this.field_70170_p.func_201670_d()) {
            this.endPosX = this.func_226277_ct_() + radius * Math.cos(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosZ = this.func_226281_cx_() + radius * Math.sin(this.renderYaw) * Math.cos(this.renderPitch);
            this.endPosY = this.func_226278_cu_() + radius * Math.sin(this.renderPitch);
        } else {
            this.endPosX = this.func_226277_ct_() + radius * Math.cos(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosZ = this.func_226281_cx_() + radius * Math.sin(this.getYaw()) * Math.cos(this.getPitch());
            this.endPosY = this.func_226278_cu_() + radius * Math.sin(this.getPitch());
        }
    }

    public HitResult raytraceEntities(World world, Vector3d from, Vector3d to, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        HitResult result = new HitResult();
        result.setBlockHit((RayTraceResult)world.func_217299_a(new RayTraceContext(from, to, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)));
        if (result.blockHit != null) {
            Vector3d hitVec = result.blockHit.func_216347_e();
            this.collidePosX = hitVec.field_72450_a;
            this.collidePosY = hitVec.field_72448_b;
            this.collidePosZ = hitVec.field_72449_c;
            this.blockSide = result.blockHit.func_216354_b();
        } else {
            this.collidePosX = this.endPosX;
            this.collidePosY = this.endPosY;
            this.collidePosZ = this.endPosZ;
            this.blockSide = null;
        }
        List entities = world.func_217357_a(LivingEntity.class, new AxisAlignedBB(Math.min(this.func_226277_ct_(), this.collidePosX), Math.min(this.func_226278_cu_(), this.collidePosY), Math.min(this.func_226281_cx_(), this.collidePosZ), Math.max(this.func_226277_ct_(), this.collidePosX), Math.max(this.func_226278_cu_(), this.collidePosY), Math.max(this.func_226281_cx_(), this.collidePosZ)).func_72314_b(1.0, 1.0, 1.0));
        for (LivingEntity entity : entities) {
            if (entity == this.caster) continue;
            float pad = entity.func_70111_Y() + 0.5f;
            AxisAlignedBB aabb = entity.func_174813_aQ().func_72314_b((double)pad, (double)pad, (double)pad);
            Optional hit = aabb.func_216365_b(from, to);
            if (aabb.func_72318_a(from)) {
                result.addEntityHit(entity);
                continue;
            }
            if (!hit.isPresent()) continue;
            result.addEntityHit(entity);
        }
        return result;
    }

    public void func_70108_f(Entity entityIn) {
    }

    public boolean func_70067_L() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public boolean func_70112_a(double distance) {
        return distance < 1024.0;
    }

    private void updateWithPlayer() {
        this.setYaw((float)((double)(this.caster.field_70759_as + 90.0f) * Math.PI / 180.0));
        this.setPitch((float)((double)(-this.caster.field_70125_A) * Math.PI / 180.0));
        Vector3d vecOffset = this.caster.func_70040_Z().func_72432_b().func_186678_a(1.0);
        this.func_70107_b(this.caster.func_226277_ct_() + vecOffset.func_82615_a(), this.caster.func_226278_cu_() + (double)1.2f + vecOffset.func_82617_b(), this.caster.func_226281_cx_() + vecOffset.func_82616_c());
    }

    public void func_70106_y() {
        PlayerCapability.IPlayerCapability playerCapability;
        super.func_70106_y();
        if (this.caster instanceof PlayerEntity && (playerCapability = CapabilityHandler.getCapability((Entity)this.caster, PlayerCapability.PlayerProvider.PLAYER_CAPABILITY)) != null) {
            playerCapability.setUsingSolarBeam(false);
        }
    }

    public static class HitResult {
        private BlockRayTraceResult blockHit;
        private final List<LivingEntity> entities = new ArrayList<LivingEntity>();

        public BlockRayTraceResult getBlockHit() {
            return this.blockHit;
        }

        public void setBlockHit(RayTraceResult rayTraceResult) {
            if (rayTraceResult.func_216346_c() == RayTraceResult.Type.BLOCK) {
                this.blockHit = (BlockRayTraceResult)rayTraceResult;
            }
        }

        public void addEntityHit(LivingEntity entity) {
            this.entities.add(entity);
        }
    }
}

