/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.entity.naga;

import com.bobmowzie.mowziesmobs.MowziesMobs;
import com.bobmowzie.mowziesmobs.client.model.tools.ControlledAnimation;
import com.bobmowzie.mowziesmobs.client.model.tools.dynamics.DynamicChain;
import com.bobmowzie.mowziesmobs.client.particle.ParticleVanillaCloudExtended;
import com.bobmowzie.mowziesmobs.server.ai.animation.AnimationProjectileAttackAI;
import com.bobmowzie.mowziesmobs.server.ai.animation.SimpleAnimationAI;
import com.bobmowzie.mowziesmobs.server.config.ConfigHandler;
import com.bobmowzie.mowziesmobs.server.entity.EntityHandler;
import com.bobmowzie.mowziesmobs.server.entity.MowzieEntity;
import com.bobmowzie.mowziesmobs.server.entity.effects.EntityPoisonBall;
import com.bobmowzie.mowziesmobs.server.loot.LootTableHandler;
import com.bobmowzie.mowziesmobs.server.sound.MMSounds;
import com.bobmowzie.mowziesmobs.server.util.MowzieMathUtil;
import com.google.common.base.Supplier;
import com.ilexiconn.llibrary.server.animation.Animation;
import com.ilexiconn.llibrary.server.animation.AnimationHandler;
import com.ilexiconn.llibrary.server.animation.IAnimatedEntity;
import java.util.EnumSet;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.controller.LookController;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.FlyingPathNavigator;
import net.minecraft.pathfinding.PathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.potion.Effects;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;

public class EntityNaga
extends MowzieEntity
implements IRangedAttackMob,
IMob,
IFlyingAnimal {
    @OnlyIn(value=Dist.CLIENT)
    public DynamicChain dc;
    @OnlyIn(value=Dist.CLIENT)
    public Vector3d[] mouthPos;
    public static final Animation FLAP_ANIMATION = Animation.create(25);
    public static final Animation DODGE_ANIMATION = Animation.create(10);
    public static final Animation SPIT_ANIMATION = Animation.create(50);
    public static final Animation SWOOP_ANIMATION = Animation.create(54);
    public static final Animation HURT_TO_FALL_ANIMATION = Animation.create(20);
    public static final Animation LAND_ANIMATION = Animation.create(8);
    public static final Animation GET_UP_ANIMATION = Animation.create(33);
    public static final Animation TAIL_DEMO_ANIMATION = Animation.create(80);
    public static final Animation DIE_AIR_ANIMATION = Animation.create(70);
    public static final Animation DIE_GROUND_ANIMATION = Animation.create(70);
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(EntityNaga.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> BANKING = EntityDataManager.func_187226_a(EntityNaga.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> PREV_BANKING = EntityDataManager.func_187226_a(EntityNaga.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static int MAX_DIST_FROM_HOME = 50;
    private final ControlledAnimation hoverAnim = new ControlledAnimation(10);
    private final ControlledAnimation flapAnim = new ControlledAnimation(10);
    public float hoverAnimFrac;
    public float prevHoverAnimFrac;
    public float flapAnimFrac;
    public float prevFlapAnimFrac;
    private boolean hasFlapSoundPlayed = false;
    @OnlyIn(value=Dist.CLIENT)
    public float shoulderRot;
    @OnlyIn(value=Dist.CLIENT)
    public float banking;
    @OnlyIn(value=Dist.CLIENT)
    public float prevBanking;
    public static final int ROAR_DURATION = 30;
    public int roarAnimation = 0;
    public EnumNagaMovement movement = EnumNagaMovement.GLIDING;
    public double prevMotionX;
    public double prevMotionY;
    public double prevMotionZ;
    public static int SPIT_COOLDOWN_MAX = 120;
    public int spitCooldown = 0;
    public static int SWOOP_COOLDOWN_MAX = 90;
    public int swoopCooldown = 0;
    public float swoopTargetCorrectY;
    public float swoopTargetCorrectX;
    public static int GROUND_TIMER_MAX = 60;
    public int onGroundTimer = 0;
    public boolean interrupted = false;

    public EntityNaga(EntityType<? extends EntityNaga> type, World world) {
        super(type, world);
        if (world.field_72995_K) {
            this.dc = new DynamicChain((Entity)this);
            this.mouthPos = new Vector3d[]{new Vector3d(0.0, 0.0, 0.0)};
        }
        this.field_70728_aV = 10;
        this.field_70765_h = new NagaMoveHelper(this);
        this.field_70749_g = new NagaLookController((MobEntity)this);
        this.func_184644_a(PathNodeType.DANGER_FIRE, -1.0f);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.WATER_BORDER, -1.0f);
        this.func_184644_a(PathNodeType.FENCE, -1.0f);
        this.func_184644_a(PathNodeType.WALKABLE, -1.0f);
    }

    public float func_205022_a(BlockPos pos, IWorldReader worldIn) {
        return worldIn.func_180495_p(pos).func_196958_f() ? 10.0f : 0.0f;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new FlyOutOfWaterGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new WanderGoal());
        this.field_70714_bg.func_75776_a(4, (Goal)new AIFlyAroundTarget(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AIFlyTowardsTarget(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal<PlayerEntity>((MobEntity)this, PlayerEntity.class, 0, true, true, target -> target.func_233580_cy_().func_218141_a((Vector3i)this.func_213384_dI(), (double)this.func_213391_dJ())){

            public boolean func_75253_b() {
                return super.func_75253_b() && EntityNaga.this.func_70638_az() != null && EntityNaga.this.func_70638_az().func_233580_cy_().func_218141_a((Vector3i)EntityNaga.this.func_213384_dI(), (double)EntityNaga.this.func_213391_dJ()) && EntityNaga.this.getAnimation() == IAnimatedEntity.NO_ANIMATION;
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, FLAP_ANIMATION, false){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), 2.0f, (float)(0.85 + (double)EntityNaga.this.field_70146_Z.nextFloat() * 0.2));
            }

            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.getAnimationTick() >= 4 && EntityNaga.this.getAnimationTick() <= 9) {
                    EntityNaga.this.func_213317_d(EntityNaga.this.func_213322_ci().func_72441_c(0.0, 0.1, 0.0));
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityNaga>(this, DODGE_ANIMATION, false));
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimationProjectileAttackAI<EntityNaga>(this, SPIT_ANIMATION, 30, null){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_ACID_CHARGE.get(), 2.0f, 1.0f);
            }

            @Override
            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.interrupted) {
                    return;
                }
                if (EntityNaga.this.getAnimationTick() < 9) {
                    EntityNaga.this.func_213317_d(EntityNaga.this.func_213322_ci().func_72441_c(0.0, 0.015, 0.0));
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, SWOOP_ANIMATION, true){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), 2.0f, 0.7f);
            }

            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.interrupted) {
                    return;
                }
                Vector3d v = new Vector3d(0.0, 0.0, 0.0);
                int phase1Length = 15;
                int phase2Length = 21;
                LivingEntity target = EntityNaga.this.func_70638_az();
                if (EntityNaga.this.getAnimationTick() < phase1Length && target != null) {
                    ((EntityNaga)this.entity).func_70625_a((Entity)target, 100.0f, 100.0f);
                    ((EntityNaga)this.entity).field_70749_g.func_75651_a((Entity)target, 30.0f, 30.0f);
                }
                if (EntityNaga.this.getAnimationTick() < 23 + phase2Length) {
                    if (EntityNaga.this.getAnimationTick() >= 1 && EntityNaga.this.getAnimationTick() < 1 + phase1Length) {
                        float frame = (float)(EntityNaga.this.getAnimationTick() - 1) / (float)phase1Length;
                        v = v.func_178787_e(new Vector3d((double)1.9f * Math.sin((double)frame * Math.PI * 2.0) * (double)frame, (double)-1.9f * Math.sin((double)frame * Math.PI * 2.0) * (double)frame, (double)0.8f * Math.sin((double)frame * Math.PI * 2.0)));
                    } else if (EntityNaga.this.getAnimationTick() >= 16) {
                        if (EntityNaga.this.getAnimationTick() == 23) {
                            if (target != null) {
                                EntityNaga.this.swoopTargetCorrectY = 0.09f * (float)Math.abs(EntityNaga.this.func_226278_cu_() - target.func_226278_cu_());
                                EntityNaga.this.swoopTargetCorrectX = 0.1f * (float)Math.sqrt((EntityNaga.this.func_226277_ct_() - target.func_226277_ct_()) * (EntityNaga.this.func_226277_ct_() - target.func_226277_ct_()) + (EntityNaga.this.func_226281_cx_() - target.func_226281_cx_()) * (EntityNaga.this.func_226281_cx_() - target.func_226281_cx_()));
                                if (EntityNaga.this.swoopTargetCorrectX > 1.8f) {
                                    EntityNaga.this.swoopTargetCorrectX = 1.8f;
                                }
                                if (EntityNaga.this.swoopTargetCorrectY > 2.0f) {
                                    EntityNaga.this.swoopTargetCorrectY = 2.0f;
                                }
                            } else {
                                EntityNaga.this.swoopTargetCorrectY = 1.0f;
                                EntityNaga.this.swoopTargetCorrectX = 1.0f;
                            }
                        }
                        if (EntityNaga.this.getAnimationTick() >= 23 && EntityNaga.this.getAnimationTick() < 23 + phase2Length) {
                            float frame = (float)(EntityNaga.this.getAnimationTick() - 23) / (float)phase2Length;
                            v = v.func_178787_e(new Vector3d((double)EntityNaga.this.swoopTargetCorrectX * 1.4 * (1.0 - Math.exp(2.0f * (frame - 1.0f))), (double)EntityNaga.this.swoopTargetCorrectY * -1.5 * (Math.cos((double)frame * Math.PI) * (1.0 - Math.exp(7.0f * (frame - 1.0f)))), 0.0));
                            List<LivingEntity> entitiesHit = EntityNaga.this.getEntityLivingBaseNearby(4.0, 4.0, 4.0, 4.0);
                            for (LivingEntity entityHit : entitiesHit) {
                                if (entityHit instanceof EntityNaga) continue;
                                EntityNaga.this.func_70652_k((Entity)entityHit);
                            }
                        }
                    }
                    v = v.func_178785_b((float)Math.toRadians(-EntityNaga.this.field_70177_z - 90.0f));
                    EntityNaga.this.func_213293_j(v.field_72450_a, v.field_72448_b, v.field_72449_c);
                }
                if (EntityNaga.this.getAnimationTick() == 22) {
                    MowziesMobs.PROXY.playNagaSwoopSound((EntityNaga)this.entity);
                }
                if (EntityNaga.this.getAnimationTick() == 7) {
                    EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_GRUNT_3.get(), 2.0f, 1.0f);
                }
                if (EntityNaga.this.getAnimationTick() == 22) {
                    EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_ROAR_1.get(), 3.0f, 1.0f);
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, HURT_TO_FALL_ANIMATION, true){

            public void func_75246_d() {
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new SimpleAnimationAI<EntityNaga>(this, LAND_ANIMATION, true){

            @Override
            public void func_75249_e() {
                super.func_75249_e();
                EntityNaga.this.func_184185_a((SoundEvent)MMSounds.MISC_GROUNDHIT_2.get(), 1.5f, 1.0f);
            }
        });
        this.field_70714_bg.func_75776_a(1, (Goal)new SimpleAnimationAI<EntityNaga>(this, GET_UP_ANIMATION, true){

            public void func_75246_d() {
                super.func_75246_d();
                if (EntityNaga.this.getAnimationTick() == 13) {
                    EntityNaga.this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), 2.0f, 1.0f);
                }
                if (EntityNaga.this.getAnimationTick() == 15) {
                    EntityNaga.this.func_213317_d(EntityNaga.this.func_213322_ci().func_72441_c(0.0, 1.6, 0.0));
                }
            }
        });
        this.field_70714_bg.func_75776_a(2, new SimpleAnimationAI<EntityNaga>(this, TAIL_DEMO_ANIMATION, false));
    }

    protected PathNavigator func_175447_b(World worldIn) {
        FlyingPathNavigator flyingpathnavigator = new FlyingPathNavigator((MobEntity)this, worldIn){

            public boolean func_188555_b(BlockPos pos) {
                return !this.field_75513_b.func_180495_p(pos.func_177977_b()).func_196958_f();
            }
        };
        flyingpathnavigator.func_192879_a(false);
        flyingpathnavigator.func_212239_d(false);
        flyingpathnavigator.func_192878_b(false);
        return flyingpathnavigator;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ATTACKING, (Object)false);
        this.func_184212_Q().func_187214_a(BANKING, (Object)Float.valueOf(0.0f));
        this.func_184212_Q().func_187214_a(PREV_BANKING, (Object)Float.valueOf(0.0f));
    }

    public boolean func_70112_a(double distance) {
        return distance < 16600.0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public AxisAlignedBB func_184177_bl() {
        return super.func_184177_bl().func_186662_g(12.0);
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MowzieEntity.createAttributes().func_233815_a_(Attributes.field_233818_a_, 30.0).func_233815_a_(Attributes.field_233821_d_, 12.0).func_233815_a_(Attributes.field_233819_b_, 40.0).func_233815_a_(Attributes.field_233823_f_, 4.0);
    }

    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.getAnimation() != NO_ANIMATION) {
            return null;
        }
        int r = this.field_70146_Z.nextInt(4);
        if (r == 0) {
            this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_ROAR.get(this.field_70146_Z.nextInt(4))).get(), 5.0f, 1.0f);
            this.roarAnimation = 0;
        } else if (r <= 2) {
            this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_GROWL.get(this.field_70146_Z.nextInt(3))).get(), 4.0f, 1.0f);
        }
        return null;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_GRUNT.get(this.field_70146_Z.nextInt(3))).get(), 2.0f, 1.0f);
        return null;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        this.func_184185_a((SoundEvent)((Supplier)MMSounds.ENTITY_NAGA_ROAR.get(this.field_70146_Z.nextInt(4))).get(), 3.0f, 1.0f);
        return null;
    }

    @Override
    public void func_70071_h_() {
        this.prevMotionX = this.func_213322_ci().field_72450_a;
        this.prevMotionY = this.func_213322_ci().field_72448_b;
        this.prevMotionZ = this.func_213322_ci().field_72449_c;
        this.prevHoverAnimFrac = this.hoverAnimFrac;
        this.prevFlapAnimFrac = this.flapAnimFrac;
        super.func_70071_h_();
        this.field_70761_aq = this.field_70177_z;
        if (this.field_70170_p.func_201670_d()) {
            this.banking = this.getBanking();
            this.prevBanking = this.getPrevBanking();
        }
        if (this.spitCooldown > 0) {
            --this.spitCooldown;
        }
        if (this.swoopCooldown > 0) {
            --this.swoopCooldown;
        }
        if (this.onGroundTimer > 0) {
            --this.onGroundTimer;
        }
        if (this.roarAnimation < 30) {
            ++this.roarAnimation;
        }
        if (this.getAnimation() == null) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, NO_ANIMATION);
        }
        if (this.func_70644_a(Effects.field_76436_u)) {
            this.func_184596_c(Effects.field_76436_u);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70638_az() != null && (double)this.targetDistance < 29.5 && this.movement != EnumNagaMovement.FALLEN && this.movement != EnumNagaMovement.FALLING) {
                this.setAttacking(true);
                if (this.getAnimation() == NO_ANIMATION && this.swoopCooldown == 0 && this.field_70146_Z.nextInt(80) == 0 && this.func_226278_cu_() - this.func_70638_az().func_226278_cu_() > 0.0) {
                    this.interrupted = false;
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, SWOOP_ANIMATION);
                    this.swoopCooldown = SWOOP_COOLDOWN_MAX;
                } else if (this.getAnimation() == NO_ANIMATION && this.spitCooldown == 0 && this.field_70146_Z.nextInt(80) == 0) {
                    this.interrupted = false;
                    AnimationHandler.INSTANCE.sendAnimationMessage(this, SPIT_ANIMATION);
                    this.spitCooldown = SPIT_COOLDOWN_MAX;
                }
            } else {
                this.setAttacking(false);
            }
        }
        if (this.movement != EnumNagaMovement.FALLING && this.movement != EnumNagaMovement.FALLEN) {
            if (this.getAttacking()) {
                this.movement = EnumNagaMovement.HOVERING;
                this.hoverAnim.increaseTimer();
                if (this.getAnimation() == NO_ANIMATION && !this.field_70170_p.field_72995_K) {
                    List<ProjectileEntity> projectilesNearby = this.getEntitiesNearby(ProjectileEntity.class, 30.0);
                    for (ProjectileEntity a : projectilesNearby) {
                        float dot;
                        Vector3d aActualMotion = new Vector3d(a.func_226277_ct_() - a.field_70169_q, a.func_226278_cu_() - a.field_70167_r, a.func_226281_cx_() - a.field_70166_s);
                        if (aActualMotion.func_72433_c() < 0.1 || a.field_70173_aa <= 1 || !((double)(dot = (float)a.func_213322_ci().func_72432_b().func_72430_b(this.func_213303_ch().func_178788_d(a.func_213303_ch()).func_72432_b())) > 0.96)) continue;
                        Vector3d dodgeVec = a.func_213322_ci().func_72431_c(new Vector3d(0.0, 1.0, 0.0)).func_72432_b().func_186678_a(1.2);
                        Vector3d newPosLeft = this.func_213303_ch().func_178787_e(dodgeVec.func_186678_a(2.0));
                        Vector3d newPosRight = this.func_213303_ch().func_178787_e(dodgeVec.func_186678_a(-2.0));
                        Vector3d diffLeft = newPosLeft.func_178788_d(a.func_213303_ch());
                        Vector3d diffRight = newPosRight.func_178788_d(a.func_213303_ch());
                        if (diffRight.func_72430_b(a.func_213322_ci()) > diffLeft.func_72430_b(a.func_213322_ci())) {
                            dodgeVec = dodgeVec.func_186678_a(-1.0);
                        }
                        this.func_213317_d(this.func_213322_ci().func_178787_e(dodgeVec));
                        AnimationHandler.INSTANCE.sendAnimationMessage(this, DODGE_ANIMATION);
                    }
                }
            } else {
                this.movement = EnumNagaMovement.GLIDING;
                this.hoverAnim.decreaseTimer();
                this.flapAnim.decreaseTimer();
            }
        } else if (this.movement == EnumNagaMovement.FALLING && (this.field_70122_E || this.func_180799_ab() || this.func_70090_H())) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, LAND_ANIMATION);
            this.movement = EnumNagaMovement.FALLEN;
            this.onGroundTimer = GROUND_TIMER_MAX;
            this.func_213293_j(0.0, this.func_213322_ci().field_72448_b, 0.0);
            this.func_70661_as().func_75499_g();
        }
        if (this.movement == EnumNagaMovement.FALLEN && this.onGroundTimer <= 0 && this.getAnimation() == NO_ANIMATION) {
            this.setAnimationTick(0);
            AnimationHandler.INSTANCE.sendAnimationMessage(this, GET_UP_ANIMATION);
        }
        if (this.getAnimation() == SWOOP_ANIMATION && this.getAnimationTick() < 43) {
            this.hoverAnim.increaseTimer();
            this.flapAnim.decreaseTimer();
        } else if (this.getAnimation() == HURT_TO_FALL_ANIMATION) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.getAnimation() == LAND_ANIMATION) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.getAnimation() == GET_UP_ANIMATION && this.getAnimationTick() < 26) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else if (this.movement == EnumNagaMovement.FALLEN) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
            this.field_70177_z = this.field_70126_B;
            this.field_70759_as = this.field_70758_at;
            this.field_70125_A = this.field_70127_C;
        } else if (this.movement == EnumNagaMovement.FALLING) {
            this.flapAnim.decreaseTimer();
            this.hoverAnim.increaseTimer();
        } else {
            this.flapAnim.increaseTimer();
        }
        if (this.getAnimation() == SPIT_ANIMATION && this.field_70170_p.field_72995_K && this.mouthPos != null && !this.interrupted) {
            Vector3d particlePos;
            if (this.getAnimationTick() == 33) {
                float explodeSpeed = 2.4f;
                for (int i = 0; i < 25; ++i) {
                    particlePos = new Vector3d(0.25, 0.0, 0.0);
                    particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    double value = this.field_70146_Z.nextFloat() * 0.1f;
                    double life = this.field_70146_Z.nextFloat() * 10.0f + 20.0f;
                    ParticleVanillaCloudExtended.spawnVanillaCloud(this.field_70170_p, particlePos.field_72450_a + this.mouthPos[0].field_72450_a, particlePos.field_72448_b + this.mouthPos[0].field_72448_b, particlePos.field_72449_c + this.mouthPos[0].field_72449_c, particlePos.field_72450_a * (double)explodeSpeed, particlePos.field_72448_b * (double)explodeSpeed, particlePos.field_72449_c * (double)explodeSpeed, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.6, life);
                }
            }
            if (this.getAnimationTick() <= 15 && this.mouthPos != null && !this.interrupted) {
                int howMany = 4;
                for (int i = 0; i < howMany; ++i) {
                    particlePos = new Vector3d(3.0, 0.0, 0.0);
                    particlePos = particlePos.func_178785_b((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    particlePos = particlePos.func_178789_a((float)((double)(this.field_70146_Z.nextFloat() * 2.0f) * Math.PI));
                    double value = this.field_70146_Z.nextFloat() * 0.15f;
                    ParticleVanillaCloudExtended.spawnVanillaCloudDestination(this.field_70170_p, particlePos.field_72450_a + this.mouthPos[0].field_72450_a, particlePos.field_72448_b + this.mouthPos[0].field_72448_b, particlePos.field_72449_c + this.mouthPos[0].field_72449_c, 0.0, 0.0, 0.0, 1.0, 0.25 + value, 0.75 + value, 0.25 + value, 0.9, 15.0, this.mouthPos);
                }
            }
        }
        if (this.getAnimation() == HURT_TO_FALL_ANIMATION && this.getAnimationTick() == 17) {
            this.movement = EnumNagaMovement.FALLING;
        }
        if (this.getAnimation() == GET_UP_ANIMATION && this.getAnimationTick() == 26) {
            this.movement = EnumNagaMovement.HOVERING;
        }
        if (this.field_70170_p.field_72995_K && this.movement == EnumNagaMovement.HOVERING && (double)this.flapAnim.getAnimationFraction() >= 0.5) {
            if ((double)this.shoulderRot > 0.9) {
                this.hasFlapSoundPlayed = false;
            }
            if ((double)this.shoulderRot <= 0.7 && !this.hasFlapSoundPlayed) {
                this.field_70170_p.func_184134_a(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), (SoundEvent)MMSounds.ENTITY_NAGA_FLAP_1.get(), SoundCategory.HOSTILE, 2.0f, (float)(0.85 + (double)this.field_70146_Z.nextFloat() * 0.2), false);
                this.hasFlapSoundPlayed = true;
            }
        }
        this.hoverAnimFrac = this.hoverAnim.getAnimationProgressSinSqrt();
        this.flapAnimFrac = this.flapAnim.getAnimationProgressSinSqrt();
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
    }

    @Override
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, ILivingEntityData spawnDataIn, CompoundNBT dataTag) {
        this.func_213390_a(this.func_233580_cy_(), MAX_DIST_FROM_HOME);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected ConfigHandler.SpawnConfig getSpawnConfig() {
        return ConfigHandler.COMMON.MOBS.NAGA.spawnConfig;
    }

    @Override
    protected ConfigHandler.CombatConfig getCombatConfig() {
        return ConfigHandler.COMMON.MOBS.NAGA.combatConfig;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        boolean flag = super.func_213380_a(world, reason);
        this.func_70107_b(this.func_226277_ct_(), this.func_226278_cu_() + 5.0, this.func_226281_cx_());
        return flag && world.func_175659_aa() != Difficulty.PEACEFUL;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        boolean liquid = !this.field_70170_p.func_72953_d(this.func_174813_aQ());
        boolean worldCollision = this.field_70170_p.func_226665_a__((Entity)this, this.func_174813_aQ());
        boolean mobCollision = this.field_70170_p.func_226668_i_((Entity)this);
        return liquid && worldCollision && mobCollision;
    }

    @Override
    protected void onDeathAIUpdate() {
        super.onDeathAIUpdate();
        if (this.field_70725_aQ == 15 && this.movement != EnumNagaMovement.FALLEN) {
            this.movement = EnumNagaMovement.FALLING;
        }
    }

    @Override
    public boolean func_70097_a(DamageSource source, float damage) {
        boolean isSwooping;
        boolean flag = super.func_70097_a(source, damage);
        boolean isSpitting = this.getAnimation() == SPIT_ANIMATION && this.getAnimationTick() < 30;
        boolean bl = isSwooping = this.getAnimation() == SWOOP_ANIMATION && this.getAnimationTick() < 25;
        if (flag && this.movement != EnumNagaMovement.FALLING && (isSpitting || isSwooping) && damage > 0.0f) {
            AnimationHandler.INSTANCE.sendAnimationMessage(this, HURT_TO_FALL_ANIMATION);
            this.interrupted = true;
        }
        return flag;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        if (this.interrupted) {
            return;
        }
        Vector3d projectilePos = new Vector3d(1.0, -0.7, 0.0);
        projectilePos = projectilePos.func_178785_b((float)Math.toRadians(-this.field_70177_z - 90.0f));
        projectilePos = projectilePos.func_178787_e(this.func_213303_ch());
        projectilePos = projectilePos.func_178787_e(new Vector3d(0.0, 0.0, 1.0).func_178789_a((float)Math.toRadians(-this.field_70125_A)).func_178785_b((float)Math.toRadians(-this.field_70759_as)));
        projectilePos = projectilePos.func_178787_e(new Vector3d(0.0, 0.0, 0.0));
        EntityPoisonBall poisonBall = new EntityPoisonBall((EntityType<? extends EntityPoisonBall>)((EntityType)EntityHandler.POISON_BALL.get()), this.field_70170_p, (LivingEntity)this);
        poisonBall.func_70107_b(projectilePos.field_72450_a, projectilePos.field_72448_b, projectilePos.field_72449_c);
        Vector3d look = this.func_70040_Z();
        Vector3d dir = new Vector3d(look.field_72450_a, 0.0, look.field_72449_c).func_72432_b();
        if (target != null) {
            float dy = (float)(projectilePos.field_72448_b - target.func_226278_cu_());
            float dx = (float)(projectilePos.field_72450_a - target.func_226277_ct_());
            float dz = (float)(projectilePos.field_72449_c - target.func_226281_cx_());
            float dist = (float)Math.sqrt(dx * dx + dz * dz);
            float timeGuess = (float)Math.sqrt(2.0f * dy / EntityPoisonBall.GRAVITY);
            float speed = Math.min(dist / timeGuess, 0.9f);
            poisonBall.shoot(dir.field_72450_a * (double)speed, 0.1, dir.field_72449_c * (double)speed, 1.0f, 0.0f);
        }
        this.field_70170_p.func_217376_c((Entity)poisonBall);
        this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_ACID_SPIT.get(), 2.0f, 1.0f);
        this.func_184185_a((SoundEvent)MMSounds.ENTITY_NAGA_ACID_SPIT_HISS.get(), 2.0f, 1.0f);
    }

    @Override
    public Animation getDeathAnimation() {
        if (this.movement == EnumNagaMovement.FALLEN) {
            return DIE_GROUND_ANIMATION;
        }
        return DIE_AIR_ANIMATION;
    }

    @Override
    public Animation getHurtAnimation() {
        return null;
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{FLAP_ANIMATION, DODGE_ANIMATION, SWOOP_ANIMATION, SPIT_ANIMATION, HURT_TO_FALL_ANIMATION, LAND_ANIMATION, GET_UP_ANIMATION, DIE_AIR_ANIMATION, DIE_GROUND_ANIMATION, TAIL_DEMO_ANIMATION};
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (this.movement == EnumNagaMovement.FALLING) {
            return super.func_225503_b_(distance, damageMultiplier);
        }
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
        if (this.movement == EnumNagaMovement.FALLING) {
            super.func_184231_a(y, onGroundIn, state, pos);
        }
    }

    public void func_213352_e(Vector3d motion) {
        double d0 = 0.08;
        ModifiableAttributeInstance gravity = this.func_110148_a((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        boolean flag = this.func_213322_ci().field_72448_b <= 0.0;
        d0 = gravity.func_111126_e();
        FluidState fluidstate = this.field_70170_p.func_204610_c(this.func_233580_cy_());
        if (this.func_70090_H() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
            double d8 = this.func_226278_cu_();
            float f5 = this.func_70051_ag() ? 0.9f : this.func_189749_co();
            float f6 = 0.02f;
            float f7 = EnchantmentHelper.func_185294_d((LivingEntity)this);
            if (f7 > 3.0f) {
                f7 = 3.0f;
            }
            if (!this.field_70122_E) {
                f7 *= 0.5f;
            }
            if (f7 > 0.0f) {
                f5 += (0.54600006f - f5) * f7 / 3.0f;
                f6 += (this.func_70689_ay() - f6) * f7 / 3.0f;
            }
            if (this.func_70644_a(Effects.field_206827_D)) {
                f5 = 0.96f;
            }
            this.func_213309_a(f6 *= (float)this.func_110148_a((Attribute)ForgeMod.SWIM_SPEED.get()).func_111126_e(), motion);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            Vector3d vector3d6 = this.func_213322_ci();
            if (this.field_70123_F && this.func_70617_f_()) {
                vector3d6 = new Vector3d(vector3d6.field_72450_a, 0.2, vector3d6.field_72449_c);
            }
            Vector3d vector3d2 = this.func_233626_a_(d0, flag, this.func_213322_ci());
            this.func_213317_d(vector3d2);
            if (this.field_70123_F && this.func_70038_c(vector3d2.field_72450_a, vector3d2.field_72448_b + (double)0.6f - this.func_226278_cu_() + d8, vector3d2.field_72449_c)) {
                this.func_213293_j(vector3d2.field_72450_a, 0.3f, vector3d2.field_72449_c);
            }
        } else if (this.func_180799_ab() && this.func_241208_cS_() && !this.func_230285_a_(fluidstate.func_206886_c())) {
            double d7 = this.func_226278_cu_();
            this.func_213309_a(0.02f, motion);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (this.func_233571_b_((ITag)FluidTags.field_206960_b) <= this.func_233579_cu_()) {
                this.func_213317_d(this.func_213322_ci().func_216372_d(0.5, (double)0.8f, 0.5));
                Vector3d vector3d3 = this.func_233626_a_(d0, flag, this.func_213322_ci());
                this.func_213317_d(vector3d3);
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(0.5));
            }
            if (!this.func_189652_ae()) {
                this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -d0 / 4.0, 0.0));
            }
            Vector3d vector3d4 = this.func_213322_ci();
            if (this.field_70123_F && this.func_70038_c(vector3d4.field_72450_a, vector3d4.field_72448_b + (double)0.6f - this.func_226278_cu_() + d7, vector3d4.field_72449_c)) {
                this.func_213293_j(vector3d4.field_72450_a, 0.3f, vector3d4.field_72449_c);
            }
        } else if (this.movement == EnumNagaMovement.HOVERING) {
            double dz;
            double dy;
            double dx;
            double distanceToDest;
            BlockPos ground = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b - 1.0, this.func_226281_cx_());
            float f = 0.91f;
            if (this.func_233570_aj_()) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            float f1 = 0.16277137f / (f * f * f);
            f = 0.91f;
            if (this.func_233570_aj_()) {
                f = this.field_70170_p.func_180495_p(ground).getSlipperiness((IWorldReader)this.field_70170_p, ground, (Entity)this) * 0.91f;
            }
            this.func_213309_a(this.func_233570_aj_() ? 0.1f * f1 : 0.02f, motion);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a((double)f));
            BlockPos destination = this.func_70661_as().func_208485_j();
            if (destination != null && (distanceToDest = Math.sqrt((dx = (double)destination.func_177958_n() - this.func_226277_ct_()) * dx + (dy = (double)destination.func_177956_o() - this.func_226278_cu_()) * dy + (dz = (double)destination.func_177952_p() - this.func_226281_cx_()) * dz)) < 0.1 && this.getAnimation() == NO_ANIMATION) {
                this.func_213293_j(0.0, 0.0, 0.0);
            }
        } else if (this.movement == EnumNagaMovement.GLIDING) {
            Vector3d Vector3d3 = this.func_213322_ci();
            if (Vector3d3.field_72448_b > -0.5) {
                this.field_70143_R = 1.0f;
            }
            Vector3d moveDirection = this.func_70040_Z();
            moveDirection = moveDirection.func_72432_b();
            float f6 = this.field_70125_A * ((float)Math.PI / 180);
            double d9 = Math.sqrt(moveDirection.field_72450_a * moveDirection.field_72450_a + moveDirection.field_72449_c * moveDirection.field_72449_c);
            double d11 = Math.sqrt(EntityNaga.func_213296_b((Vector3d)Vector3d3));
            double d12 = moveDirection.func_72433_c();
            float f3 = MathHelper.func_76134_b((float)f6);
            f3 = (float)((double)f3 * (double)f3 * Math.min(1.0, d12 / 0.4));
            Vector3d3 = this.func_213322_ci().func_72441_c(0.0, d0 * (-1.0 + (double)f3 * 0.75), 0.0);
            if (Vector3d3.field_72448_b < 0.0 && d9 > 0.0) {
                double d3 = Vector3d3.field_72448_b * -0.1 * (double)f3;
                Vector3d3 = Vector3d3.func_72441_c(moveDirection.field_72450_a * d3 / d9, d3, moveDirection.field_72449_c * d3 / d9);
            }
            if (f6 < 0.0f && d9 > 0.0) {
                double d13 = d11 * (double)(-MathHelper.func_76126_a((float)f6)) * 0.04;
                Vector3d3 = Vector3d3.func_72441_c(-moveDirection.field_72450_a * d13 / d9, d13 * 3.2, -moveDirection.field_72449_c * d13 / d9);
            }
            if (d9 > 0.0) {
                Vector3d3 = Vector3d3.func_72441_c((moveDirection.field_72450_a / d9 * d11 - Vector3d3.field_72450_a) * 0.1, 0.0, (moveDirection.field_72449_c / d9 * d11 - Vector3d3.field_72449_c) * 0.1);
            }
            this.func_213317_d(Vector3d3.func_216372_d((double)0.99f, (double)0.98f, (double)0.99f));
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            if (moveDirection.func_82617_b() < 0.0 && this.getAnimation() == NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this, FLAP_ANIMATION);
            }
        } else if (this.movement == EnumNagaMovement.FALLING || this.movement == EnumNagaMovement.FALLEN || this.func_175446_cd()) {
            BlockPos blockpos = new BlockPos(this.func_226277_ct_(), this.func_174813_aQ().field_72338_b - 1.0, this.func_226281_cx_());
            float f5 = this.field_70170_p.func_180495_p(blockpos).getSlipperiness((IWorldReader)this.field_70170_p, blockpos, (Entity)this);
            float f7 = this.func_233570_aj_() ? f5 * 0.91f : 0.91f;
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            Vector3d Vector3d5 = this.func_213322_ci();
            if ((this.field_70123_F || this.field_70703_bu) && this.func_70617_f_()) {
                Vector3d5 = new Vector3d(Vector3d5.field_72450_a, 0.2, Vector3d5.field_72449_c);
            }
            double d10 = Vector3d5.field_72448_b;
            if (this.func_70644_a(Effects.field_188424_y)) {
                d10 += (0.05 * (double)(this.func_70660_b(Effects.field_188424_y).func_76458_c() + 1) - Vector3d5.field_72448_b) * 0.2;
                this.field_70143_R = 0.0f;
            } else if (this.field_70170_p.field_72995_K && !this.field_70170_p.func_175667_e(blockpos)) {
                d10 = this.func_226278_cu_() > 0.0 ? -0.1 : 0.0;
            } else if (!this.func_189652_ae()) {
                d10 -= d0;
            }
            this.func_213293_j(Vector3d5.field_72450_a * (double)f7, d10 * (double)0.98f, Vector3d5.field_72449_c * (double)f7);
        }
        this.field_184618_aE = this.field_70721_aZ;
        double d5 = this.func_226277_ct_() - this.field_70169_q;
        double d6 = this.func_226281_cx_() - this.field_70166_s;
        double d8 = this.func_226278_cu_() - this.field_70167_r;
        float f8 = MathHelper.func_76133_a((double)(d5 * d5 + d8 * d8 + d6 * d6)) * 4.0f;
        if (f8 > 1.0f) {
            f8 = 1.0f;
        }
        this.field_70721_aZ += (f8 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean getAttacking() {
        return (Boolean)this.func_184212_Q().func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.func_184212_Q().func_187227_b(ATTACKING, (Object)attacking);
    }

    public float getBanking() {
        return ((Float)this.func_184212_Q().func_187225_a(BANKING)).floatValue();
    }

    public void setBanking(float banking) {
        this.func_184212_Q().func_187227_b(BANKING, (Object)Float.valueOf(banking));
    }

    public float getPrevBanking() {
        return ((Float)this.func_184212_Q().func_187225_a(PREV_BANKING)).floatValue();
    }

    public void setPrevBanking(float prevBanking) {
        this.func_184212_Q().func_187227_b(PREV_BANKING, (Object)Float.valueOf(prevBanking));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("HomePosX", this.func_213384_dI().func_177958_n());
        compound.func_74768_a("HomePosY", this.func_213384_dI().func_177956_o());
        compound.func_74768_a("HomePosZ", this.func_213384_dI().func_177952_p());
        compound.func_74768_a("HomeDist", (int)this.func_213391_dJ());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        int i = compound.func_74762_e("HomePosX");
        int j = compound.func_74762_e("HomePosY");
        int k = compound.func_74762_e("HomePosZ");
        int dist = compound.func_74762_e("HomeDist");
        this.func_213390_a(new BlockPos(i, j, k), dist);
    }

    protected ResourceLocation func_184647_J() {
        return LootTableHandler.NAGA;
    }

    class NagaLookController
    extends LookController {
        public NagaLookController(MobEntity entity) {
            super(entity);
        }

        public void func_75649_a() {
            if (this.field_75655_d) {
                this.field_75655_d = false;
                this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.func_220678_h(), this.field_75657_b);
            } else {
                this.field_75659_a.field_70759_as = this.func_220675_a(this.field_75659_a.field_70759_as, this.field_75659_a.field_70761_aq, 10.0f);
            }
            if (!this.field_75659_a.func_70661_as().func_75500_f()) {
                this.field_75659_a.field_70759_as = MathHelper.func_219800_b((float)this.field_75659_a.field_70759_as, (float)this.field_75659_a.field_70761_aq, (float)this.field_75659_a.func_184649_cE());
            }
        }
    }

    class NagaMoveHelper
    extends MovementController {
        private final EntityNaga parentEntity;
        private int courseChangeCooldown;
        private float speedFactor;

        public NagaMoveHelper(EntityNaga naga) {
            super((MobEntity)naga);
            this.speedFactor = 0.1f;
            this.parentEntity = naga;
        }

        public void func_75641_c() {
            this.speedFactor = 1.0f;
            if (EntityNaga.this.movement == EnumNagaMovement.GLIDING) {
                if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                    if (EntityNaga.this.field_70123_F) {
                        EntityNaga naga = EntityNaga.this;
                        naga.field_70177_z += 180.0f;
                        this.speedFactor = 0.1f;
                        EntityNaga.this.func_70661_as().func_75499_g();
                    }
                    float orbitOffsetDiffX = (float)((double)EntityNaga.this.func_70661_as().func_208485_j().func_177958_n() - EntityNaga.this.func_226277_ct_());
                    float orbitOffsetDiffY = (float)((double)EntityNaga.this.func_70661_as().func_208485_j().func_177956_o() - EntityNaga.this.func_226278_cu_());
                    float orbitOffsetDiffZ = (float)((double)EntityNaga.this.func_70661_as().func_208485_j().func_177952_p() - EntityNaga.this.func_226281_cx_());
                    double horizontalDistToOrbitOffset = MathHelper.func_76129_c((float)(orbitOffsetDiffX * orbitOffsetDiffX + orbitOffsetDiffZ * orbitOffsetDiffZ));
                    double yFractionReduction = 1.0 - (double)MathHelper.func_76135_e((float)(orbitOffsetDiffY * 0.7f)) / horizontalDistToOrbitOffset;
                    orbitOffsetDiffX = (float)((double)orbitOffsetDiffX * yFractionReduction);
                    orbitOffsetDiffZ = (float)((double)orbitOffsetDiffZ * yFractionReduction);
                    horizontalDistToOrbitOffset = MathHelper.func_76129_c((float)(orbitOffsetDiffX * orbitOffsetDiffX + orbitOffsetDiffZ * orbitOffsetDiffZ));
                    double distToOrbitOffset = MathHelper.func_76129_c((float)(orbitOffsetDiffX * orbitOffsetDiffX + orbitOffsetDiffZ * orbitOffsetDiffZ + orbitOffsetDiffY * orbitOffsetDiffY));
                    float rotationYaw = EntityNaga.this.field_70177_z;
                    float desiredRotationYaw = (float)MathHelper.func_181159_b((double)orbitOffsetDiffZ, (double)orbitOffsetDiffX);
                    float rotationYawWrapped = MathHelper.func_76142_g((float)(EntityNaga.this.field_70177_z + 90.0f));
                    float desiredRotationYawWrapped = MathHelper.func_76142_g((float)(desiredRotationYaw * 57.295776f));
                    EntityNaga.this.field_70177_z = MathHelper.func_203303_c((float)rotationYawWrapped, (float)desiredRotationYawWrapped, (float)4.0f) - 90.0f;
                    float newBanking = MowzieMathUtil.approachDegreesSmooth(EntityNaga.this.getBanking(), EntityNaga.this.getPrevBanking(), EntityNaga.this.field_70177_z - rotationYaw, 0.5f, 0.1f);
                    EntityNaga.this.setPrevBanking(EntityNaga.this.getBanking());
                    EntityNaga.this.setBanking(newBanking);
                    EntityNaga.this.field_70761_aq = EntityNaga.this.field_70177_z;
                    float desiredPitch = (float)(-(MathHelper.func_181159_b((double)(-orbitOffsetDiffY), (double)horizontalDistToOrbitOffset) * 57.2957763671875));
                    EntityNaga.this.field_70125_A = MathHelper.func_203303_c((float)EntityNaga.this.field_70125_A, (float)desiredPitch, (float)8.0f);
                    float rotationYaw1 = EntityNaga.this.field_70177_z + 90.0f;
                    double xMotion = (double)(this.speedFactor * MathHelper.func_76134_b((float)(rotationYaw1 * ((float)Math.PI / 180)))) * Math.abs((double)orbitOffsetDiffX / distToOrbitOffset);
                    double yMotion = (double)(this.speedFactor * MathHelper.func_76126_a((float)(rotationYaw1 * ((float)Math.PI / 180)))) * Math.abs((double)orbitOffsetDiffZ / distToOrbitOffset);
                    double zMotion = (double)(this.speedFactor * MathHelper.func_76126_a((float)(desiredPitch * ((float)Math.PI / 180)))) * Math.abs((double)orbitOffsetDiffY / distToOrbitOffset);
                    Vector3d motion = EntityNaga.this.func_213322_ci();
                    EntityNaga.this.func_213317_d(motion.func_178787_e(new Vector3d(xMotion, zMotion, yMotion).func_178788_d(motion).func_186678_a(0.1)));
                }
            } else if (EntityNaga.this.movement == EnumNagaMovement.HOVERING && (EntityNaga.this.getAnimation() == IAnimatedEntity.NO_ANIMATION || EntityNaga.this.getAnimation() == SPIT_ANIMATION)) {
                LivingEntity target = EntityNaga.this.func_70638_az();
                if (target != null && EntityNaga.this.func_70068_e((Entity)this.parentEntity) < 1600.0) {
                    EntityNaga.this.func_70625_a((Entity)target, 100.0f, 100.0f);
                }
                if (this.field_188491_h == MovementController.Action.MOVE_TO && this.courseChangeCooldown-- <= 0) {
                    this.courseChangeCooldown += this.parentEntity.func_70681_au().nextInt(5) + 2;
                    Vector3d Vector3d2 = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                    double d0 = Vector3d2.func_72433_c();
                    if (this.checkCollisions(Vector3d2 = Vector3d2.func_72432_b(), MathHelper.func_76143_f((double)d0))) {
                        this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(Vector3d2.func_186678_a(0.1)));
                    } else {
                        this.field_188491_h = MovementController.Action.WAIT;
                    }
                }
            }
        }

        public boolean checkCollisions(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    public class FlyOutOfWaterGoal
    extends Goal {
        private final EntityNaga entity;

        public FlyOutOfWaterGoal(EntityNaga entityIn) {
            this.entity = entityIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.entity.func_70090_H() && this.entity.func_233571_b_((ITag)FluidTags.field_206959_a) > this.entity.func_233579_cu_() || this.entity.func_180799_ab();
        }

        public void func_75249_e() {
            if (this.entity.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                AnimationHandler.INSTANCE.sendAnimationMessage(this.entity, FLAP_ANIMATION);
            }
        }

        public boolean func_75253_b() {
            return false;
        }
    }

    class AIFlyTowardsTarget
    extends Goal {
        private final EntityNaga parentEntity;

        public AIFlyTowardsTarget(EntityNaga naga) {
            this.parentEntity = naga;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return this.parentEntity.func_70638_az() != null && EntityNaga.this.func_70068_e((Entity)this.parentEntity.func_70638_az()) >= 870.25;
        }

        public boolean func_75253_b() {
            double dz;
            double dy;
            if (EntityNaga.this.func_70638_az() == null) {
                return false;
            }
            if (EntityNaga.this.func_70638_az().func_70068_e((Entity)this.parentEntity) <= 500.0) {
                return false;
            }
            BlockPos navigatorPos = this.parentEntity.func_70661_as().func_208485_j();
            if (navigatorPos == null) {
                return false;
            }
            double dx = (double)navigatorPos.func_177958_n() - this.parentEntity.func_226277_ct_();
            double distanceToDest = Math.sqrt(dx * dx + (dy = (double)navigatorPos.func_177956_o() - this.parentEntity.func_226278_cu_()) * dy + (dz = (double)navigatorPos.func_177952_p() - this.parentEntity.func_226281_cx_()) * dz);
            if (distanceToDest > 60.0) {
                return false;
            }
            return EntityNaga.this.field_70699_by.func_226337_n_();
        }

        public void func_75246_d() {
            super.func_75246_d();
            LivingEntity target = this.parentEntity.func_70638_az();
            double speed = this.parentEntity.func_110148_a(Attributes.field_233821_d_).func_111126_e();
            BlockPos targetPos = target.func_233580_cy_().func_177981_b(8);
            if (!this.parentEntity.field_70170_p.func_201671_F(targetPos)) {
                this.parentEntity.func_70661_as().func_75492_a((double)targetPos.func_177958_n(), (double)targetPos.func_177956_o(), (double)targetPos.func_177952_p(), speed);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityNaga.this.func_70661_as().func_75499_g();
        }
    }

    class AIFlyAroundTarget
    extends Goal {
        private final EntityNaga parentEntity;

        public AIFlyAroundTarget(EntityNaga naga) {
            this.parentEntity = naga;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            if (this.parentEntity.func_70638_az() != null && this.parentEntity.func_70661_as().func_75500_f()) {
                return this.parentEntity.field_70146_Z.nextInt(60) == 0;
            }
            return false;
        }

        public boolean func_75253_b() {
            double dz2;
            double dy2;
            double dz;
            double dy;
            if (EntityNaga.this.func_70638_az() == null) {
                return false;
            }
            BlockPos navigatorPos = this.parentEntity.func_70661_as().func_208485_j();
            if (navigatorPos == null) {
                return false;
            }
            double dx = (double)navigatorPos.func_177958_n() - this.parentEntity.func_226277_ct_();
            double distanceToDest = Math.sqrt(dx * dx + (dy = (double)navigatorPos.func_177956_o() - this.parentEntity.func_226278_cu_()) * dy + (dz = (double)navigatorPos.func_177952_p() - this.parentEntity.func_226281_cx_()) * dz);
            if (distanceToDest > 60.0) {
                return false;
            }
            LivingEntity target = this.parentEntity.func_70638_az();
            double dx2 = (double)navigatorPos.func_177958_n() - target.func_226277_ct_();
            double distanceDestToTarget = Math.sqrt(dx2 * dx2 + (dy2 = (double)navigatorPos.func_177956_o() - target.func_226278_cu_()) * dy2 + (dz2 = (double)navigatorPos.func_177952_p() - target.func_226281_cx_()) * dz2);
            if (distanceDestToTarget > 20.0 || distanceDestToTarget < 5.0) {
                return false;
            }
            return EntityNaga.this.field_70699_by.func_226337_n_() && !EntityNaga.this.field_70699_by.func_208485_j().func_218141_a((Vector3i)EntityNaga.this.func_233580_cy_(), 1.0);
        }

        public void func_75249_e() {
            Random random = this.parentEntity.func_70681_au();
            LivingEntity target = this.parentEntity.func_70638_az();
            float yaw = (float)((double)random.nextFloat() * Math.PI * 2.0);
            float radius = 16.0f;
            double d0 = target.func_226277_ct_() + Math.cos(yaw) * (double)radius;
            double d1 = target.func_226278_cu_() + 8.0 + (double)(random.nextFloat() * 5.0f);
            double d2 = target.func_226281_cx_() + Math.sin(yaw) * (double)radius;
            double speed = this.parentEntity.func_110148_a(Attributes.field_233821_d_).func_111126_e();
            if (!this.parentEntity.field_70170_p.func_201671_F(new BlockPos(d0, d1, d2))) {
                this.parentEntity.func_70661_as().func_75492_a(d0, d1, d2, speed);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityNaga.this.func_70661_as().func_75499_g();
        }
    }

    class WanderGoal
    extends Goal {
        private boolean seesGround;

        WanderGoal() {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean func_75250_a() {
            return EntityNaga.this.field_70699_by.func_75500_f() && EntityNaga.this.func_70638_az() == null;
        }

        public boolean func_75253_b() {
            return EntityNaga.this.field_70699_by.func_226337_n_() && !EntityNaga.this.field_70699_by.func_208485_j().func_218141_a((Vector3i)EntityNaga.this.func_233580_cy_(), 4.0) && EntityNaga.this.func_70638_az() == null;
        }

        public void func_75249_e() {
            Vector3d vector3d = this.getRandomLocation();
            if (vector3d != null) {
                EntityNaga.this.field_70699_by.func_226335_a_(0.5f);
                EntityNaga.this.field_70699_by.func_75484_a(EntityNaga.this.field_70699_by.func_179680_a(new BlockPos(vector3d), 1), 1.0);
            }
        }

        public void func_75246_d() {
            Vector3d newLocation;
            super.func_75246_d();
            if (!this.seesGround && (newLocation = this.getRandomLocation()) != null && this.seesGround) {
                EntityNaga.this.field_70699_by.func_75484_a(EntityNaga.this.field_70699_by.func_179680_a(new BlockPos(newLocation), 1), 1.0);
            }
        }

        public void func_75251_c() {
            super.func_75251_c();
            EntityNaga.this.func_70661_as().func_75499_g();
        }

        @Nullable
        private Vector3d getRandomLocation() {
            Vector3d vector3d = EntityNaga.this.func_70676_i(0.0f);
            Vector3d position = RandomPositionGenerator.func_226340_a_((CreatureEntity)EntityNaga.this, (int)24, (int)24, (Vector3d)vector3d, (float)1.5707964f, (int)8, (int)18);
            if (position == null) {
                position = RandomPositionGenerator.func_226344_b_((CreatureEntity)EntityNaga.this, (int)24, (int)8, (int)-8, (Vector3d)EntityNaga.this.func_213303_ch().func_178787_e(vector3d), (double)1.5707963705062866);
                this.seesGround = false;
            } else {
                this.seesGround = true;
            }
            if (position == null || !EntityNaga.this.field_70170_p.func_175623_d(new BlockPos(position).func_177977_b())) {
                return null;
            }
            Vector3d offset = position.func_178788_d(EntityNaga.this.func_213303_ch());
            AxisAlignedBB newBB = EntityNaga.this.func_174813_aQ().func_191194_a(offset);
            if (EntityNaga.this.field_70170_p.func_226664_a_(newBB) && EntityNaga.this.field_70170_p.func_217299_a(new RayTraceContext(EntityNaga.this.func_213303_ch(), position, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)EntityNaga.this)).func_216346_c() != RayTraceResult.Type.BLOCK) {
                return position;
            }
            return null;
        }
    }

    static class AILookAround
    extends Goal {
        private final EntityNaga parentEntity;

        public AILookAround(EntityNaga naga) {
            this.parentEntity = naga;
            this.func_220684_a(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return true;
        }

        public void func_75246_d() {
            if (this.parentEntity.func_70638_az() == null) {
                Vector3d motion = this.parentEntity.func_213322_ci();
                this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)motion.field_72450_a, (double)motion.field_72449_c)) * 57.295776f;
            } else {
                LivingEntity entitylivingbase = this.parentEntity.func_70638_az();
                if (entitylivingbase.func_70068_e((Entity)this.parentEntity) < 1600.0) {
                    double d1 = entitylivingbase.func_226277_ct_() - this.parentEntity.func_226277_ct_();
                    double d2 = entitylivingbase.func_226281_cx_() - this.parentEntity.func_226281_cx_();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)d1, (double)d2)) * 57.295776f;
                }
            }
        }
    }

    public static enum EnumNagaMovement {
        GLIDING,
        HOVERING,
        SWIMMING,
        FALLING,
        FALLEN;

    }
}

