/*
 * Decompiled with CFR 0.152.
 */
package com.bobmowzie.mowziesmobs.server.message;

import com.bobmowzie.mowziesmobs.server.capability.CapabilityHandler;
import com.bobmowzie.mowziesmobs.server.capability.FrozenCapability;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class MessageFreezeEffect {
    private int entityID;
    private boolean isFrozen;

    public MessageFreezeEffect() {
    }

    public MessageFreezeEffect(LivingEntity entity, boolean activate) {
        this.entityID = entity.func_145782_y();
        this.isFrozen = activate;
    }

    public static void serialize(MessageFreezeEffect message, PacketBuffer buf) {
        buf.func_150787_b(message.entityID);
        buf.writeBoolean(message.isFrozen);
    }

    public static MessageFreezeEffect deserialize(PacketBuffer buf) {
        MessageFreezeEffect message = new MessageFreezeEffect();
        message.entityID = buf.func_150792_a();
        message.isFrozen = buf.readBoolean();
        return message;
    }

    public static class Handler
    implements BiConsumer<MessageFreezeEffect, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(MessageFreezeEffect message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                LivingEntity living;
                FrozenCapability.IFrozenCapability livingCapability;
                Entity entity;
                if (Minecraft.func_71410_x().field_71441_e != null && (entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityID)) instanceof LivingEntity && (livingCapability = CapabilityHandler.getCapability((Entity)(living = (LivingEntity)entity), FrozenCapability.FrozenProvider.FROZEN_CAPABILITY)) != null) {
                    if (message.isFrozen) {
                        livingCapability.onFreeze(living);
                    } else {
                        livingCapability.onUnfreeze(living);
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

