/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.goblintraders.entity;

import com.mrcrayfish.goblintraders.Config;
import com.mrcrayfish.goblintraders.entity.AbstractGoblinEntity;
import com.mrcrayfish.goblintraders.entity.TraderCreatureEntity;
import com.mrcrayfish.goblintraders.init.ModEntities;
import com.mrcrayfish.goblintraders.trades.EntityTrades;
import com.mrcrayfish.goblintraders.trades.TradeManager;
import com.mrcrayfish.goblintraders.trades.TradeRarity;
import java.util.List;
import java.util.Map;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class VeinGoblinTraderEntity
extends AbstractGoblinEntity {
    public VeinGoblinTraderEntity(Level level) {
        super((EntityType<? extends TraderCreatureEntity>)((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get()), level);
    }

    @Override
    public ResourceLocation getTexture() {
        return new ResourceLocation("goblintraders", "textures/entity/vein_goblin_trader.png");
    }

    @Override
    protected void populateTradeData() {
        MerchantOffers offers = this.m_6616_();
        EntityTrades entityTrades = TradeManager.instance().getTrades((EntityType<? extends TraderCreatureEntity>)((EntityType)ModEntities.VEIN_GOBLIN_TRADER.get()));
        if (entityTrades != null) {
            Map<TradeRarity, List<VillagerTrades.ItemListing>> tradeMap = entityTrades.getTradeMap();
            for (TradeRarity rarity : TradeRarity.values()) {
                List<VillagerTrades.ItemListing> trades = tradeMap.get((Object)rarity);
                int min = rarity.getMaximum().apply(trades, this.m_21187_());
                int max = rarity.getMaximum().apply(trades, this.m_21187_());
                this.addTrades(offers, trades, Math.max(min, max), rarity.shouldShuffle());
            }
        }
    }

    @Override
    public ItemStack getFavouriteFood() {
        return new ItemStack((ItemLike)Items.f_42619_);
    }

    public void m_8107_() {
        if (this.f_19853_.m_5776_() && this.f_19797_ % 2 == 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() - 0.5 + this.m_21187_().nextDouble(), this.m_20186_() + 0.5 - 0.5 + this.m_21187_().nextDouble(), this.m_20189_() - 0.5 + this.m_21187_().nextDouble(), 0.0, 0.0, 0.0);
        }
        super.m_8107_();
    }

    public boolean m_5825_() {
        return true;
    }

    @Override
    protected int getMaxRestockDelay() {
        return (Integer)Config.COMMON.veinGoblinTrader.restockDelay.get();
    }

    @Override
    public boolean canAttackBack() {
        return (Boolean)Config.COMMON.veinGoblinTrader.canAttackBack.get();
    }
}

