/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.absentbydesign.registry;

import com.lothrazar.absentbydesign.IHasRecipe;
import com.lothrazar.absentbydesign.ModAbsentBD;
import com.lothrazar.absentbydesign.block.BlockAbsentFence;
import com.lothrazar.absentbydesign.block.BlockAbsentSlab;
import com.lothrazar.absentbydesign.block.BlockAbsentSlabDouble;
import com.lothrazar.absentbydesign.block.BlockAbsentSlabHalf;
import com.lothrazar.absentbydesign.block.BlockAbsentStairs;
import com.lothrazar.absentbydesign.block.BlockAbsentWall;
import com.lothrazar.absentbydesign.block.ItemBlockAbsentSlab;
import com.lothrazar.absentbydesign.registry.RecipeRegistry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistryModifiable;

public class AbsentRegistry {
    private static List<Item> itemList = new ArrayList<Item>();
    private static List<Block> blocks = new ArrayList<Block>();

    @SubscribeEvent
    public void onRegisterRecipe(RegistryEvent.Register<IRecipe> event) {
        IForgeRegistryModifiable modRegistry = (IForgeRegistryModifiable)event.getRegistry();
        for (IRecipe r : event.getRegistry()) {
            ItemStack output = r.func_77571_b();
            if (!ItemStack.func_77989_b((ItemStack)output, (ItemStack)new ItemStack((Block)Blocks.field_150333_U, 6, 5)) && !ItemStack.func_77989_b((ItemStack)output, (ItemStack)new ItemStack(Blocks.field_150390_bg, 4, 0))) continue;
            modRegistry.remove(r.getRegistryName());
        }
        RecipeRegistry.addShapedRecipe(new ItemStack((Block)Blocks.field_150333_U, 6, 5), "sss", Character.valueOf('s'), new ItemStack(Blocks.field_150417_aV, 1, 0));
        RecipeRegistry.addShapedRecipe(new ItemStack(Blocks.field_150390_bg, 4), "s  ", "ss ", "sss", Character.valueOf('s'), new ItemStack(Blocks.field_150417_aV, 1, 0));
        RecipeRegistry.addShapedRecipe(new ItemStack(Block.func_149684_b((String)"absentbydesign:slab_snow"), 3), "l", "l", "l", Character.valueOf('l'), new ItemStack(Blocks.field_150431_aC));
        event.getRegistry().registerAll((IForgeRegistryEntry[])RecipeRegistry.recipes.toArray(new IRecipe[0]));
    }

    @SubscribeEvent
    public void onRegistryEvent(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])blocks.toArray(new Block[0]));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : itemList) {
            Block blockItem;
            event.getRegistry().register((IForgeRegistryEntry)item);
            if (item instanceof IHasRecipe) {
                ((IHasRecipe)item).addRecipe();
            }
            if (!((blockItem = Block.func_149634_a((Item)item)) instanceof IHasRecipe)) continue;
            ((IHasRecipe)blockItem).addRecipe();
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (Block block : blocks) {
            Item item = Item.func_150898_a((Block)block);
            String name = "absentbydesign:" + block.func_149739_a().replaceAll("tile.", "");
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(name));
        }
    }

    public void createWall(Block baseType, ItemStack s, String name) {
        this.registerBlock(new BlockAbsentWall(baseType, s), "wall_" + name);
    }

    public void createStair(Block baseType, ItemStack ing, String name) {
        this.registerBlock((Block)new BlockAbsentStairs(baseType, ing), "stairs_" + name);
    }

    public void createFence(Block mat, ItemStack i, String name) {
        this.registerBlock((Block)new BlockAbsentFence(mat, i), "fence_" + name);
    }

    private Block registerBlock(Block block, String name) {
        return this.registerBlock(block, name, null);
    }

    private Block registerBlock(Block block, String name, @Nullable ItemBlock itemblock) {
        block.func_149647_a(ModAbsentBD.tab);
        block.setRegistryName(new ResourceLocation("absentbydesign", name));
        block.func_149663_c(name);
        blocks.add(block);
        ItemBlock ib = itemblock == null ? new ItemBlock(block) : itemblock;
        ib.setRegistryName(block.getRegistryName());
        this.addItem(ib);
        return block;
    }

    private void addItem(ItemBlock ib) {
        itemList.add((Item)ib);
    }

    private BlockAbsentSlab registerSlabBlock(BlockAbsentSlab block, String name) {
        block.func_149647_a(ModAbsentBD.tab);
        block.setRegistryName(new ResourceLocation("absentbydesign", name));
        block.func_149663_c(name);
        blocks.add((Block)block);
        return block;
    }

    public void createSlab(Block type, ItemStack i, String name) {
        name = "slab_" + name;
        BlockAbsentSlab half = this.registerSlabBlock(new BlockAbsentSlabHalf(type, i), name);
        BlockAbsentSlab dubs = this.registerSlabBlock(new BlockAbsentSlabDouble(type), name + "_double");
        this.registerSlabItem(new ItemBlockAbsentSlab(half, half, dubs), name);
    }

    private void registerSlabItem(ItemBlockAbsentSlab item, String string) {
        item.setRegistryName(string);
        item.func_77655_b(string);
        itemList.add((Item)item);
    }
}

