/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.absentbydesign.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class RecipeRegistry {
    private static Map<String, Boolean> usedRecipeNames = new HashMap<String, Boolean>();
    public static List<IRecipe> recipes = new ArrayList<IRecipe>();

    private static void add(IRecipe r, ResourceLocation location) {
        if (r == null) {
            return;
        }
        r.setRegistryName(location);
        recipes.add(r);
    }

    private static IRecipe _addShapedRecipe(ItemStack output, Object ... params) {
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        ShapedRecipes recipe = new ShapedRecipes(output.func_77973_b().getRegistryName().toString(), primer.width, primer.height, primer.input, output);
        RecipeRegistry.add((IRecipe)recipe, Util1pt12.buildName(output));
        return recipe;
    }

    public static IRecipe addShapedRecipe(@Nonnull ItemStack output, Object ... recipeComponents) {
        for (Object object : recipeComponents) {
            if (!(object instanceof String)) continue;
            return RecipeRegistry.addShapedOreRecipe(output, recipeComponents);
        }
        return RecipeRegistry._addShapedRecipe(output, recipeComponents);
    }

    private static IRecipe addShapedOreRecipe(ItemStack output, Object ... recipeComponents) {
        if (output.func_190926_b()) {
            throw new IllegalArgumentException("cannot add recipe for air");
        }
        ResourceLocation location = Util1pt12.buildName(output);
        ShapedOreRecipe recipe = new ShapedOreRecipe(location, output, recipeComponents);
        RecipeRegistry.add((IRecipe)recipe, Util1pt12.buildName(output));
        return recipe;
    }

    public static class Util1pt12 {
        public static ResourceLocation buildName(ItemStack output) {
            ResourceLocation firstTry = new ResourceLocation("absentbydesign", output.func_77977_a());
            int limit = 999;
            int index = 0;
            while (usedRecipeNames.containsKey(firstTry.toString()) || index > limit) {
                firstTry = new ResourceLocation("absentbydesign", firstTry.func_110623_a() + "_" + ++index);
            }
            usedRecipeNames.put(firstTry.toString(), true);
            return firstTry;
        }

        private static NonNullList<Ingredient> convertToNonNullList(Object[] input) {
            NonNullList list = NonNullList.func_191196_a();
            for (Object any : input) {
                if (any instanceof Ingredient) {
                    list.add((Object)((Ingredient)any));
                    continue;
                }
                Ingredient ing = CraftingHelper.getIngredient((Object)any);
                if (ing == null) {
                    ing = Ingredient.field_193370_a;
                }
                list.add((Object)ing);
            }
            return list;
        }
    }
}

