/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.registry;

import com.obscuria.aquamirae.world.entities.Anglerfish;
import com.obscuria.aquamirae.world.entities.CaptainCornelia;
import com.obscuria.aquamirae.world.entities.Eel;
import com.obscuria.aquamirae.world.entities.GoldenMoth;
import com.obscuria.aquamirae.world.entities.LuminousJelly;
import com.obscuria.aquamirae.world.entities.Maw;
import com.obscuria.aquamirae.world.entities.MazeMother;
import com.obscuria.aquamirae.world.entities.PillagersPatrol;
import com.obscuria.aquamirae.world.entities.Spinefish;
import com.obscuria.aquamirae.world.entities.TorturedSoul;
import com.obscuria.aquamirae.world.entities.chakras.MazeRose;
import com.obscuria.aquamirae.world.entities.chakras.PoisonedChakra;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class AquamiraeEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"aquamirae");
    public static final RegistryObject<EntityType<GoldenMoth>> GOLDEN_MOTH = AquamiraeEntities.register("golden_moth", EntityType.Builder.m_20704_(GoldenMoth::new, (MobCategory)MobCategory.AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(GoldenMoth::new).m_20719_().m_20699_(0.5f, 0.2f));
    public static final RegistryObject<EntityType<Maw>> MAW = AquamiraeEntities.register("maw", EntityType.Builder.m_20704_(Maw::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(Maw::new).m_20699_(1.2f, 1.2f));
    public static final RegistryObject<EntityType<Anglerfish>> ANGLERFISH = AquamiraeEntities.register("anglerfish", EntityType.Builder.m_20704_(Anglerfish::new, (MobCategory)MobCategory.WATER_CREATURE).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(Anglerfish::new).m_20699_(2.0f, 2.6f));
    public static final RegistryObject<EntityType<MazeMother>> MAZE_MOTHER = AquamiraeEntities.register("maze_mother", EntityType.Builder.m_20704_(MazeMother::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(MazeMother::new).m_20699_(8.0f, 3.0f));
    public static final RegistryObject<EntityType<CaptainCornelia>> CAPTAIN_CORNELIA = AquamiraeEntities.register("captain_cornelia", EntityType.Builder.m_20704_(CaptainCornelia::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(CaptainCornelia::new).m_20719_().m_20699_(0.6f, 2.3f));
    public static final RegistryObject<EntityType<PillagersPatrol>> PILLAGERS_PATROL = AquamiraeEntities.register("pillagers_patrol", EntityType.Builder.m_20704_(PillagersPatrol::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(false).setTrackingRange(8).setUpdateInterval(3).setCustomClientFactory(PillagersPatrol::new).m_20719_().m_20699_(1.0f, 1.0f));
    public static final RegistryObject<EntityType<TorturedSoul>> TORTURED_SOUL = AquamiraeEntities.register("tortured_soul", EntityType.Builder.m_20704_(TorturedSoul::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(TorturedSoul::new).m_20699_(0.6f, 1.8f));
    public static final RegistryObject<EntityType<Eel>> EEL = AquamiraeEntities.register("eel", EntityType.Builder.m_20704_(Eel::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).setCustomClientFactory(Eel::new).m_20699_(2.4f, 3.4f));
    public static final RegistryObject<EntityType<MazeRose>> MAZE_ROSE = AquamiraeEntities.register("maze_rose", EntityType.Builder.m_20704_(MazeRose::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(MazeRose::new).m_20699_(0.7f, 0.125f));
    public static final RegistryObject<EntityType<PoisonedChakra>> POISONED_CHAKRA = AquamiraeEntities.register("poisoned_chakra", EntityType.Builder.m_20704_(PoisonedChakra::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(PoisonedChakra::new).m_20699_(0.7f, 0.125f));
    public static final RegistryObject<EntityType<Spinefish>> SPINEFISH = AquamiraeEntities.register("spinefish", EntityType.Builder.m_20704_(Spinefish::new, (MobCategory)MobCategory.WATER_AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(Spinefish::new).m_20699_(0.7f, 0.7f));
    public static final RegistryObject<EntityType<LuminousJelly>> LUMINOUS_JELLY = AquamiraeEntities.register("luminous_jelly", EntityType.Builder.m_20704_(LuminousJelly::new, (MobCategory)MobCategory.WATER_AMBIENT).setShouldReceiveVelocityUpdates(true).setTrackingRange(128).setUpdateInterval(3).setCustomClientFactory(LuminousJelly::new).m_20699_(0.5f, 0.9f));

    private static <T extends Entity> RegistryObject<EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.m_20712_(registryname));
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)GOLDEN_MOTH.get(), GoldenMoth.createAttributes().m_22265_());
        event.put((EntityType)MAW.get(), Maw.createAttributes().m_22265_());
        event.put((EntityType)ANGLERFISH.get(), Anglerfish.createAttributes().m_22265_());
        event.put((EntityType)MAZE_MOTHER.get(), MazeMother.createAttributes().m_22265_());
        event.put((EntityType)CAPTAIN_CORNELIA.get(), CaptainCornelia.createAttributes().m_22265_());
        event.put((EntityType)PILLAGERS_PATROL.get(), Mob.m_21552_().m_22265_());
        event.put((EntityType)TORTURED_SOUL.get(), TorturedSoul.createAttributes().m_22265_());
        event.put((EntityType)EEL.get(), Eel.createAttributes().m_22265_());
        event.put((EntityType)SPINEFISH.get(), Mob.m_21552_().m_22265_());
        event.put((EntityType)LUMINOUS_JELLY.get(), Mob.m_21552_().m_22265_());
        event.put((EntityType)POISONED_CHAKRA.get(), Mob.m_21552_().m_22265_());
        event.put((EntityType)MAZE_ROSE.get(), Mob.m_21552_().m_22265_());
    }

    @SubscribeEvent
    public static void registerSpawns(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SpawnPlacements.m_21754_((EntityType)((EntityType)GOLDEN_MOTH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.NO_RESTRICTIONS, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> {
                Level level;
                return world instanceof Level && !(level = (Level)world).m_46461_();
            });
            SpawnPlacements.m_21754_((EntityType)((EntityType)SPINEFISH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_8055_(pos).m_60734_() instanceof LiquidBlock);
            SpawnPlacements.m_21754_((EntityType)((EntityType)MAW.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> pos.m_123342_() < world.m_5736_() + 6);
            SpawnPlacements.m_21754_((EntityType)((EntityType)ANGLERFISH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.IN_WATER, (Heightmap.Types)Heightmap.Types.OCEAN_FLOOR, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL);
            SpawnPlacements.m_21754_((EntityType)((EntityType)PILLAGERS_PATROL.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> Mob.m_21400_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random) && world.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)random));
            SpawnPlacements.m_21754_((EntityType)((EntityType)TORTURED_SOUL.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> Mob.m_21400_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random) && world.m_46791_() != Difficulty.PEACEFUL && Monster.m_33008_((ServerLevelAccessor)world, (BlockPos)pos, (Random)random));
        });
    }
}

