/*
 * Decompiled with CFR 0.152.
 */
package com.obscuria.aquamirae.world.items.armor;

import com.obscuria.aquamirae.AquamiraeMod;
import com.obscuria.aquamirae.client.models.armor.ModelAbyssalArmor;
import com.obscuria.aquamirae.registry.AquamiraeItems;
import com.obscuria.aquamirae.registry.AquamiraeMobEffects;
import com.obscuria.aquamirae.world.items.armor.AbyssalArmorItem;
import com.obscuria.obscureapi.ObscureAPI;
import com.obscuria.obscureapi.world.classes.IAbilityItem;
import com.obscuria.obscureapi.world.classes.IBonusItem;
import com.obscuria.obscureapi.world.classes.IClassItem;
import com.obscuria.obscureapi.world.classes.ObscureAbility;
import com.obscuria.obscureapi.world.classes.ObscureBonus;
import com.obscuria.obscureapi.world.classes.ObscureClass;
import com.obscuria.obscureapi.world.classes.ObscureType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;

public abstract class AbyssalTiaraItem
extends ArmorItem
implements IClassItem,
IAbilityItem,
IBonusItem {
    public final ObscureAbility ABILITY_HALFSET = new ObscureAbility((Item)this, "abyssal_armor_half", ObscureAbility.Cost.NONE, 0);
    public final ObscureAbility ABILITY_FULLSET_1 = new ObscureAbility((Item)this, "abyssal_armor_full_1", ObscureAbility.Cost.NONE, 0, 30);
    public final ObscureAbility ABILITY_FULLSET_2 = new ObscureAbility((Item)this, "abyssal_armor_full_2", ObscureAbility.Cost.NONE, 0);
    public final ObscureBonus BONUS = new ObscureBonus(AquamiraeMod.SEA_WOLF, ObscureAPI.Types.WEAPON, ObscureBonus.Type.POWER, ObscureBonus.Operation.AMOUNT, 3);

    public AbyssalTiaraItem(EquipmentSlot slot, Item.Properties properties) {
        super(new ArmorMaterial(){

            public int m_7366_(@NotNull EquipmentSlot slot) {
                return (new int[]{13, 15, 16, 11})[slot.m_20749_()] * 40;
            }

            public int m_7365_(@NotNull EquipmentSlot slot) {
                return (new int[]{3, 6, 8, 2})[slot.m_20749_()];
            }

            public int m_6646_() {
                return 12;
            }

            @NotNull
            public SoundEvent m_7344_() {
                return SoundEvents.f_11679_;
            }

            @NotNull
            public Ingredient m_6230_() {
                return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)AquamiraeItems.SHIP_GRAVEYARD_ECHO.get()), new ItemStack((ItemLike)AquamiraeItems.ABYSSAL_AMETHYST.get())});
            }

            @NotNull
            public String m_6082_() {
                return "abyssal_extra";
            }

            public float m_6651_() {
                return 0.0f;
            }

            public float m_6649_() {
                return 0.0f;
            }
        }, slot, properties.m_41497_(Rarity.EPIC).m_41491_(AquamiraeMod.TAB));
    }

    public List<ObscureAbility> getObscureAbilities() {
        return Arrays.asList(this.ABILITY_FULLSET_2, this.ABILITY_FULLSET_1, this.ABILITY_HALFSET);
    }

    public List<ObscureBonus> getObscureBonuses() {
        return Collections.singletonList(this.BONUS);
    }

    public ObscureClass getObscureClass() {
        return AquamiraeMod.SEA_WOLF;
    }

    public ObscureType getObscureType() {
        return ObscureAPI.Types.ARMOR;
    }

    public void onArmorTick(ItemStack itemstack, Level world, Player entity) {
        if (entity.m_6844_(EquipmentSlot.CHEST).m_41720_() instanceof AbyssalArmorItem && entity.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof AbyssalArmorItem && entity.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof AbyssalArmorItem) {
            Vec3 center = new Vec3(entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_());
            List<Monster> list = world.m_6443_(Monster.class, new AABB(center, center).m_82400_(4.0), e -> true).stream().sorted(Comparator.comparingDouble(entities -> entities.m_20238_(center))).toList();
            for (Monster monster : list) {
                monster.m_7292_(new MobEffectInstance((MobEffect)AquamiraeMobEffects.ABYSS_BLINDNESS.get(), 10, 0, false, false));
            }
            double radius = 4.0;
            world.m_7106_((ParticleOptions)ParticleTypes.f_123799_, entity.m_20185_() + Math.cos((double)entity.f_19797_ * 0.05) * 4.0, entity.m_20186_() + 0.5, entity.m_20189_() + Math.sin((double)entity.f_19797_ * 0.05) * 4.0, 0.0, 0.0, 0.0);
            world.m_7106_((ParticleOptions)ParticleTypes.f_123799_, entity.m_20185_() + Math.cos((double)entity.f_19797_ * 0.05 + 3.12) * 4.0, entity.m_20186_() + 0.5, entity.m_20189_() + Math.sin((double)entity.f_19797_ * 0.05 + 3.12) * 4.0, 0.0, 0.0, 0.0);
        }
    }

    public static class Helmet
    extends AbyssalTiaraItem {
        public Helmet() {
            super(EquipmentSlot.HEAD, new Item.Properties());
        }

        public void initializeClient(Consumer<IItemRenderProperties> consumer) {
            consumer.accept(new IItemRenderProperties(){

                @NotNull
                public HumanoidModel<? extends LivingEntity> getArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel defaultModel) {
                    HumanoidModel armorModel = new HumanoidModel(new ModelPart(Collections.emptyList(), Map.of("head", new ModelAbyssalArmor<T>((ModelPart)Minecraft.m_91087_().m_167973_().m_171103_((ModelLayerLocation)ModelAbyssalArmor.LAYER_LOCATION)).tiara, "hat", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "body", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_arm", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "right_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()), "left_leg", new ModelPart(Collections.emptyList(), Collections.emptyMap()))));
                    armorModel.f_102817_ = living.m_6144_();
                    armorModel.f_102609_ = defaultModel.f_102609_;
                    armorModel.f_102610_ = living.m_6162_();
                    return armorModel;
                }
            });
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "aquamirae:textures/entity/armor/abyssal_tiara.png";
        }
    }
}

