/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.recipes.cache.chemical;

import java.util.function.LongSupplier;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.annotations.FieldsAreNonnullByDefault;
import mekanism.api.annotations.NonNull;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.cache.CachedRecipe;
import mekanism.api.recipes.chemical.ItemStackChemicalToItemStackRecipe;
import mekanism.api.recipes.inputs.IInputHandler;
import mekanism.api.recipes.inputs.ILongInputHandler;
import mekanism.api.recipes.inputs.InputIngredient;
import mekanism.api.recipes.inputs.chemical.IChemicalStackIngredient;
import mekanism.api.recipes.outputs.IOutputHandler;
import net.minecraft.item.ItemStack;

@FieldsAreNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemStackChemicalToItemStackCachedRecipe<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>, INGREDIENT extends IChemicalStackIngredient<CHEMICAL, STACK>, RECIPE extends ItemStackChemicalToItemStackRecipe<CHEMICAL, STACK, INGREDIENT>>
extends CachedRecipe<RECIPE> {
    private final IOutputHandler<@NonNull ItemStack> outputHandler;
    private final IInputHandler<@NonNull ItemStack> itemInputHandler;
    private final ILongInputHandler<@NonNull STACK> chemicalInputHandler;
    private final LongSupplier chemicalUsage;
    private long chemicalUsageMultiplier;

    public ItemStackChemicalToItemStackCachedRecipe(RECIPE recipe, IInputHandler<@NonNull ItemStack> itemInputHandler, ILongInputHandler<@NonNull STACK> chemicalInputHandler, LongSupplier chemicalUsage, IOutputHandler<@NonNull ItemStack> outputHandler) {
        super(recipe);
        this.itemInputHandler = itemInputHandler;
        this.chemicalInputHandler = chemicalInputHandler;
        this.chemicalUsage = chemicalUsage;
        this.outputHandler = outputHandler;
    }

    @Override
    protected void setupVariableValues() {
        this.chemicalUsageMultiplier = this.chemicalUsage.getAsLong();
    }

    @Override
    protected int getOperationsThisTick(int currentMax) {
        if ((currentMax = super.getOperationsThisTick(currentMax)) <= 0) {
            return currentMax;
        }
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((ItemStackChemicalToItemStackRecipe)this.recipe).getItemInput());
        if (recipeItem.func_190926_b()) {
            return -1;
        }
        ChemicalStack recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient<STACK>)((ItemStackChemicalToItemStackRecipe)this.recipe).getChemicalInput());
        if (recipeChemical.isEmpty()) {
            return 0;
        }
        currentMax = this.itemInputHandler.operationsCanSupport(((ItemStackChemicalToItemStackRecipe)this.recipe).getItemInput(), currentMax);
        if (currentMax <= 0) {
            return -1;
        }
        currentMax = this.chemicalInputHandler.operationsCanSupport((InputIngredient<STACK>)((ItemStackChemicalToItemStackRecipe)this.recipe).getChemicalInput(), currentMax, this.chemicalUsageMultiplier);
        return this.outputHandler.operationsRoomFor(((ItemStackChemicalToItemStackRecipe)this.recipe).getOutput(recipeItem, recipeChemical), currentMax);
    }

    @Override
    public boolean isInputValid() {
        ChemicalStack chemicalStack = (ChemicalStack)this.chemicalInputHandler.getInput();
        if (!chemicalStack.isEmpty() && ((ItemStackChemicalToItemStackRecipe)this.recipe).test(this.itemInputHandler.getInput(), chemicalStack)) {
            ChemicalStack recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient<STACK>)((ItemStackChemicalToItemStackRecipe)this.recipe).getChemicalInput());
            return !recipeChemical.isEmpty() && chemicalStack.getAmount() >= recipeChemical.getAmount();
        }
        return false;
    }

    @Override
    protected void useResources(int operations) {
        super.useResources(operations);
        ChemicalStack recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient<STACK>)((ItemStackChemicalToItemStackRecipe)this.recipe).getChemicalInput());
        if (recipeChemical.isEmpty()) {
            return;
        }
        this.chemicalInputHandler.use(recipeChemical, (long)operations * this.chemicalUsageMultiplier);
    }

    @Override
    protected void finishProcessing(int operations) {
        ItemStack recipeItem = this.itemInputHandler.getRecipeInput(((ItemStackChemicalToItemStackRecipe)this.recipe).getItemInput());
        if (recipeItem.func_190926_b()) {
            return;
        }
        ChemicalStack recipeChemical = (ChemicalStack)this.chemicalInputHandler.getRecipeInput((InputIngredient<STACK>)((ItemStackChemicalToItemStackRecipe)this.recipe).getChemicalInput());
        if (recipeChemical.isEmpty()) {
            return;
        }
        this.itemInputHandler.use(recipeItem, operations);
        this.chemicalInputHandler.use((STACK)recipeChemical, operations);
        this.outputHandler.handleOutput(((ItemStackChemicalToItemStackRecipe)this.recipe).getOutput(recipeItem, recipeChemical), operations);
    }
}

