/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import mekanism.api.math.FloatingLong;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiEnergyGauge;
import mekanism.client.gui.element.tab.GuiAmplifierTab;
import mekanism.client.gui.element.tab.GuiRedstoneControlTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.text.GuiTextField;
import mekanism.client.gui.element.text.InputValidator;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.network.PacketGuiInteract;
import mekanism.common.network.PacketGuiSetEnergy;
import mekanism.common.tile.laser.TileEntityLaserAmplifier;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.text.EnergyDisplay;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiLaserAmplifier
extends GuiMekanismTile<TileEntityLaserAmplifier, MekanismTileContainer<TileEntityLaserAmplifier>> {
    private GuiTextField minField;
    private GuiTextField maxField;
    private GuiTextField timerField;

    public GuiLaserAmplifier(MekanismTileContainer<TileEntityLaserAmplifier> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new GuiEnergyGauge(((TileEntityLaserAmplifier)this.tile).getEnergyContainer(), GaugeType.STANDARD, (IGuiWrapper)this, 6, 10));
        this.func_230480_a_(new GuiSecurityTab((IGuiWrapper)this, this.tile));
        this.func_230480_a_(new GuiRedstoneControlTab(this, this.tile));
        this.func_230480_a_(new GuiAmplifierTab(this, (TileEntityLaserAmplifier)this.tile));
        this.timerField = new GuiTextField(this, 96, 28, 36, 11);
        this.func_230480_a_(this.timerField);
        this.timerField.setMaxStringLength(4);
        this.timerField.setEnterHandler(this::setTime);
        this.timerField.setInputValidator(InputValidator.DIGIT);
        this.minField = new GuiTextField(this, 96, 43, 72, 11);
        this.func_230480_a_(this.minField);
        this.minField.setMaxStringLength(10);
        this.minField.setEnterHandler(this::setMinThreshold);
        this.minField.setInputValidator(InputValidator.SCI_NOTATION);
        this.maxField = new GuiTextField(this, 96, 58, 72, 11);
        this.func_230480_a_(this.maxField);
        this.maxField.setMaxStringLength(10);
        this.maxField.setEnterHandler(this::setMaxThreshold);
        this.maxField.setInputValidator(InputValidator.SCI_NOTATION);
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        if (((TileEntityLaserAmplifier)this.tile).time > 0) {
            this.drawString(matrix, (ITextComponent)MekanismLang.DELAY.translate(((TileEntityLaserAmplifier)this.tile).time), 26, 30, this.titleTextColor());
        } else {
            this.drawString(matrix, (ITextComponent)MekanismLang.NO_DELAY.translate(new Object[0]), 26, 30, this.titleTextColor());
        }
        this.drawString(matrix, (ITextComponent)MekanismLang.MIN.translate(EnergyDisplay.of(((TileEntityLaserAmplifier)this.tile).minThreshold)), 26, 45, this.titleTextColor());
        this.drawString(matrix, (ITextComponent)MekanismLang.MAX.translate(EnergyDisplay.of(((TileEntityLaserAmplifier)this.tile).maxThreshold)), 26, 60, this.titleTextColor());
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    private void setMinThreshold() {
        if (!this.minField.getText().isEmpty()) {
            try {
                Mekanism.packetHandler.sendToServer(new PacketGuiSetEnergy(PacketGuiSetEnergy.GuiEnergyValue.MIN_THRESHOLD, ((TileEntityLaserAmplifier)this.tile).func_174877_v(), MekanismUtils.convertToJoules(FloatingLong.parseFloatingLong(this.minField.getText()))));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.minField.setText("");
        }
    }

    private void setMaxThreshold() {
        if (!this.maxField.getText().isEmpty()) {
            try {
                Mekanism.packetHandler.sendToServer(new PacketGuiSetEnergy(PacketGuiSetEnergy.GuiEnergyValue.MAX_THRESHOLD, ((TileEntityLaserAmplifier)this.tile).func_174877_v(), MekanismUtils.convertToJoules(FloatingLong.parseFloatingLong(this.maxField.getText()))));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.maxField.setText("");
        }
    }

    private void setTime() {
        if (!this.timerField.getText().isEmpty()) {
            Mekanism.packetHandler.sendToServer(new PacketGuiInteract(PacketGuiInteract.GuiInteraction.SET_TIME, (TileEntity)this.tile, Integer.parseInt(this.timerField.getText())));
            this.timerField.setText("");
        }
    }
}

