/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.machine;

import com.mojang.blaze3d.matrix.MatrixStack;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mekanism.client.gui.GuiConfigurableTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiElementHolder;
import mekanism.client.gui.element.button.FilterButton;
import mekanism.client.gui.element.button.TranslationButton;
import mekanism.client.gui.element.filter.GuiOredictionificatorFilter;
import mekanism.client.gui.element.progress.GuiProgress;
import mekanism.client.gui.element.progress.ProgressType;
import mekanism.client.gui.element.scroll.GuiScrollBar;
import mekanism.client.gui.element.tab.GuiRedstoneControlTab;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.common.MekanismLang;
import mekanism.common.content.filter.IFilter;
import mekanism.common.inventory.container.tile.MekanismTileContainer;
import mekanism.common.lib.HashList;
import mekanism.common.tile.machine.TileEntityOredictionificator;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;

public class GuiOredictionificator
extends GuiConfigurableTile<TileEntityOredictionificator, MekanismTileContainer<TileEntityOredictionificator>> {
    private static final int FILTER_COUNT = 3;
    private final Map<TileEntityOredictionificator.OredictionificatorFilter, ItemStack> renderStacks = new Object2ObjectOpenHashMap();
    private GuiScrollBar scrollBar;

    public GuiOredictionificator(MekanismTileContainer<TileEntityOredictionificator> container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.field_147000_g += 64;
        this.field_238745_s_ = this.field_147000_g - 94;
        this.dynamicSlots = true;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new GuiElementHolder(this, 9, 17, 144, 68));
        this.func_230480_a_(new GuiElementHolder(this, 9, 85, 144, 22));
        this.scrollBar = new GuiScrollBar((IGuiWrapper)this, 153, 17, 90, () -> this.getFilters().size(), () -> 3);
        this.func_230480_a_(this.scrollBar);
        this.func_230480_a_(new GuiRedstoneControlTab(this, this.tile));
        this.func_230480_a_(new GuiSecurityTab((IGuiWrapper)this, this.tile));
        this.func_230480_a_(new GuiProgress(() -> ((TileEntityOredictionificator)this.tile).didProcess, ProgressType.LARGE_RIGHT, (IGuiWrapper)this, 64, 119));
        this.func_230480_a_(new TranslationButton(this, this.field_147003_i + 10, this.field_147009_r + 86, 142, 20, MekanismLang.BUTTON_NEW_FILTER, () -> this.addWindow(GuiOredictionificatorFilter.create(this, (TileEntityOredictionificator)this.tile))));
        for (int i = 0; i < 3; ++i) {
            this.func_230480_a_(new FilterButton((IGuiWrapper)this, 10, 18 + i * 22, 142, 22, i, this.scrollBar::getCurrentSelection, this::getFilters, this::onClick));
        }
    }

    protected HashList<TileEntityOredictionificator.OredictionificatorFilter> getFilters() {
        return ((TileEntityOredictionificator)this.tile).getFilters();
    }

    protected void onClick(IFilter<?> filter, int index) {
        if (filter instanceof TileEntityOredictionificator.OredictionificatorFilter) {
            this.addWindow(GuiOredictionificatorFilter.edit(this, (TileEntityOredictionificator)this.tile, (TileEntityOredictionificator.OredictionificatorFilter)filter));
        }
    }

    @Override
    protected void drawForegroundText(@Nonnull MatrixStack matrix, int mouseX, int mouseY) {
        this.renderTitleText(matrix);
        this.drawString(matrix, this.field_213127_e.func_145748_c_(), this.field_238744_r_, this.field_238745_s_, this.titleTextColor());
        HashList<TileEntityOredictionificator.OredictionificatorFilter> filters = this.getFilters();
        for (int i = 0; i < 3; ++i) {
            TileEntityOredictionificator.OredictionificatorFilter filter = filters.getOrNull(this.scrollBar.getCurrentSelection() + i);
            if (filter == null) continue;
            if (!this.renderStacks.containsKey(filter)) {
                this.updateRenderStacks();
            }
            int yStart = i * 22 + 18;
            this.renderItem(matrix, this.renderStacks.get(filter), 13, yStart + 3);
            this.drawString(matrix, (ITextComponent)MekanismLang.FILTER.translate(new Object[0]), 32, yStart + 2, this.titleTextColor());
            this.drawTextScaledBound(matrix, filter.getFilterText(), 32.0f, yStart + 2 + 9, this.titleTextColor(), 117.0f);
        }
        super.drawForegroundText(matrix, mouseX, mouseY);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        return this.scrollBar.adjustScroll(delta) || super.func_231043_a_(mouseX, mouseY, delta);
    }

    private void updateRenderStacks() {
        this.renderStacks.clear();
        for (TileEntityOredictionificator.OredictionificatorFilter filter : this.getFilters()) {
            this.renderStacks.put(filter, filter.getResult());
        }
    }
}

