/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.qio;

import java.util.List;
import java.util.UUID;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.button.MekanismImageButton;
import mekanism.client.gui.qio.GuiQIOFrequencySelect;
import mekanism.common.Mekanism;
import mekanism.common.content.qio.IQIOFrequencyHolder;
import mekanism.common.content.qio.QIOFrequency;
import mekanism.common.inventory.container.tile.QIOFrequencySelectTileContainer;
import mekanism.common.lib.frequency.Frequency;
import mekanism.common.lib.frequency.FrequencyType;
import mekanism.common.network.PacketGuiButtonPress;
import mekanism.common.network.PacketGuiSetFrequency;
import mekanism.common.network.PacketQIOSetColor;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.ITextComponent;

public class GuiQIOTileFrequencySelect
extends GuiQIOFrequencySelect<QIOFrequencySelectTileContainer> {
    private final IQIOFrequencyHolder tile;

    public GuiQIOTileFrequencySelect(QIOFrequencySelectTileContainer container, PlayerInventory inv, ITextComponent title) {
        super(container, inv, title);
        this.dynamicSlots = true;
        this.tile = (IQIOFrequencyHolder)container.getTileEntity();
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.func_230480_a_(new MekanismImageButton((IGuiWrapper)this, this.field_147003_i + 6, this.field_147009_r + 6, 14, this.getButtonLocation("back"), () -> Mekanism.packetHandler.sendToServer(new PacketGuiButtonPress(PacketGuiButtonPress.ClickedTileButton.BACK_BUTTON, (TileEntity)this.tile))));
    }

    @Override
    public void sendSetFrequency(Frequency.FrequencyIdentity identity) {
        Mekanism.packetHandler.sendToServer(PacketGuiSetFrequency.create(PacketGuiSetFrequency.FrequencyUpdate.SET_TILE, FrequencyType.QIO, identity, this.tile.getTilePos()));
    }

    @Override
    public void sendRemoveFrequency(Frequency.FrequencyIdentity identity) {
        Mekanism.packetHandler.sendToServer(PacketGuiSetFrequency.create(PacketGuiSetFrequency.FrequencyUpdate.REMOVE_TILE, FrequencyType.QIO, identity, this.tile.getTilePos()));
    }

    @Override
    public void sendColorUpdate(int extra) {
        QIOFrequency freq = this.getFrequency();
        if (freq != null) {
            Mekanism.packetHandler.sendToServer(PacketQIOSetColor.create(this.tile.getTilePos(), freq, extra));
        }
    }

    @Override
    public QIOFrequency getFrequency() {
        return this.tile.getQIOFrequency();
    }

    @Override
    public String getOwnerUsername() {
        return this.tile.getOwnerName();
    }

    @Override
    public UUID getOwnerUUID() {
        return this.tile.getOwnerUUID();
    }

    @Override
    public List<QIOFrequency> getPublicFrequencies() {
        return this.tile.getPublicFrequencies();
    }

    @Override
    public List<QIOFrequency> getPrivateFrequencies() {
        return this.tile.getPrivateFrequencies();
    }
}

