/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei;

import it.unimi.dsi.fastutil.ints.Int2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import mekanism.client.gui.GuiMekanism;
import mekanism.client.gui.element.GuiWindow;
import mekanism.client.jei.GuiElementHandler;
import mekanism.client.jei.interfaces.IJEIGhostTarget;
import mekanism.common.lib.LRU;
import mezz.jei.api.gui.handlers.IGhostIngredientHandler;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.Rectangle2d;

public class GhostIngredientHandler<GUI extends GuiMekanism<?>>
implements IGhostIngredientHandler<GUI> {
    public <INGREDIENT> List<IGhostIngredientHandler.Target<INGREDIENT>> getTargets(GUI gui, INGREDIENT ingredient, boolean doStart) {
        boolean hasTargets = false;
        int depth = 0;
        Int2ObjectLinkedOpenHashMap depthBasedTargets = new Int2ObjectLinkedOpenHashMap();
        Int2ObjectOpenHashMap layerIntersections = new Int2ObjectOpenHashMap();
        List<TargetInfo<INGREDIENT>> ghostTargets = this.getTargets(((GuiMekanism)gui).children(), ingredient);
        if (!ghostTargets.isEmpty()) {
            depthBasedTargets.put(depth, ghostTargets);
            hasTargets = true;
        }
        LRU.LRUIterator iter = ((GuiMekanism)gui).getWindowsDescendingIterator();
        while (iter.hasNext()) {
            GuiWindow window = (GuiWindow)iter.next();
            ++depth;
            if (hasTargets) {
                ArrayList<Rectangle2d> areas = new ArrayList<Rectangle2d>();
                areas.add(new Rectangle2d(window.field_230690_l_, window.field_230691_m_, window.func_230998_h_(), window.func_238483_d_()));
                areas.addAll(GuiElementHandler.getAreasFor(window.field_230690_l_, window.field_230691_m_, window.func_230998_h_(), window.func_238483_d_(), window.children()));
                layerIntersections.put(depth, areas);
            }
            if ((ghostTargets = this.getTargets(window.children(), ingredient)).isEmpty()) continue;
            depthBasedTargets.put(depth, ghostTargets);
            hasTargets = true;
        }
        if (!hasTargets) {
            return Collections.emptyList();
        }
        ArrayList<IGhostIngredientHandler.Target<INGREDIENT>> targets = new ArrayList<IGhostIngredientHandler.Target<INGREDIENT>>();
        ArrayList<Rectangle2d> coveredArea = new ArrayList<Rectangle2d>();
        Int2ObjectSortedMap.FastSortedEntrySet depthEntries = depthBasedTargets.int2ObjectEntrySet();
        ObjectBidirectionalIterator iter2 = depthEntries.fastIterator((Int2ObjectMap.Entry)depthEntries.last());
        while (iter2.hasPrevious()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iter2.previous();
            int targetDepth = entry.getIntKey();
            while (depth > targetDepth) {
                coveredArea.addAll((Collection)layerIntersections.get(depth));
                --depth;
            }
            for (TargetInfo ghostTarget : (List)entry.getValue()) {
                targets.addAll(ghostTarget.convertToTargets(coveredArea));
            }
        }
        return targets;
    }

    private <INGREDIENT> List<TargetInfo<INGREDIENT>> getTargets(List<? extends IGuiEventListener> children, INGREDIENT ingredient) {
        ArrayList<TargetInfo<INGREDIENT>> ghostTargets = new ArrayList<TargetInfo<INGREDIENT>>();
        for (IGuiEventListener iGuiEventListener : children) {
            IJEIGhostTarget ghostTarget;
            IJEIGhostTarget.IGhostIngredientConsumer ghostHandler;
            if (!(iGuiEventListener instanceof IJEIGhostTarget) || !(iGuiEventListener instanceof Widget) || (ghostHandler = (ghostTarget = (IJEIGhostTarget)iGuiEventListener).getGhostHandler()) == null || !ghostHandler.supportsIngredient(ingredient)) continue;
            Widget element = (Widget)iGuiEventListener;
            ghostTargets.add(new TargetInfo(ghostTarget, ghostHandler, element.field_230690_l_, element.field_230691_m_, element.func_230998_h_(), element.func_238483_d_()));
        }
        return ghostTargets;
    }

    public void onComplete() {
    }

    private static void addVisibleAreas(List<Rectangle2d> visible, Rectangle2d area, List<Rectangle2d> coveredArea) {
        boolean intersected = false;
        int x = area.func_199318_a();
        int x2 = x + area.func_199316_c();
        int y = area.func_199319_b();
        int y2 = y + area.func_199317_d();
        int size = coveredArea.size();
        for (int i = 0; i < size; ++i) {
            Rectangle2d covered = coveredArea.get(i);
            int cx = covered.func_199318_a();
            int cx2 = cx + covered.func_199316_c();
            int cy = covered.func_199319_b();
            int cy2 = cy + covered.func_199317_d();
            if (x >= cx2 || x2 <= cx || y >= cy2 || y2 <= cy) continue;
            intersected = true;
            if (x >= cx && y >= cy && x2 <= cx2 && y2 <= cy2) break;
            List<Rectangle2d> uncoveredArea = GhostIngredientHandler.getVisibleArea(area, covered);
            if (i + 1 == size) {
                visible.addAll(uncoveredArea);
                break;
            }
            List<Rectangle2d> coveredAreas = coveredArea.subList(i + 1, size);
            for (Rectangle2d visibleArea : uncoveredArea) {
                GhostIngredientHandler.addVisibleAreas(visible, visibleArea, coveredAreas);
            }
            break;
        }
        if (!intersected) {
            visible.add(area);
        }
    }

    private static List<Rectangle2d> getVisibleArea(Rectangle2d area, Rectangle2d coveredArea) {
        int x = area.func_199318_a();
        int x2 = x + area.func_199316_c();
        int y = area.func_199319_b();
        int y2 = y + area.func_199317_d();
        int cx = coveredArea.func_199318_a();
        int cx2 = cx + coveredArea.func_199316_c();
        int cy = coveredArea.func_199319_b();
        int cy2 = cy + coveredArea.func_199317_d();
        boolean intersectsTop = y >= cy && y <= cy2;
        boolean intersectsLeft = x >= cx && x <= cx2;
        boolean intersectsBottom = y2 >= cy && y2 <= cy2;
        boolean intersectsRight = x2 >= cx && x2 <= cx2;
        ArrayList<Rectangle2d> areas = new ArrayList<Rectangle2d>();
        if (intersectsTop && intersectsBottom) {
            if (intersectsLeft) {
                areas.add(new Rectangle2d(cx2, y, x2 - cx2, area.func_199317_d()));
            } else if (intersectsRight) {
                areas.add(new Rectangle2d(x, y, cx - x, area.func_199317_d()));
            } else {
                areas.add(new Rectangle2d(x, y, cx - x, area.func_199317_d()));
                areas.add(new Rectangle2d(cx2, y, x2 - cx2, area.func_199317_d()));
            }
        } else if (intersectsLeft && intersectsRight) {
            if (intersectsTop) {
                areas.add(new Rectangle2d(x, cy2, area.func_199316_c(), y2 - cy2));
            } else if (intersectsBottom) {
                areas.add(new Rectangle2d(x, y, area.func_199316_c(), cy - y));
            } else {
                areas.add(new Rectangle2d(x, y, area.func_199316_c(), cy - y));
                areas.add(new Rectangle2d(x, cy2, area.func_199316_c(), y2 - cy2));
            }
        } else if (intersectsTop && intersectsLeft) {
            areas.add(new Rectangle2d(x, cy2, area.func_199316_c(), y2 - cy2));
            areas.add(new Rectangle2d(cx2, y, x2 - cx2, cy2 - y));
        } else if (intersectsTop && intersectsRight) {
            areas.add(new Rectangle2d(x, y, cx - x, cy2 - y));
            areas.add(new Rectangle2d(x, cy2, area.func_199316_c(), y2 - cy2));
        } else if (intersectsBottom && intersectsLeft) {
            areas.add(new Rectangle2d(x, y, area.func_199316_c(), cy - y));
            areas.add(new Rectangle2d(cx2, cy, x2 - cx2, y2 - cy));
        } else if (intersectsBottom && intersectsRight) {
            areas.add(new Rectangle2d(x, y, area.func_199316_c(), cy - y));
            areas.add(new Rectangle2d(x, cy, cx - x, y2 - cy));
        } else if (intersectsTop) {
            areas.add(new Rectangle2d(x, y, cx - x, cy2 - y));
            areas.add(new Rectangle2d(x, cy2, area.func_199316_c(), y2 - cy2));
            areas.add(new Rectangle2d(cx2, y, x2 - cx2, cy2 - y));
        } else if (intersectsLeft) {
            areas.add(new Rectangle2d(x, y, area.func_199316_c(), cy - y));
            areas.add(new Rectangle2d(x, cy2, area.func_199316_c(), y2 - cy2));
            areas.add(new Rectangle2d(cx2, cy, x2 - cx2, coveredArea.func_199317_d()));
        } else if (intersectsBottom) {
            areas.add(new Rectangle2d(x, y, area.func_199316_c(), cy - y));
            areas.add(new Rectangle2d(x, cy, cx - x, y2 - cy));
            areas.add(new Rectangle2d(cx2, cy, x2 - cx2, y2 - cy));
        } else if (intersectsRight) {
            areas.add(new Rectangle2d(x, y, area.func_199316_c(), cy - y));
            areas.add(new Rectangle2d(x, cy, cx - x, coveredArea.func_199317_d()));
            areas.add(new Rectangle2d(x, cy2, area.func_199316_c(), y2 - cy2));
        } else {
            areas.add(new Rectangle2d(x, y, area.func_199316_c(), cy - y));
            areas.add(new Rectangle2d(x, cy, cx - x, coveredArea.func_199317_d()));
            areas.add(new Rectangle2d(x, cy2, area.func_199316_c(), y2 - cy2));
            areas.add(new Rectangle2d(cx2, cy, x2 - cx2, coveredArea.func_199317_d()));
        }
        return areas;
    }

    private static class TargetInfo<INGREDIENT> {
        private final IJEIGhostTarget.IGhostIngredientConsumer ghostHandler;
        private final int x;
        private final int y;
        private final int width;
        private final int height;

        public TargetInfo(IJEIGhostTarget ghostTarget, IJEIGhostTarget.IGhostIngredientConsumer ghostHandler, int x, int y, int width, int height) {
            this.ghostHandler = ghostHandler;
            int borderSize = ghostTarget.borderSize();
            this.x = x + borderSize;
            this.y = y + borderSize;
            this.width = width - 2 * borderSize;
            this.height = height - 2 * borderSize;
        }

        public List<IGhostIngredientHandler.Target<INGREDIENT>> convertToTargets(List<Rectangle2d> coveredArea) {
            ArrayList visibleAreas = new ArrayList();
            GhostIngredientHandler.addVisibleAreas(visibleAreas, new Rectangle2d(this.x, this.y, this.width, this.height), coveredArea);
            return visibleAreas.stream().map(visibleArea -> new IGhostIngredientHandler.Target<INGREDIENT>((Rectangle2d)visibleArea){
                final /* synthetic */ Rectangle2d val$visibleArea;
                {
                    this.val$visibleArea = rectangle2d;
                }

                public Rectangle2d getArea() {
                    return this.val$visibleArea;
                }

                public void accept(INGREDIENT ingredient) {
                    ghostHandler.accept(ingredient);
                }
            }).collect(Collectors.toList());
        }
    }
}

