/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.jei.machine;

import java.util.Collections;
import javax.annotation.Nonnull;
import mekanism.api.recipes.GasToGasRecipe;
import mekanism.api.recipes.inputs.chemical.GasStackIngredient;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiInnerScreen;
import mekanism.client.gui.element.bar.GuiBar;
import mekanism.client.gui.element.bar.GuiDynamicHorizontalRateBar;
import mekanism.client.gui.element.gauge.GaugeType;
import mekanism.client.gui.element.gauge.GuiGasGauge;
import mekanism.client.jei.BaseRecipeCategory;
import mekanism.client.jei.MekanismJEI;
import mekanism.common.MekanismLang;
import mekanism.common.lib.Color;
import mekanism.common.registries.MekanismBlocks;
import mekanism.common.registries.MekanismItems;
import mekanism.common.util.text.TextUtils;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.util.text.ITextComponent;

public class SPSRecipeCategory
extends BaseRecipeCategory<GasToGasRecipe> {
    private final IDrawable icon;

    public SPSRecipeCategory(IGuiHelper helper) {
        super(helper, MekanismBlocks.SPS_CASING.getRegistryName(), (ITextComponent)MekanismLang.SPS.translate(new Object[0]), 3, 12, 168, 74);
        this.icon = helper.createDrawableIngredient((Object)MekanismItems.ANTIMATTER_PELLET.getItemStack());
    }

    @Override
    protected void addGuiElements() {
        this.guiElements.add(new GuiInnerScreen(this, 26, 13, 122, 60));
        this.guiElements.add(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 6, 13));
        this.guiElements.add(GuiGasGauge.getDummy(GaugeType.STANDARD, this, 150, 13));
        this.guiElements.add(new GuiDynamicHorizontalRateBar((IGuiWrapper)this, new GuiBar.IBarInfoHandler(){

            @Override
            public ITextComponent getTooltip() {
                return MekanismLang.PROGRESS.translate(TextUtils.getPercent((double)SPSRecipeCategory.this.timer.getValue() / 20.0));
            }

            @Override
            public double getLevel() {
                return (double)SPSRecipeCategory.this.timer.getValue() / 20.0;
            }
        }, 6, 75, this.getWidth() - 8, Color.ColorFunction.scale(Color.rgbi(60, 45, 74), Color.rgbi(100, 30, 170))));
    }

    @Override
    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    @Nonnull
    public Class<? extends GasToGasRecipe> getRecipeClass() {
        return GasToGasRecipe.class;
    }

    public void setIngredients(GasToGasRecipe recipe, IIngredients ingredients) {
        ingredients.setInputLists(MekanismJEI.TYPE_GAS, Collections.singletonList(((GasStackIngredient)recipe.getInput()).getRepresentations()));
        ingredients.setOutput(MekanismJEI.TYPE_GAS, recipe.getOutputRepresentation());
    }

    public void setRecipe(IRecipeLayout recipeLayout, GasToGasRecipe recipe, @Nonnull IIngredients ingredients) {
        IGuiIngredientGroup gasStacks = recipeLayout.getIngredientsGroup(MekanismJEI.TYPE_GAS);
        this.initChemical(gasStacks, 0, true, 7 - this.xOffset, 14 - this.yOffset, 16, 58, ((GasStackIngredient)recipe.getInput()).getRepresentations(), true);
        this.initChemical(gasStacks, 2, false, 151 - this.xOffset, 14 - this.yOffset, 16, 58, Collections.singletonList(recipe.getOutputRepresentation()), true);
    }
}

